/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.workflow.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.baremaps.workflow.WorkflowException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public record UnzipFile(Path file, Path directory) implements Task
{
    private static final long THRESHOLD_ENTRIES = 10000L;
    private static final long THRESHOLD_SIZE = 0x280000000L;
    private static final double THRESHOLD_RATIO = 100.0;
    private static final Logger logger = LoggerFactory.getLogger(UnzipFile.class);

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path filePath = this.file.toAbsolutePath();
        Path directoryPath = this.directory.toAbsolutePath();
        try (ZipFile zipFile = new ZipFile(filePath.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            long totalSizeArchive = 0L;
            long totalEntryArchive = 0L;
            while (entries.hasMoreElements()) {
                ZipEntry ze = entries.nextElement();
                Path path = directoryPath.resolve(ze.getName());
                File file = path.toFile().getCanonicalFile();
                File directory = directoryPath.toFile().getCanonicalFile();
                if (!file.toPath().startsWith(directory.toPath())) {
                    throw new IOException("Entry is outside of the target directory");
                }
                Files.createDirectories(path.getParent(), new FileAttribute[0]);
                Files.write(path, new byte[0], StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING);
                try (BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(ze));
                     BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(path.toFile()));){
                    ++totalEntryArchive;
                    int nBytes = -1;
                    byte[] buffer = new byte[4096];
                    long totalSizeEntry = 0L;
                    while ((nBytes = input.read(buffer)) > 0) {
                        output.write(buffer, 0, nBytes);
                        totalSizeEntry += (long)nBytes;
                        totalSizeArchive += (long)nBytes;
                        double compressionRatio = (double)totalSizeEntry / (double)ze.getCompressedSize();
                        if (!(compressionRatio > 100.0)) continue;
                        throw new WorkflowException("Archive compression ratio is too high");
                    }
                    if (totalSizeArchive > 0x280000000L) {
                        throw new IOException("Archive is too large");
                    }
                    if (totalEntryArchive <= 10000L) continue;
                    throw new IOException("Archive contains too many entries");
                }
            }
        }
    }
}

