/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncContextMapThreadLocal;
import io.servicetalk.context.api.ContextMap;
import io.servicetalk.context.api.ContextMapHolder;
import java.util.Objects;
import java.util.function.BiFunction;

final class ContextPreservingBiFunction<T, U, V>
implements BiFunction<T, U, V> {
    private final ContextMap saved;
    private final BiFunction<T, U, V> delegate;

    ContextPreservingBiFunction(BiFunction<T, U, V> delegate, ContextMap contextMap) {
        this.saved = Objects.requireNonNull(contextMap);
        this.delegate = Objects.requireNonNull(delegate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V apply(T t, U u) {
        Thread currentThread = Thread.currentThread();
        if (currentThread instanceof ContextMapHolder) {
            ContextMapHolder asyncContextMapHolder = (ContextMapHolder)currentThread;
            ContextMap prev = asyncContextMapHolder.context();
            try {
                asyncContextMapHolder.context(this.saved);
                V v = this.delegate.apply(t, u);
                return v;
            }
            finally {
                asyncContextMapHolder.context(prev);
            }
        }
        return this.slowPath(t, u);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private V slowPath(T t, U u) {
        ContextMap prev = AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.get();
        try {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(this.saved);
            V v = this.delegate.apply(t, u);
            return v;
        }
        finally {
            AsyncContextMapThreadLocal.CONTEXT_THREAD_LOCAL.set(prev);
        }
    }
}

