/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import java.util.Objects;
import java.util.function.Predicate;

final class OnErrorCompleteCompletable
extends AbstractSynchronousCompletableOperator {
    private final Predicate<? super Throwable> predicate;

    OnErrorCompleteCompletable(Completable original, Predicate<? super Throwable> predicate) {
        super(original);
        this.predicate = Objects.requireNonNull(predicate);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new OnErrorCompleteSubscriber(subscriber, this.predicate);
    }

    private static final class OnErrorCompleteSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber subscriber;
        private final Predicate<? super Throwable> predicate;

        private OnErrorCompleteSubscriber(CompletableSource.Subscriber subscriber, Predicate<? super Throwable> predicate) {
            this.subscriber = subscriber;
            this.predicate = predicate;
        }

        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(cancellable);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        public void onError(Throwable t) {
            boolean predicateResult;
            try {
                predicateResult = this.predicate.test(t);
            }
            catch (Throwable cause) {
                this.subscriber.onError(cause);
                return;
            }
            if (predicateResult) {
                this.subscriber.onComplete();
            } else {
                this.subscriber.onError(t);
            }
        }
    }
}

