/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DelayedCancellableThenSubscription;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.EmptySubscriptions;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import io.servicetalk.context.api.ContextMap;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class SingleConcatWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Single<? extends T> original;
    private final Publisher<? extends T> next;
    private final boolean deferSubscribe;
    private final boolean propagateCancel;

    SingleConcatWithPublisher(Single<? extends T> original, Publisher<? extends T> next, boolean deferSubscribe, boolean propagateCancel) {
        this.original = original;
        this.next = Objects.requireNonNull(next, "next");
        this.deferSubscribe = deferSubscribe;
        this.propagateCancel = propagateCancel;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, ContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(this.deferSubscribe ? new ConcatDeferNextSubscriber<T>(subscriber, this.next, this.propagateCancel) : new ConcatSubscriber<T>(subscriber, this.next, this.propagateCancel), contextMap, contextProvider);
    }

    private static final class ConcatDeferNextSubscriber<T>
    extends AbstractConcatSubscriber<T> {
        private static final Object REQUESTED_ONE = new Object();
        private static final Object REQUESTED_MORE = new Object();
        private static final Object SINGLE_DELIVERING = new Object();
        private static final Object SINGLE_DELIVERED = new Object();

        ConcatDeferNextSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next, boolean propagateCancel) {
            super(target, next, propagateCancel);
        }

        public void onSuccess(@Nullable T result) {
            block6: {
                while (true) {
                    Object oldValue = this.mayBeResult;
                    assert (oldValue != SINGLE_DELIVERING);
                    assert (oldValue != SINGLE_DELIVERED);
                    assert (oldValue != PUBLISHER_SUBSCRIBED);
                    if (oldValue == CANCELLED || oldValue == TERMINAL) break block6;
                    if (oldValue == INITIAL) {
                        if (!mayBeResultUpdater.compareAndSet(this, INITIAL, result)) continue;
                        break block6;
                    }
                    if (oldValue == REQUESTED_ONE) {
                        if (!mayBeResultUpdater.compareAndSet(this, REQUESTED_ONE, SINGLE_DELIVERING)) continue;
                        this.emitSingleSuccessToTarget(result);
                        break block6;
                    }
                    if (oldValue == REQUESTED_MORE && mayBeResultUpdater.compareAndSet(this, REQUESTED_MORE, PUBLISHER_SUBSCRIBED)) break;
                }
                if (!this.tryEmitSingleSuccessToTarget(result)) break block6;
                this.next.subscribeInternal(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            Object oldVal;
            while ((oldVal = this.mayBeResult) != CANCELLED && oldVal != TERMINAL) {
                if (oldVal == PUBLISHER_SUBSCRIBED || oldVal == REQUESTED_MORE) {
                    super.request(n);
                    break;
                }
                if (!SubscriberUtils.isRequestNValid((long)n)) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, TERMINAL)) continue;
                    try {
                        this.superCancel();
                        break;
                    }
                    finally {
                        this.target.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                    }
                }
                if (oldVal == INITIAL) {
                    if (n > 1L) {
                        if (!mayBeResultUpdater.compareAndSet(this, INITIAL, REQUESTED_MORE)) continue;
                        super.request(n - 1L);
                        break;
                    }
                    assert (n == 1L);
                    if (!mayBeResultUpdater.compareAndSet(this, INITIAL, REQUESTED_ONE)) continue;
                    break;
                }
                if (oldVal == REQUESTED_ONE || oldVal == SINGLE_DELIVERING) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED_MORE)) continue;
                    super.request(n);
                    break;
                }
                if (oldVal == SINGLE_DELIVERED) {
                    if (!mayBeResultUpdater.compareAndSet(this, SINGLE_DELIVERED, PUBLISHER_SUBSCRIBED)) continue;
                    try {
                        super.request(n);
                        break;
                    }
                    finally {
                        this.next.subscribeInternal(this);
                    }
                }
                if (n > 1L) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, PUBLISHER_SUBSCRIBED)) continue;
                    Object tVal = oldVal;
                    if (!this.tryEmitSingleSuccessToTarget(tVal)) break;
                    try {
                        super.request(n - 1L);
                        break;
                    }
                    finally {
                        this.next.subscribeInternal(this);
                    }
                }
                if (!mayBeResultUpdater.compareAndSet(this, oldVal, SINGLE_DELIVERING)) continue;
                Object tVal = oldVal;
                this.emitSingleSuccessToTarget(tVal);
                break;
            }
        }

        private void emitSingleSuccessToTarget(@Nullable T result) {
            if (this.tryEmitSingleSuccessToTarget(result) && !mayBeResultUpdater.compareAndSet(this, SINGLE_DELIVERING, SINGLE_DELIVERED)) {
                if (mayBeResultUpdater.compareAndSet(this, REQUESTED_MORE, PUBLISHER_SUBSCRIBED)) {
                    this.next.subscribeInternal(this);
                } else {
                    Object oldValue = this.mayBeResult;
                    assert (oldValue == CANCELLED || oldValue == TERMINAL);
                }
            }
        }
    }

    private static final class ConcatSubscriber<T>
    extends AbstractConcatSubscriber<T> {
        private static final Object REQUESTED = new Object();

        ConcatSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next, boolean propagateCancel) {
            super(target, next, propagateCancel);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void onSuccess(@Nullable T result) {
            while (true) {
                Object oldValue = this.mayBeResult;
                assert (oldValue != PUBLISHER_SUBSCRIBED);
                if (oldValue == REQUESTED) {
                    if (!mayBeResultUpdater.compareAndSet(this, REQUESTED, PUBLISHER_SUBSCRIBED)) continue;
                    if (!this.tryEmitSingleSuccessToTarget(result)) return;
                    this.next.subscribeInternal(this);
                    return;
                }
                if (oldValue == CANCELLED || oldValue == TERMINAL || mayBeResultUpdater.compareAndSet(this, INITIAL, result)) return;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            Object oldVal;
            while ((oldVal = this.mayBeResult) != CANCELLED && oldVal != TERMINAL) {
                Object tVal;
                if (oldVal == REQUESTED || oldVal == PUBLISHER_SUBSCRIBED) {
                    super.request(n);
                    break;
                }
                if (!SubscriberUtils.isRequestNValid((long)n)) {
                    if (!mayBeResultUpdater.compareAndSet(this, oldVal, TERMINAL)) continue;
                    try {
                        this.superCancel();
                        break;
                    }
                    finally {
                        this.target.onError((Throwable)SubscriberUtils.newExceptionForInvalidRequestN((long)n));
                    }
                }
                if (!mayBeResultUpdater.compareAndSet(this, oldVal, oldVal != INITIAL ? PUBLISHER_SUBSCRIBED : REQUESTED)) continue;
                if (n != 1L) {
                    super.request(n - 1L);
                }
                if (oldVal == INITIAL || !this.tryEmitSingleSuccessToTarget(tVal = oldVal)) break;
                this.next.subscribeInternal(this);
                break;
            }
        }
    }

    private static abstract class AbstractConcatSubscriber<T>
    extends DelayedCancellableThenSubscription
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<T> {
        static final Object INITIAL = new Object();
        static final Object CANCELLED = new Object();
        static final Object TERMINAL = new Object();
        static final Object PUBLISHER_SUBSCRIBED = new Object();
        static final AtomicReferenceFieldUpdater<AbstractConcatSubscriber, Object> mayBeResultUpdater = AtomicReferenceFieldUpdater.newUpdater(AbstractConcatSubscriber.class, Object.class, "mayBeResult");
        private final boolean propagateCancel;
        final PublisherSource.Subscriber<? super T> target;
        final Publisher<? extends T> next;
        @Nullable
        volatile Object mayBeResult = INITIAL;

        AbstractConcatSubscriber(PublisherSource.Subscriber<? super T> target, Publisher<? extends T> next, boolean propagateCancel) {
            this.target = target;
            this.next = next;
            this.propagateCancel = propagateCancel;
        }

        public final void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
            this.target.onSubscribe((PublisherSource.Subscription)this);
        }

        public final void onSubscribe(PublisherSource.Subscription subscription) {
            this.delayedSubscription(subscription);
        }

        public final void onNext(@Nullable T t) {
            this.target.onNext(t);
        }

        public final void onError(Throwable t) {
            if (this.propagateCancel) {
                this.onErrorPropagateCancel(t);
            } else {
                this.target.onError(t);
            }
        }

        private void onErrorPropagateCancel(Throwable t) {
            Object oldValue;
            while ((oldValue = this.mayBeResult) != TERMINAL) {
                if (!mayBeResultUpdater.compareAndSet(this, oldValue, TERMINAL)) continue;
                if (this.finallyShouldSubscribeToNext(oldValue)) {
                    this.forceCancelNextOnSubscribe();
                    try {
                        this.target.onError(t);
                        break;
                    }
                    finally {
                        this.next.subscribeInternal(this);
                    }
                }
                this.target.onError(t);
                break;
            }
        }

        public final void onComplete() {
            if (this.propagateCancel) {
                this.onCompletePropagateCancel();
            } else {
                this.target.onComplete();
            }
        }

        private void onCompletePropagateCancel() {
            Object oldValue;
            while ((oldValue = this.mayBeResult) != TERMINAL) {
                if (!mayBeResultUpdater.compareAndSet(this, oldValue, TERMINAL)) continue;
                this.target.onComplete();
                break;
            }
        }

        @Override
        public final void cancel() {
            Object oldValue;
            while ((oldValue = this.mayBeResult) != CANCELLED && oldValue != TERMINAL) {
                boolean firstCancel = this.finallyShouldSubscribeToNext(oldValue);
                if (!mayBeResultUpdater.compareAndSet(this, oldValue, firstCancel ? TERMINAL : CANCELLED)) continue;
                try {
                    super.cancel();
                    break;
                }
                finally {
                    if (this.propagateCancel && firstCancel) {
                        this.next.subscribeInternal(this);
                    }
                }
            }
        }

        final void superCancel() {
            super.cancel();
        }

        final boolean tryEmitSingleSuccessToTarget(@Nullable T result) {
            try {
                this.target.onNext(result);
                return true;
            }
            catch (Throwable cause) {
                return this.handleOnNextThrowable(cause);
            }
        }

        private boolean finallyShouldSubscribeToNext(@Nullable Object oldState) {
            return oldState != PUBLISHER_SUBSCRIBED;
        }

        private boolean handleOnNextThrowable(Throwable cause) {
            this.mayBeResult = TERMINAL;
            this.target.onError(cause);
            if (this.propagateCancel) {
                this.forceCancelNextOnSubscribe();
                return true;
            }
            return false;
        }

        private void forceCancelNextOnSubscribe() {
            this.delayedSubscription(EmptySubscriptions.EMPTY_SUBSCRIPTION);
        }
    }
}

