/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.nga;

import java.sql.SQLException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.db.AlterTable;
import mil.nga.geopackage.db.CoreSQLUtils;
import mil.nga.geopackage.db.MappedColumn;
import mil.nga.geopackage.db.TableMapping;
import mil.nga.geopackage.extension.ExtensionManagement;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.ExtensionsDao;
import mil.nga.geopackage.extension.nga.contents.ContentsIdExtension;
import mil.nga.geopackage.extension.nga.index.FeatureTableCoreIndex;
import mil.nga.geopackage.extension.nga.index.GeometryIndexDao;
import mil.nga.geopackage.extension.nga.index.TableIndex;
import mil.nga.geopackage.extension.nga.index.TableIndexDao;
import mil.nga.geopackage.extension.nga.link.FeatureTileLink;
import mil.nga.geopackage.extension.nga.link.FeatureTileLinkDao;
import mil.nga.geopackage.extension.nga.link.FeatureTileTableCoreLinker;
import mil.nga.geopackage.extension.nga.properties.PropertiesCoreExtension;
import mil.nga.geopackage.extension.nga.scale.TileScalingDao;
import mil.nga.geopackage.extension.nga.scale.TileTableScaling;
import mil.nga.geopackage.extension.nga.style.FeatureCoreStyleExtension;
import mil.nga.geopackage.extension.related.RelatedTablesCoreExtension;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserCoreDao;
import mil.nga.geopackage.user.UserCoreRow;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public class NGAExtensions
extends ExtensionManagement {
    private static final Logger logger = Logger.getLogger(NGAExtensions.class.getName());
    public static final String EXTENSION_AUTHOR = "nga";

    public NGAExtensions(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    @Override
    public String getAuthor() {
        return EXTENSION_AUTHOR;
    }

    @Override
    public void deleteTableExtensions(String table) {
        this.deleteGeometryIndex(table);
        this.deleteFeatureTileLink(table);
        this.deleteTileScaling(table);
        this.deleteProperties(table);
        this.deleteFeatureStyle(table);
        this.deleteContentsId(table);
    }

    @Override
    public void deleteExtensions() {
        this.deleteGeometryIndexExtension();
        this.deleteFeatureTileLinkExtension();
        this.deleteTileScalingExtension();
        this.deletePropertiesExtension();
        this.deleteFeatureStyleExtension();
        this.deleteContentsIdExtension();
    }

    @Override
    public void copyTableExtensions(String table, String newTable) {
        this.copyContentsId(table, newTable);
        this.copyFeatureStyle(table, newTable);
        this.copyTileScaling(table, newTable);
        this.copyFeatureTileLink(table, newTable);
        this.copyGeometryIndex(table, newTable);
    }

    public void deleteGeometryIndex(String table) {
        TableIndexDao tableIndexDao = FeatureTableCoreIndex.getTableIndexDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (tableIndexDao.isTableExists()) {
                tableIndexDao.deleteByIdCascade(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public void deleteGeometryIndexExtension() {
        GeometryIndexDao geometryIndexDao = FeatureTableCoreIndex.getGeometryIndexDao(this.geoPackage);
        TableIndexDao tableIndexDao = FeatureTableCoreIndex.getTableIndexDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (geometryIndexDao.isTableExists()) {
                this.geoPackage.dropTable(geometryIndexDao.getTableName());
            }
            if (tableIndexDao.isTableExists()) {
                this.geoPackage.dropTable(tableIndexDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTableCoreIndex.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Table Index extension and tables. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public void copyGeometryIndex(String table, String newTable) {
        try {
            List<Extensions> extensions;
            ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
            if (extensionsDao.isTableExists() && !(extensions = extensionsDao.queryByExtension(FeatureTableCoreIndex.EXTENSION_NAME, table)).isEmpty()) {
                TableIndex tableIndex;
                Extensions extension = extensions.get(0);
                extension.setTableName(newTable);
                extensionsDao.create(extension);
                TableIndexDao tableIndexDao = FeatureTableCoreIndex.getTableIndexDao(this.geoPackage);
                if (tableIndexDao.isTableExists() && (tableIndex = (TableIndex)tableIndexDao.queryForId(table)) != null) {
                    tableIndex.setTableName(newTable);
                    tableIndexDao.create(tableIndex);
                    if (this.geoPackage.isTableOrView("nga_geometry_index")) {
                        CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "nga_geometry_index", "table_name", newTable, table);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Geometry Index for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteFeatureTileLink(String table) {
        FeatureTileLinkDao featureTileLinkDao = FeatureTileTableCoreLinker.getFeatureTileLinkDao(this.geoPackage);
        try {
            if (featureTileLinkDao.isTableExists()) {
                featureTileLinkDao.deleteByTableName(table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public void deleteFeatureTileLinkExtension() {
        FeatureTileLinkDao featureTileLinkDao = FeatureTileTableCoreLinker.getFeatureTileLinkDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (featureTileLinkDao.isTableExists()) {
                this.geoPackage.dropTable(featureTileLinkDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Feature Tile Link extension and table. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public void copyFeatureTileLink(String table, String newTable) {
        try {
            FeatureTileLinkDao featureTileLinkDao;
            List<Extensions> extensions;
            ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
            if (extensionsDao.isTableExists() && !(extensions = extensionsDao.queryByExtension(FeatureTileTableCoreLinker.EXTENSION_NAME)).isEmpty() && (featureTileLinkDao = FeatureTileTableCoreLinker.getFeatureTileLinkDao(this.geoPackage)).isTableExists()) {
                for (FeatureTileLink featureTileLink : featureTileLinkDao.queryForFeatureTableName(table)) {
                    featureTileLink.setFeatureTableName(newTable);
                    featureTileLinkDao.create(featureTileLink);
                }
                for (FeatureTileLink featureTileLink : featureTileLinkDao.queryForTileTableName(table)) {
                    featureTileLink.setTileTableName(newTable);
                    featureTileLinkDao.create(featureTileLink);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Feature Tile Link for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteTileScaling(String table) {
        TileScalingDao tileScalingDao = TileTableScaling.getTileScalingDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                tileScalingDao.deleteById(table);
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME, table);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling. GeoPackage: " + this.geoPackage.getName() + ", Table: " + table, e);
        }
    }

    public void deleteTileScalingExtension() {
        TileScalingDao tileScalingDao = TileTableScaling.getTileScalingDao(this.geoPackage);
        ExtensionsDao extensionsDao = this.geoPackage.getExtensionsDao();
        try {
            if (tileScalingDao.isTableExists()) {
                this.geoPackage.dropTable(tileScalingDao.getTableName());
            }
            if (extensionsDao.isTableExists()) {
                extensionsDao.deleteByExtension(TileTableScaling.EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Tile Scaling extension and table. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public void copyTileScaling(String table, String newTable) {
        try {
            Extensions extension;
            TileTableScaling tileTableScaling = new TileTableScaling(this.geoPackage, table);
            if (tileTableScaling.has() && (extension = tileTableScaling.getExtension()) != null) {
                extension.setTableName(newTable);
                tileTableScaling.getExtensionsDao().create(extension);
                if (this.geoPackage.isTableOrView("nga_tile_scaling")) {
                    CoreSQLUtils.transferTableContent(this.geoPackage.getDatabase(), "nga_tile_scaling", "table_name", newTable, table);
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Tile Scaling for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    public void deleteProperties(String table) {
        if (table.equalsIgnoreCase(PropertiesCoreExtension.TABLE_NAME)) {
            this.deletePropertiesExtension();
        }
    }

    public void deletePropertiesExtension() {
        this.getPropertiesExtension().removeExtension();
    }

    private PropertiesCoreExtension getPropertiesExtension() {
        return new PropertiesCoreExtension(this.geoPackage){

            protected UserCoreDao getDao() {
                return null;
            }

            protected UserCoreRow newRow() {
                return null;
            }
        };
    }

    public void deleteFeatureStyle(String table) {
        FeatureCoreStyleExtension featureStyleExtension = this.getFeatureStyleExtension();
        if (featureStyleExtension.has(table)) {
            featureStyleExtension.deleteRelationships(table);
        }
    }

    public void deleteFeatureStyleExtension() {
        FeatureCoreStyleExtension featureStyleExtension = this.getFeatureStyleExtension();
        if (featureStyleExtension.has()) {
            featureStyleExtension.removeExtension();
        }
    }

    public void copyFeatureStyle(String table, String newTable) {
        try {
            Extensions extension;
            FeatureCoreStyleExtension featureStyleExtension = this.getFeatureStyleExtension();
            if (featureStyleExtension.hasRelationship(table) && (extension = featureStyleExtension.get(table)) != null) {
                extension.setTableName(newTable);
                featureStyleExtension.getExtensionsDao().create(extension);
                ContentsIdExtension contentsIdExtension = featureStyleExtension.getContentsId();
                Long contentsId = contentsIdExtension.getId(table);
                Long newContentsId = contentsIdExtension.getId(newTable);
                if (contentsId != null && newContentsId != null) {
                    if (featureStyleExtension.hasTableStyleRelationship(table)) {
                        this.copyFeatureTableStyle(featureStyleExtension, "nga_style_default_", table, newTable, contentsId, newContentsId);
                    }
                    if (featureStyleExtension.hasTableIconRelationship(table)) {
                        this.copyFeatureTableStyle(featureStyleExtension, "nga_icon_default_", table, newTable, contentsId, newContentsId);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Feature Style for table: " + newTable + ", copied from table: " + table, e);
        }
    }

    private void copyFeatureTableStyle(FeatureCoreStyleExtension featureStyleExtension, String mappingTablePrefix, String table, String newTable, long contentsId, long newContentsId) throws SQLException {
        GeoPackageCore geoPackage = featureStyleExtension.getGeoPackage();
        String mappingTableName = featureStyleExtension.getMappingTableName(mappingTablePrefix, table);
        ExtensionsDao extensionsDao = featureStyleExtension.getExtensionsDao();
        List<Extensions> extensions = extensionsDao.queryByExtension(RelatedTablesCoreExtension.EXTENSION_NAME, mappingTableName);
        if (!extensions.isEmpty()) {
            String newMappingTableName = featureStyleExtension.getMappingTableName(mappingTablePrefix, newTable);
            UserCustomTable userTable = UserCustomTableReader.readTable(geoPackage.getDatabase(), mappingTableName);
            AlterTable.copyTable(geoPackage.getDatabase(), userTable, newMappingTableName, false);
            TableMapping mappingTableTableMapping = new TableMapping((UserTable<? extends UserColumn>)userTable, newMappingTableName);
            MappedColumn baseIdColumn = mappingTableTableMapping.getColumn("base_id");
            baseIdColumn.setConstantValue(newContentsId);
            baseIdColumn.setWhereValue(contentsId);
            CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), mappingTableTableMapping);
            Extensions extension = extensions.get(0);
            extension.setTableName(newMappingTableName);
            extensionsDao.create(extension);
            TableMapping extendedRelationTableMapping = new TableMapping(geoPackage.getDatabase(), "gpkgext_relations");
            extendedRelationTableMapping.removeColumn("id");
            MappedColumn baseTableNameColumn = extendedRelationTableMapping.getColumn("base_table_name");
            baseTableNameColumn.setWhereValue("nga_contents_id");
            MappedColumn mappingTableNameColumn = extendedRelationTableMapping.getColumn("mapping_table_name");
            mappingTableNameColumn.setConstantValue(newMappingTableName);
            mappingTableNameColumn.setWhereValue(mappingTableName);
            CoreSQLUtils.transferTableContent(geoPackage.getDatabase(), extendedRelationTableMapping);
        }
    }

    private FeatureCoreStyleExtension getFeatureStyleExtension() {
        RelatedTablesCoreExtension relatedTables = new RelatedTablesCoreExtension(this.geoPackage){};
        return new FeatureCoreStyleExtension(this.geoPackage, relatedTables){};
    }

    public void deleteContentsId(String table) {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(this.geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.delete(table);
        }
    }

    public void deleteContentsIdExtension() {
        ContentsIdExtension contentsIdExtension = new ContentsIdExtension(this.geoPackage);
        if (contentsIdExtension.has()) {
            contentsIdExtension.removeExtension();
        }
    }

    public void copyContentsId(String table, String newTable) {
        try {
            ContentsIdExtension contentsIdExtension = new ContentsIdExtension(this.geoPackage);
            if (contentsIdExtension.has() && contentsIdExtension.get(table) != null) {
                contentsIdExtension.create(newTable);
            }
        }
        catch (Exception e) {
            logger.log(Level.WARNING, "Failed to create Contents Id for table: " + newTable + ", copied from table: " + table, e);
        }
    }
}

