package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.Link;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("geospatialData_style")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class GeospatialDataStyle   {
  private @Valid String id;
  private @Valid String title;
  private @Valid String description;
  private @Valid List<String> keywords = null;
  private @Valid List<Link> links = null;

  /**
   * An identifier for this style. Implementation of &#39;identifier&#39;
   **/
  public GeospatialDataStyle id(String id) {
    this.id = id;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "An identifier for this style. Implementation of 'identifier'")
  @JsonProperty("id")
  @NotNull
  public String getId() {
    return id;
  }

  @JsonProperty("id")
  public void setId(String id) {
    this.id = id;
  }

  /**
   * A title for this style
   **/
  public GeospatialDataStyle title(String title) {
    this.title = title;
    return this;
  }

  
  @ApiModelProperty(value = "A title for this style")
  @JsonProperty("title")
  public String getTitle() {
    return title;
  }

  @JsonProperty("title")
  public void setTitle(String title) {
    this.title = title;
  }

  /**
   * Brief narrative description of this style
   **/
  public GeospatialDataStyle description(String description) {
    this.description = description;
    return this;
  }

  
  @ApiModelProperty(value = "Brief narrative description of this style")
  @JsonProperty("description")
  public String getDescription() {
    return description;
  }

  @JsonProperty("description")
  public void setDescription(String description) {
    this.description = description;
  }

  /**
   * keywords about this style
   **/
  public GeospatialDataStyle keywords(List<String> keywords) {
    this.keywords = keywords;
    return this;
  }

  
  @ApiModelProperty(value = "keywords about this style")
  @JsonProperty("keywords")
  public List<String> getKeywords() {
    return keywords;
  }

  @JsonProperty("keywords")
  public void setKeywords(List<String> keywords) {
    this.keywords = keywords;
  }

  public GeospatialDataStyle addKeywordsItem(String keywordsItem) {
    if (this.keywords == null) {
      this.keywords = new ArrayList<>();
    }

    this.keywords.add(keywordsItem);
    return this;
  }

  public GeospatialDataStyle removeKeywordsItem(String keywordsItem) {
    if (keywordsItem != null && this.keywords != null) {
      this.keywords.remove(keywordsItem);
    }

    return this;
  }
  /**
   * Links to style related resources. Possible link &#39;rel&#39; values are: &#39;style&#39; for a URL pointing to the style description, &#39;styleSpec&#39; for a URL pointing to the specification or standard used to define the style.
   **/
  public GeospatialDataStyle links(List<Link> links) {
    this.links = links;
    return this;
  }

  
  @ApiModelProperty(value = "Links to style related resources. Possible link 'rel' values are: 'style' for a URL pointing to the style description, 'styleSpec' for a URL pointing to the specification or standard used to define the style.")
  @JsonProperty("links")
 @Size(min=1)  public List<Link> getLinks() {
    return links;
  }

  @JsonProperty("links")
  public void setLinks(List<Link> links) {
    this.links = links;
  }

  public GeospatialDataStyle addLinksItem(Link linksItem) {
    if (this.links == null) {
      this.links = new ArrayList<>();
    }

    this.links.add(linksItem);
    return this;
  }

  public GeospatialDataStyle removeLinksItem(Link linksItem) {
    if (linksItem != null && this.links != null) {
      this.links.remove(linksItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    GeospatialDataStyle geospatialDataStyle = (GeospatialDataStyle) o;
    return Objects.equals(this.id, geospatialDataStyle.id) &&
        Objects.equals(this.title, geospatialDataStyle.title) &&
        Objects.equals(this.description, geospatialDataStyle.description) &&
        Objects.equals(this.keywords, geospatialDataStyle.keywords) &&
        Objects.equals(this.links, geospatialDataStyle.links);
  }

  @Override
  public int hashCode() {
    return Objects.hash(id, title, description, keywords, links);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class GeospatialDataStyle {\n");
    
    sb.append("    id: ").append(toIndentedString(id)).append("\n");
    sb.append("    title: ").append(toIndentedString(title)).append("\n");
    sb.append("    description: ").append(toIndentedString(description)).append("\n");
    sb.append("    keywords: ").append(toIndentedString(keywords)).append("\n");
    sb.append("    links: ").append(toIndentedString(links)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

