package org.apache.baremaps.ogcapi.model;

import com.fasterxml.jackson.annotation.JsonTypeName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import org.apache.baremaps.ogcapi.model.LayersArray;
import org.apache.baremaps.ogcapi.model.MbStyleSources;
import javax.validation.constraints.*;
import javax.validation.Valid;

import io.swagger.annotations.*;
import java.util.Objects;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.fasterxml.jackson.annotation.JsonTypeName;



@JsonTypeName("mb-style")
@javax.annotation.Generated(value = "org.openapitools.codegen.languages.JavaJAXRSSpecServerCodegen", date = "2023-10-02T21:29:12.775428718Z[Etc/UTC]")
public class MbStyle   {
  private @Valid BigDecimal version;
  private @Valid String name;
  private @Valid MbStyleSources sources;
  private @Valid String sprite;
  private @Valid String glyphs;
  private @Valid List<LayersArray> layers = new ArrayList<>();

  /**
   **/
  public MbStyle version(BigDecimal version) {
    this.version = version;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("version")
  @NotNull
  public BigDecimal getVersion() {
    return version;
  }

  @JsonProperty("version")
  public void setVersion(BigDecimal version) {
    this.version = version;
  }

  /**
   **/
  public MbStyle name(String name) {
    this.name = name;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("name")
  public String getName() {
    return name;
  }

  @JsonProperty("name")
  public void setName(String name) {
    this.name = name;
  }

  /**
   **/
  public MbStyle sources(MbStyleSources sources) {
    this.sources = sources;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("sources")
  @NotNull
  public MbStyleSources getSources() {
    return sources;
  }

  @JsonProperty("sources")
  public void setSources(MbStyleSources sources) {
    this.sources = sources;
  }

  /**
   **/
  public MbStyle sprite(String sprite) {
    this.sprite = sprite;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("sprite")
  public String getSprite() {
    return sprite;
  }

  @JsonProperty("sprite")
  public void setSprite(String sprite) {
    this.sprite = sprite;
  }

  /**
   **/
  public MbStyle glyphs(String glyphs) {
    this.glyphs = glyphs;
    return this;
  }

  
  @ApiModelProperty(value = "")
  @JsonProperty("glyphs")
  public String getGlyphs() {
    return glyphs;
  }

  @JsonProperty("glyphs")
  public void setGlyphs(String glyphs) {
    this.glyphs = glyphs;
  }

  /**
   **/
  public MbStyle layers(List<LayersArray> layers) {
    this.layers = layers;
    return this;
  }

  
  @ApiModelProperty(required = true, value = "")
  @JsonProperty("layers")
  @NotNull
  public List<LayersArray> getLayers() {
    return layers;
  }

  @JsonProperty("layers")
  public void setLayers(List<LayersArray> layers) {
    this.layers = layers;
  }

  public MbStyle addLayersItem(LayersArray layersItem) {
    if (this.layers == null) {
      this.layers = new ArrayList<>();
    }

    this.layers.add(layersItem);
    return this;
  }

  public MbStyle removeLayersItem(LayersArray layersItem) {
    if (layersItem != null && this.layers != null) {
      this.layers.remove(layersItem);
    }

    return this;
  }

  @Override
  public boolean equals(Object o) {
    if (this == o) {
      return true;
    }
    if (o == null || getClass() != o.getClass()) {
      return false;
    }
    MbStyle mbStyle = (MbStyle) o;
    return Objects.equals(this.version, mbStyle.version) &&
        Objects.equals(this.name, mbStyle.name) &&
        Objects.equals(this.sources, mbStyle.sources) &&
        Objects.equals(this.sprite, mbStyle.sprite) &&
        Objects.equals(this.glyphs, mbStyle.glyphs) &&
        Objects.equals(this.layers, mbStyle.layers);
  }

  @Override
  public int hashCode() {
    return Objects.hash(version, name, sources, sprite, glyphs, layers);
  }

  @Override
  public String toString() {
    StringBuilder sb = new StringBuilder();
    sb.append("class MbStyle {\n");
    
    sb.append("    version: ").append(toIndentedString(version)).append("\n");
    sb.append("    name: ").append(toIndentedString(name)).append("\n");
    sb.append("    sources: ").append(toIndentedString(sources)).append("\n");
    sb.append("    sprite: ").append(toIndentedString(sprite)).append("\n");
    sb.append("    glyphs: ").append(toIndentedString(glyphs)).append("\n");
    sb.append("    layers: ").append(toIndentedString(layers)).append("\n");
    sb.append("}");
    return sb.toString();
  }

  /**
   * Convert the given object to string with each line indented by 4 spaces
   * (except the first line).
   */
  private String toIndentedString(Object o) {
    if (o == null) {
      return "null";
    }
    return o.toString().replace("\n", "\n    ");
  }


}

