/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.crs.CRS;
import mil.nga.crs.CRSType;
import mil.nga.crs.common.Identifier;
import mil.nga.crs.operation.OperationMethods;
import mil.nga.crs.projected.ProjectedCoordinateReferenceSystem;
import mil.nga.crs.wkt.CRSReader;
import mil.nga.geopackage.BoundingBox;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.contents.ContentsDataType;
import mil.nga.geopackage.dgiwg.CoordinateReferenceSystem;
import mil.nga.geopackage.dgiwg.DGIWGMetadata;
import mil.nga.geopackage.dgiwg.DGIWGRequirement;
import mil.nga.geopackage.dgiwg.DGIWGValidationError;
import mil.nga.geopackage.dgiwg.DGIWGValidationErrors;
import mil.nga.geopackage.dgiwg.DGIWGValidationKey;
import mil.nga.geopackage.dgiwg.DataType;
import mil.nga.geopackage.extension.CrsWktExtension;
import mil.nga.geopackage.extension.CrsWktExtensionVersion;
import mil.nga.geopackage.extension.ExtensionManager;
import mil.nga.geopackage.extension.GeometryExtensions;
import mil.nga.geopackage.extension.WebPExtension;
import mil.nga.geopackage.extension.ZoomOtherExtension;
import mil.nga.geopackage.extension.metadata.Metadata;
import mil.nga.geopackage.extension.metadata.MetadataExtension;
import mil.nga.geopackage.extension.metadata.MetadataScopeType;
import mil.nga.geopackage.extension.metadata.reference.MetadataReference;
import mil.nga.geopackage.extension.metadata.reference.ReferenceScopeType;
import mil.nga.geopackage.extension.rtree.RTreeIndexCoreExtension;
import mil.nga.geopackage.features.columns.GeometryColumns;
import mil.nga.geopackage.srs.SpatialReferenceSystem;
import mil.nga.geopackage.tiles.matrix.TileMatrix;
import mil.nga.geopackage.tiles.matrixset.TileMatrixSet;
import mil.nga.proj.Projection;
import mil.nga.sf.GeometryType;
import mil.nga.sf.wkb.GeometryCodes;

public class DGIWGValidate {
    public static final double TILE_MATRIX_SET_BOUNDS_TOLERANCE = 1.0;

    public static boolean isValid(GeoPackageCore geoPackage) {
        return DGIWGValidate.validate(geoPackage).isValid();
    }

    public static DGIWGValidationErrors validate(GeoPackageCore geoPackage) {
        DGIWGValidationErrors errors = DGIWGValidate.validateBase(geoPackage);
        for (String tileTable : geoPackage.getTileTables()) {
            errors.add(DGIWGValidate.validateTileTable(geoPackage, tileTable));
        }
        for (String featureTable : geoPackage.getFeatureTables()) {
            errors.add(DGIWGValidate.validateFeatureTable(geoPackage, featureTable));
        }
        return errors;
    }

    public static DGIWGValidationErrors validateBase(GeoPackageCore geoPackage) {
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        CrsWktExtension crsWktExtension = new CrsWktExtension(geoPackage);
        if (!crsWktExtension.hasMinimum(CrsWktExtensionVersion.V_1)) {
            errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_crs_wkt", "No mandatory CRS WKT extension", DGIWGRequirement.EXTENSIONS_MANDATORY, DGIWGValidate.extensionPrimaryKeys("gpkg_spatial_ref_sys", CrsWktExtension.DEFINITION_COLUMN_NAME, "gpkg_crs_wkt")));
        }
        errors.add(DGIWGValidate.validateMetadata(geoPackage));
        return errors;
    }

    public static DGIWGValidationErrors validate(GeoPackageCore geoPackage, String table) {
        ArrayList<String> tables = new ArrayList<String>();
        tables.add(table);
        return DGIWGValidate.validate(geoPackage, tables);
    }

    public static DGIWGValidationErrors validate(GeoPackageCore geoPackage, List<String> tables) {
        DGIWGValidationErrors errors = DGIWGValidate.validateBase(geoPackage);
        for (String table : tables) {
            ContentsDataType dataType = geoPackage.getTableDataType(table);
            if (dataType == null) continue;
            switch (dataType) {
                case FEATURES: {
                    errors.add(DGIWGValidate.validateFeatureTable(geoPackage, table));
                    break;
                }
                case TILES: {
                    errors.add(DGIWGValidate.validateTileTable(geoPackage, table));
                    break;
                }
            }
        }
        return errors;
    }

    public static DGIWGValidationErrors validateMetadata(GeoPackageCore geoPackage) {
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        List<MetadataReference> metadataReferences = DGIWGMetadata.queryGeoPackageDMFMetadata(geoPackage);
        if (metadataReferences != null && !metadataReferences.isEmpty()) {
            DGIWGValidationErrors metadataErrors = new DGIWGValidationErrors();
            for (MetadataReference reference : metadataReferences) {
                DGIWGValidationErrors mdErrors = new DGIWGValidationErrors();
                Metadata metadata = reference.getMetadata();
                String scope = metadata.getMetadataScopeName();
                if (!scope.equalsIgnoreCase(MetadataScopeType.SERIES.getName()) && !scope.equalsIgnoreCase(MetadataScopeType.DATASET.getName())) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata", "md_scope", scope, MetadataScopeType.SERIES.getName() + " or " + MetadataScopeType.DATASET.getName(), DGIWGRequirement.METADATA_GPKG, DGIWGValidate.primaryKey(metadata)));
                }
                if (!metadata.getStandardUri().toLowerCase().startsWith("https://dgiwg.org/std/dmf/".toLowerCase())) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata", "md_standard_uri", metadata.getStandardUri(), "https://dgiwg.org/std/dmf/<version>", DGIWGRequirement.METADATA_GPKG, DGIWGValidate.primaryKey(metadata)));
                }
                if (!metadata.getMimeType().equalsIgnoreCase("text/xml")) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata", "mime_type", metadata.getMimeType(), "text/xml", DGIWGRequirement.METADATA_GPKG, DGIWGValidate.primaryKey(metadata)));
                }
                if (metadata.getMetadata() == null || metadata.getMetadata().isBlank()) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata", "metadata", metadata.getMetadata(), "https://dgiwg.org/std/dmf/", DGIWGRequirement.METADATA_GPKG, DGIWGValidate.primaryKey(metadata)));
                }
                if (!reference.getReferenceScopeName().equalsIgnoreCase(ReferenceScopeType.GEOPACKAGE.getValue())) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata_reference", "reference_scope", reference.getReferenceScopeName(), ReferenceScopeType.GEOPACKAGE.getValue(), DGIWGRequirement.METADATA_ROW, DGIWGValidate.primaryKeys(reference)));
                }
                if (reference.getTableName() != null) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata_reference", "table_name", reference.getTableName(), "NULL", DGIWGRequirement.METADATA_ROW, DGIWGValidate.primaryKeys(reference)));
                }
                if (reference.getColumnName() != null) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata_reference", "column_name", reference.getColumnName(), "NULL", DGIWGRequirement.METADATA_ROW, DGIWGValidate.primaryKeys(reference)));
                }
                if (reference.getRowIdValue() != null) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata_reference", "row_id_value", (Number)reference.getRowIdValue(), "NULL", DGIWGRequirement.METADATA_ROW, DGIWGValidate.primaryKeys(reference)));
                }
                if (reference.getParentId() != null) {
                    mdErrors.add(new DGIWGValidationError("gpkg_metadata_reference", "md_parent_id", (Number)reference.getParentId(), "NULL", DGIWGRequirement.METADATA_ROW, DGIWGValidate.primaryKeys(reference)));
                }
                if (mdErrors.isValid()) {
                    metadataErrors = null;
                    break;
                }
                metadataErrors.add(mdErrors);
            }
            if (metadataErrors != null) {
                errors.add(metadataErrors);
            }
        } else {
            MetadataExtension metadataExtension = new MetadataExtension(geoPackage);
            if (!metadataExtension.has()) {
                boolean metadataTableExists = false;
                try {
                    metadataTableExists = metadataExtension.getMetadataDao().isTableExists();
                }
                catch (SQLException reference) {
                    // empty catch block
                }
                if (!metadataTableExists) {
                    errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_metadata", "No mandatory Metadata extension", DGIWGRequirement.EXTENSIONS_MANDATORY, DGIWGValidate.extensionPrimaryKeys("gpkg_metadata", "gpkg_metadata")));
                }
                boolean referenceTableExists = false;
                try {
                    referenceTableExists = metadataExtension.getMetadataReferenceDao().isTableExists();
                }
                catch (SQLException sQLException) {
                    // empty catch block
                }
                if (!referenceTableExists) {
                    errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_metadata", "No mandatory Metadata extension", DGIWGRequirement.EXTENSIONS_MANDATORY, DGIWGValidate.extensionPrimaryKeys("gpkg_metadata_reference", "gpkg_metadata")));
                }
            }
            DGIWGValidationKey[] keys = new DGIWGValidationKey[]{new DGIWGValidationKey("md_standard_uri", "https://dgiwg.org/std/dmf/"), new DGIWGValidationKey("reference_scope", ReferenceScopeType.GEOPACKAGE.getValue())};
            errors.add(new DGIWGValidationError("gpkg_metadata", "md_standard_uri", "https://dgiwg.org/std/dmf/", "No required metadata with DMF base URI and metadata reference 'geopackage' scope", DGIWGRequirement.METADATA_DMF, keys));
        }
        return errors;
    }

    public static DGIWGValidationErrors validateTileTable(GeoPackageCore geoPackage, String tileTable) {
        WebPExtension webPExtension;
        List<TileMatrix> tileMatrices;
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        TileMatrixSet tileMatrixSet = null;
        try {
            tileMatrixSet = geoPackage.getTileMatrixSetDao().queryForId(tileTable);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve Tile Matrix Set for tile table: " + tileTable, e);
        }
        if (tileMatrixSet != null) {
            Object boundingBox;
            SpatialReferenceSystem srs = tileMatrixSet.getSrs();
            errors.add(DGIWGValidate.validateTileCoordinateReferenceSystem(tileTable, srs));
            CoordinateReferenceSystem crs = CoordinateReferenceSystem.getCoordinateReferenceSystem(srs);
            if (crs != null && !((BoundingBox)(boundingBox = crs.getBounds())).contains(tileMatrixSet.getBoundingBox())) {
                String crsBounds = "CRS " + crs.getAuthorityAndCode() + " Bounds: " + (BoundingBox)boundingBox;
                if (tileMatrixSet.getMinX() < ((BoundingBox)boundingBox).getMinLongitude() - 1.0) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix_set", "min_x", (Number)tileMatrixSet.getMinX(), crsBounds, DGIWGRequirement.BBOX_CRS, DGIWGValidate.primaryKey(tileMatrixSet)));
                }
                if (tileMatrixSet.getMinY() < ((BoundingBox)boundingBox).getMinLatitude() - 1.0) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix_set", "min_y", (Number)tileMatrixSet.getMinY(), crsBounds, DGIWGRequirement.BBOX_CRS, DGIWGValidate.primaryKey(tileMatrixSet)));
                }
                if (tileMatrixSet.getMaxX() > ((BoundingBox)boundingBox).getMaxLongitude() + 1.0) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix_set", "max_x", (Number)tileMatrixSet.getMaxX(), crsBounds, DGIWGRequirement.BBOX_CRS, DGIWGValidate.primaryKey(tileMatrixSet)));
                }
                if (tileMatrixSet.getMaxY() > ((BoundingBox)boundingBox).getMaxLatitude() + 1.0) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix_set", "max_y", (Number)tileMatrixSet.getMaxY(), crsBounds, DGIWGRequirement.BBOX_CRS, DGIWGValidate.primaryKey(tileMatrixSet)));
                }
            }
        } else {
            errors.add(new DGIWGValidationError("gpkg_tile_matrix_set", "table_name", tileTable, "No Tile Matrix Set for tile table", DGIWGRequirement.CRS_RASTER_TILE_MATRIX_SET));
        }
        try {
            tileMatrices = geoPackage.getTileMatrixDao().queryForTableName(tileTable);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve Tile Matrices for tile table: " + tileTable, e);
        }
        if (tileMatrices == null || tileMatrices.isEmpty()) {
            errors.add(new DGIWGValidationError("gpkg_tile_matrix", "table_name", tileTable, "No Tile Matrices for tile table", DGIWGRequirement.CRS_RASTER_TILE_MATRIX_SET, DGIWGValidate.primaryKey(tileMatrixSet)));
        } else {
            TileMatrix previousTileMatrix = null;
            for (TileMatrix tileMatrix : tileMatrices) {
                long zoomLevel = tileMatrix.getZoomLevel();
                if (zoomLevel < 0L || zoomLevel > 24L) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix", "zoom_level", (Number)tileMatrix.getZoomLevel(), "0 <= zoom_level <= 24", DGIWGRequirement.VALIDITY_DATA_VALIDITY, DGIWGValidate.primaryKeys(tileMatrix)));
                }
                if (tileMatrix.getTileWidth() != 256L) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix", "tile_width", (Number)tileMatrix.getTileWidth(), 256, DGIWGRequirement.TILE_SIZE_MATRIX, DGIWGValidate.primaryKeys(tileMatrix)));
                }
                if (tileMatrix.getTileHeight() != 256L) {
                    errors.add(new DGIWGValidationError("gpkg_tile_matrix", "tile_height", (Number)tileMatrix.getTileHeight(), 256, DGIWGRequirement.TILE_SIZE_MATRIX, DGIWGValidate.primaryKeys(tileMatrix)));
                }
                if (previousTileMatrix != null) {
                    long zoomChange = tileMatrix.getZoomLevel() - previousTileMatrix.getZoomLevel();
                    double factor = Math.pow(2.0, zoomChange);
                    double pixelXSize = previousTileMatrix.getPixelXSize() / factor;
                    double pixelYSize = previousTileMatrix.getPixelYSize() / factor;
                    if (tileMatrix.getPixelXSize() != pixelXSize) {
                        errors.add(new DGIWGValidationError("gpkg_tile_matrix", "pixel_x_size", (Number)tileMatrix.getPixelXSize(), pixelXSize, DGIWGRequirement.ZOOM_FACTOR, DGIWGValidate.primaryKeys(tileMatrix)));
                    }
                    if (tileMatrix.getPixelYSize() != pixelYSize) {
                        errors.add(new DGIWGValidationError("gpkg_tile_matrix", "pixel_y_size", (Number)tileMatrix.getPixelYSize(), pixelYSize, DGIWGRequirement.ZOOM_FACTOR, DGIWGValidate.primaryKeys(tileMatrix)));
                    }
                    if (zoomChange > 1L) {
                        StringBuilder zoomMissing = new StringBuilder();
                        zoomMissing.append(previousTileMatrix.getZoomLevel() + 1L);
                        if (zoomChange > 2L) {
                            zoomMissing.append(" - ");
                            zoomMissing.append(tileMatrix.getZoomLevel() - 1L);
                        }
                        errors.add(new DGIWGValidationError("gpkg_tile_matrix", "zoom_level", (Number)tileMatrix.getZoomLevel(), "Missing adjacent zoom level(s): " + zoomMissing, DGIWGRequirement.ZOOM_MATRIX_SETS_MULTIPLE, DGIWGValidate.primaryKeys(tileMatrix)));
                    }
                }
                previousTileMatrix = tileMatrix;
            }
        }
        ZoomOtherExtension zoomOtherExtension = new ZoomOtherExtension(geoPackage);
        if (zoomOtherExtension.has(tileTable)) {
            errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_zoom_other", "Zoom other intervals not allowed", DGIWGRequirement.EXTENSIONS_NOT_ALLOWED, DGIWGValidate.extensionPrimaryKeys(tileTable, "tile_data", "gpkg_zoom_other")));
        }
        if ((webPExtension = new WebPExtension(geoPackage)).has(tileTable)) {
            errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_webp", "WebP encoding not allowed", DGIWGRequirement.EXTENSIONS_NOT_ALLOWED, DGIWGValidate.extensionPrimaryKeys(tileTable, "tile_data", "gpkg_webp")));
        }
        return errors;
    }

    public static DGIWGValidationErrors validateTileCoordinateReferenceSystem(String tileTable, SpatialReferenceSystem srs) {
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        CoordinateReferenceSystem crs = DGIWGValidate.validateCoordinateReferenceSystem(errors, tileTable, srs, ContentsDataType.TILES);
        if (crs == null) {
            Projection projection = srs.getProjection();
            String definition = projection.getDefinition();
            CRS definitionCrs = projection.getDefinitionCRS();
            if (definitionCrs == null && definition != null) {
                try {
                    definitionCrs = CRSReader.read((String)definition);
                }
                catch (Exception e) {
                    errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", definition, "Failed to read tiles coordinate reference system definition: " + e.getMessage(), DGIWGRequirement.CRS_RASTER_ALLOWED, DGIWGValidate.primaryKey(srs)));
                }
            }
            if (definitionCrs != null) {
                boolean valid = false;
                if (definitionCrs.getType() == CRSType.PROJECTED && definitionCrs instanceof ProjectedCoordinateReferenceSystem) {
                    ProjectedCoordinateReferenceSystem projected = (ProjectedCoordinateReferenceSystem)definitionCrs;
                    OperationMethods operationMethod = projected.getMapProjection().getMethod().getMethod();
                    switch (operationMethod) {
                        case LAMBERT_CONIC_CONFORMAL_1SP: 
                        case LAMBERT_CONIC_CONFORMAL_2SP: {
                            valid = true;
                            break;
                        }
                    }
                }
                if (!valid) {
                    errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", definition, "Unsupported tiles coordinate reference system", DGIWGRequirement.CRS_RASTER_ALLOWED, DGIWGValidate.primaryKey(srs)));
                }
            } else if (!errors.hasErrors()) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", definition, "Failed to read tiles coordinate reference system definition", DGIWGRequirement.CRS_RASTER_ALLOWED, DGIWGValidate.primaryKey(srs)));
            }
        }
        return errors;
    }

    public static DGIWGValidationErrors validateFeatureTable(GeoPackageCore geoPackage, String featureTable) {
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        GeometryColumns geometryColumns = null;
        try {
            geometryColumns = geoPackage.getGeometryColumnsDao().queryForTableName(featureTable);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve Geometry Columns for feature table: " + featureTable, e);
        }
        if (geometryColumns != null) {
            RTreeIndexCoreExtension rTreeIndexExtension;
            CoordinateReferenceSystem crs;
            String geomColumn = geometryColumns.getColumnName();
            byte z = geometryColumns.getZ();
            SpatialReferenceSystem srs = geometryColumns.getSrs();
            errors.add(DGIWGValidate.validateFeatureCoordinateReferenceSystem(featureTable, srs, z));
            if (z != 0 && z != 1) {
                errors.add(new DGIWGValidationError("gpkg_geometry_columns", "z", (Number)z, "Geometry Columns z values of prohibited (0) or mandatory (1)", DGIWGRequirement.VALIDITY_DATA_VALIDITY, DGIWGValidate.primaryKeys(geometryColumns)));
            }
            if ((crs = CoordinateReferenceSystem.getCoordinateReferenceSystem(srs)) != null) {
                if (z == 0) {
                    if (!crs.isDataType(DataType.FEATURES_2D)) {
                        errors.add(new DGIWGValidationError("gpkg_geometry_columns", "z", (Number)z, "Geometry Columns z value of prohibited (0) is for 2-D CRS. CRS " + crs.getAuthorityAndCode() + " Types: " + crs.getDataTypes(), DGIWGRequirement.CRS_2D_VECTOR, DGIWGValidate.primaryKeys(geometryColumns)));
                    }
                    if (crs.isType(CRSType.COMPOUND)) {
                        errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", CrsWktExtension.DEFINITION_COLUMN_NAME, srs.getProjectionDefinition(), "Compound CRS not allowed for Geometry Columns value of prohibited (0)", DGIWGRequirement.CRS_COMPOUND, DGIWGValidate.primaryKey(srs)));
                    }
                } else if (z == 1 && !crs.isDataType(DataType.FEATURES_3D)) {
                    errors.add(new DGIWGValidationError("gpkg_geometry_columns", "z", (Number)z, "Geometry Columns z value of mandatory (1) is for 3-D CRS. CRS " + crs.getAuthorityAndCode() + " Types: " + crs.getDataTypes(), DGIWGRequirement.CRS_3D_VECTOR, DGIWGValidate.primaryKeys(geometryColumns)));
                }
            }
            if (!(rTreeIndexExtension = ExtensionManager.getRTreeIndexExtension(geoPackage)).has(featureTable)) {
                errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", "gpkg_rtree_index", "No mandatory RTree extension for feature table", DGIWGRequirement.EXTENSIONS_MANDATORY, DGIWGValidate.extensionPrimaryKeys(featureTable, geomColumn, "gpkg_rtree_index")));
            }
            GeometryExtensions geometryExtensions = new GeometryExtensions(geoPackage);
            for (int i = GeometryCodes.getCode((GeometryType)GeometryType.CIRCULARSTRING); i <= GeometryCodes.getCode((GeometryType)GeometryType.SURFACE); ++i) {
                GeometryType geometryType = GeometryCodes.getGeometryType((int)i);
                if (!geometryExtensions.has(featureTable, geomColumn, geometryType)) continue;
                String geometryExtensionName = GeometryExtensions.getExtensionName(geometryType);
                errors.add(new DGIWGValidationError("gpkg_extensions", "extension_name", geometryExtensionName, "Nonlinear geometry type not allowed", DGIWGRequirement.EXTENSIONS_NOT_ALLOWED, DGIWGValidate.extensionPrimaryKeys(featureTable, geomColumn, geometryExtensionName)));
            }
        } else {
            errors.add(new DGIWGValidationError("gpkg_geometry_columns", "table_name", featureTable, "No Geometry Columns for feature table", DGIWGRequirement.GEOPACKAGE_BASE));
        }
        return errors;
    }

    public static DGIWGValidationErrors validateFeatureCoordinateReferenceSystem(String featureTable, SpatialReferenceSystem srs) {
        return DGIWGValidate.validateFeatureCoordinateReferenceSystem(featureTable, srs, 0);
    }

    public static DGIWGValidationErrors validateFeatureCoordinateReferenceSystem(String featureTable, SpatialReferenceSystem srs, int z) {
        DGIWGValidationErrors errors = new DGIWGValidationErrors();
        CoordinateReferenceSystem crs = DGIWGValidate.validateCoordinateReferenceSystem(errors, featureTable, srs, ContentsDataType.FEATURES);
        if (crs == null) {
            DGIWGRequirement requirement = z == 1 ? DGIWGRequirement.CRS_3D_VECTOR : DGIWGRequirement.CRS_2D_VECTOR;
            errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", srs.getProjectionDefinition(), "Unsupported features coordinate reference system", requirement, DGIWGValidate.primaryKey(srs)));
        }
        return errors;
    }

    private static CoordinateReferenceSystem validateCoordinateReferenceSystem(DGIWGValidationErrors errors, String table, SpatialReferenceSystem srs, ContentsDataType type) {
        CoordinateReferenceSystem crs = CoordinateReferenceSystem.getCoordinateReferenceSystem(srs);
        if (crs != null) {
            boolean valid = false;
            for (DataType dataType : crs.getDataTypes()) {
                if (dataType.getDataType() != type) continue;
                valid = true;
                break;
            }
            if (!valid) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", srs.getProjectionDefinition(), "Unsupported " + type.getName() + " coordinate reference system", DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
            }
            String definition = null;
            definition = crs.getType() == CRSType.COMPOUND ? srs.getDefinition_12_063() : srs.getProjectionDefinition();
            if (definition == null || definition.isBlank() || definition.trim().equalsIgnoreCase("undefined")) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", crs.getType() == CRSType.COMPOUND ? CrsWktExtension.DEFINITION_COLUMN_NAME : "definition", definition, "Missing required coordinate reference system well-known text definition", DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
            } else {
                CRS definitionCrs = null;
                try {
                    definitionCrs = CRSReader.read((String)definition);
                }
                catch (Exception e) {
                    errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", definition, "Failed to read coordinate reference system definition: " + e.getMessage(), DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
                }
                if (definitionCrs != null && definitionCrs.hasIdentifiers()) {
                    boolean found = false;
                    for (Identifier identifier : definitionCrs.getIdentifiers()) {
                        if (!crs.getAuthority().equalsIgnoreCase(identifier.getName()) || !String.valueOf(crs.getCode()).equalsIgnoreCase(identifier.getUniqueIdentifier())) continue;
                        found = true;
                        break;
                    }
                    if (!found) {
                        for (Identifier identifier : definitionCrs.getIdentifiers()) {
                            errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "definition", identifier.toString(), new Identifier(crs.getAuthority(), String.valueOf(crs.getCode())).toString(), DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
                        }
                    }
                }
            }
            if (!srs.getSrsName().equalsIgnoreCase(crs.getName())) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "srs_name", srs.getSrsName(), crs.getName(), DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
            }
            if (srs.getSrsId() != crs.getCode()) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "srs_id", (Number)srs.getSrsId(), crs.getCode(), DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
            }
            if (!srs.getOrganization().equalsIgnoreCase(crs.getAuthority())) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "organization", srs.getOrganization(), crs.getAuthority(), DGIWGRequirement.VALIDITY_DATA_VALIDITY, DGIWGValidate.primaryKey(srs)));
            }
            if (srs.getOrganizationCoordsysId() != crs.getCode()) {
                errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "organization_coordsys_id", (Number)srs.getOrganizationCoordsysId(), crs.getCode(), DGIWGRequirement.CRS_WKT, DGIWGValidate.primaryKey(srs)));
            }
        } else if (!srs.getOrganization().equalsIgnoreCase("EPSG")) {
            errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "organization", srs.getOrganization(), "EPSG", DGIWGRequirement.VALIDITY_DATA_VALIDITY, DGIWGValidate.primaryKey(srs)));
        }
        String description = srs.getDescription();
        if (description == null || description.isBlank() || description.trim().equalsIgnoreCase("unknown") || description.trim().equalsIgnoreCase("tbd")) {
            errors.add(new DGIWGValidationError("gpkg_spatial_ref_sys", "description", srs.getDescription(), "Invalid empty or unspecified description", DGIWGRequirement.VALIDITY_DATA_VALIDITY, DGIWGValidate.primaryKey(srs)));
        }
        return crs;
    }

    private static DGIWGValidationKey primaryKey(SpatialReferenceSystem srs) {
        DGIWGValidationKey key = null;
        if (srs != null) {
            key = new DGIWGValidationKey("srs_id", srs.getId());
        }
        return key;
    }

    private static DGIWGValidationKey primaryKey(Metadata metadata) {
        DGIWGValidationKey key = null;
        if (metadata != null) {
            key = new DGIWGValidationKey("id", metadata.getId());
        }
        return key;
    }

    private static DGIWGValidationKey[] primaryKeys(MetadataReference reference) {
        ArrayList<DGIWGValidationKey> keys = new ArrayList<DGIWGValidationKey>();
        if (reference != null) {
            keys.add(new DGIWGValidationKey("md_file_id", reference.getFileId()));
            if (reference.getParentId() != null) {
                keys.add(new DGIWGValidationKey("md_parent_id", reference.getParentId()));
            }
        }
        return keys.toArray(new DGIWGValidationKey[0]);
    }

    private static DGIWGValidationKey primaryKey(TileMatrixSet tileMatrixSet) {
        DGIWGValidationKey key = null;
        if (tileMatrixSet != null) {
            key = new DGIWGValidationKey("table_name", tileMatrixSet.getId());
        }
        return key;
    }

    private static DGIWGValidationKey[] primaryKeys(TileMatrix tileMatrix) {
        DGIWGValidationKey[] keys = null;
        if (tileMatrix != null) {
            keys = new DGIWGValidationKey[]{new DGIWGValidationKey("table_name", tileMatrix.getId().getTableName()), new DGIWGValidationKey("zoom_level", tileMatrix.getId().getZoomLevel())};
        }
        return keys;
    }

    private static DGIWGValidationKey[] primaryKeys(GeometryColumns geometryColumns) {
        DGIWGValidationKey[] keys = null;
        if (geometryColumns != null) {
            keys = new DGIWGValidationKey[]{new DGIWGValidationKey("table_name", geometryColumns.getId().getTableName()), new DGIWGValidationKey("column_name", geometryColumns.getId().getColumnName())};
        }
        return keys;
    }

    private static DGIWGValidationKey[] extensionPrimaryKeys(String table, String extension) {
        return DGIWGValidate.extensionPrimaryKeys(table, null, extension);
    }

    private static DGIWGValidationKey[] extensionPrimaryKeys(String table, String column, String extension) {
        ArrayList<DGIWGValidationKey> keys = new ArrayList<DGIWGValidationKey>();
        if (table != null) {
            keys.add(new DGIWGValidationKey("table_name", table));
        }
        if (column != null) {
            keys.add(new DGIWGValidationKey("column_name", column));
        }
        keys.add(new DGIWGValidationKey("extension_name", extension));
        return keys.toArray(new DGIWGValidationKey[0]);
    }
}

