/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.dgiwg;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import mil.nga.geopackage.dgiwg.DGIWGValidationError;

public class DGIWGValidationErrors
implements Iterable<DGIWGValidationError> {
    private final Set<DGIWGValidationError> errors = new LinkedHashSet<DGIWGValidationError>();

    public DGIWGValidationErrors() {
    }

    public DGIWGValidationErrors(DGIWGValidationError error) {
        this.add(error);
    }

    public DGIWGValidationErrors(Collection<DGIWGValidationError> errors) {
        this.add(errors);
    }

    public DGIWGValidationErrors(DGIWGValidationErrors errors) {
        this.add(errors);
    }

    public void add(DGIWGValidationError error) {
        this.errors.add(error);
    }

    public void add(Collection<DGIWGValidationError> errors) {
        this.errors.addAll(errors);
    }

    public void add(DGIWGValidationErrors errors) {
        this.add(errors.getErrors());
    }

    public boolean isValid() {
        return this.errors.isEmpty();
    }

    public boolean hasErrors() {
        return !this.isValid();
    }

    public int numErrors() {
        return this.errors.size();
    }

    public List<DGIWGValidationError> getErrors() {
        return new ArrayList<DGIWGValidationError>(this.errors);
    }

    public DGIWGValidationError getError(int index) {
        return this.getErrors().get(index);
    }

    @Override
    public Iterator<DGIWGValidationError> iterator() {
        return this.errors.iterator();
    }

    public String toString() {
        StringBuilder value = new StringBuilder();
        int countLength = DGIWGValidationErrors.length(this.numErrors());
        int number = 0;
        for (DGIWGValidationError error : this) {
            if (number > 0) {
                value.append("\n");
            }
            value.append(++number);
            int padding = countLength - DGIWGValidationErrors.length(number);
            for (int i = 0; i < padding; ++i) {
                value.append(" ");
            }
            value.append(" - ");
            value.append(error);
        }
        return value.toString();
    }

    private static int length(int number) {
        return (int)(Math.log10(number) + 1.0);
    }
}

