/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.related;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import mil.nga.geopackage.GeoPackageCore;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.attributes.AttributesTable;
import mil.nga.geopackage.contents.Contents;
import mil.nga.geopackage.contents.ContentsDao;
import mil.nga.geopackage.db.GeoPackageCoreConnection;
import mil.nga.geopackage.extension.BaseExtension;
import mil.nga.geopackage.extension.ExtensionScopeType;
import mil.nga.geopackage.extension.Extensions;
import mil.nga.geopackage.extension.related.ExtendedRelation;
import mil.nga.geopackage.extension.related.ExtendedRelationsDao;
import mil.nga.geopackage.extension.related.RelationType;
import mil.nga.geopackage.extension.related.UserMappingTable;
import mil.nga.geopackage.extension.related.UserRelatedTable;
import mil.nga.geopackage.extension.related.media.MediaTable;
import mil.nga.geopackage.extension.related.simple.SimpleAttributesTable;
import mil.nga.geopackage.property.GeoPackageProperties;
import mil.nga.geopackage.property.PropertyConstants;
import mil.nga.geopackage.tiles.user.TileTable;
import mil.nga.geopackage.user.UserColumn;
import mil.nga.geopackage.user.UserTable;
import mil.nga.geopackage.user.custom.UserCustomColumn;
import mil.nga.geopackage.user.custom.UserCustomTable;
import mil.nga.geopackage.user.custom.UserCustomTableReader;

public abstract class RelatedTablesCoreExtension
extends BaseExtension {
    public static final String EXTENSION_AUTHOR = "gpkg";
    public static final String EXTENSION_NAME_NO_AUTHOR = "related_tables";
    public static final String EXTENSION_NAME = Extensions.buildExtensionName("gpkg", "related_tables");
    public static final String EXTENSION_DEFINITION = GeoPackageProperties.getProperty(PropertyConstants.EXTENSIONS, "related_tables");
    private ExtendedRelationsDao extendedRelationsDao = this.getExtendedRelationsDao();

    protected RelatedTablesCoreExtension(GeoPackageCore geoPackage) {
        super(geoPackage);
    }

    private Extensions getOrCreate() {
        this.createExtendedRelationsTable();
        Extensions extension = this.getOrCreate(EXTENSION_NAME, "gpkgext_relations", null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    private Extensions getOrCreate(String mappingTable) {
        this.getOrCreate();
        Extensions extension = this.getOrCreate(EXTENSION_NAME, mappingTable, null, EXTENSION_DEFINITION, ExtensionScopeType.READ_WRITE);
        return extension;
    }

    public boolean has() {
        return this.has(EXTENSION_NAME, "gpkgext_relations", null) && this.geoPackage.isTable("gpkgext_relations");
    }

    @Override
    public boolean has(String mappingTable) {
        return this.has() && this.has(EXTENSION_NAME, mappingTable, null);
    }

    public ExtendedRelationsDao getExtendedRelationsDao() {
        if (this.extendedRelationsDao == null) {
            this.extendedRelationsDao = RelatedTablesCoreExtension.getExtendedRelationsDao(this.geoPackage);
        }
        return this.extendedRelationsDao;
    }

    public static ExtendedRelationsDao getExtendedRelationsDao(GeoPackageCore geoPackage) {
        return ExtendedRelationsDao.create(geoPackage);
    }

    public static ExtendedRelationsDao getExtendedRelationsDao(GeoPackageCoreConnection db) {
        return ExtendedRelationsDao.create(db);
    }

    public boolean createExtendedRelationsTable() {
        this.verifyWritable();
        boolean created = false;
        try {
            if (!this.extendedRelationsDao.isTableExists()) {
                created = this.geoPackage.getTableCreator().createExtendedRelations() > 0;
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to check if " + ExtendedRelation.class.getSimpleName() + " table exists and create it", e);
        }
        return created;
    }

    public String getPrimaryKeyColumnName(String tableName) {
        UserCustomTable table = UserCustomTableReader.readTable(this.geoPackage.getDatabase(), tableName);
        UserCustomColumn pkColumn = (UserCustomColumn)table.getPkColumn();
        if (pkColumn == null) {
            throw new GeoPackageException("Found no primary key for table " + tableName);
        }
        return pkColumn.getName();
    }

    public void setContents(UserTable<? extends UserColumn> table) {
        ContentsDao dao = this.geoPackage.getContentsDao();
        Contents contents = null;
        try {
            contents = dao.queryForId(table.getTableName());
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to retrieve " + Contents.class.getSimpleName() + " for table name: " + table.getTableName(), e);
        }
        if (contents == null) {
            throw new GeoPackageException("No Contents Table exists for table name: " + table.getTableName());
        }
        table.setContents(contents);
    }

    public List<ExtendedRelation> getRelationships() {
        ArrayList<ExtendedRelation> result = null;
        try {
            result = this.extendedRelationsDao.isTableExists() ? this.extendedRelationsDao.queryForAll() : new ArrayList<ExtendedRelation>();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to query for relationships in " + EXTENSION_NAME, e);
        }
        return result;
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, RelationType relationType) {
        return this.addRelationship(baseTableName, relatedTableName, mappingTableName, relationType.getName());
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, String relationAuthor, String relationName) {
        return this.addRelationship(baseTableName, relatedTableName, mappingTableName, this.buildRelationName(relationAuthor, relationName));
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, String mappingTableName, String relationName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        ExtendedRelation extendedRelation = this.addRelationship(baseTableName, relatedTableName, userMappingTable, relationName);
        return extendedRelation;
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, RelationType relationType) {
        return this.addRelationship(baseTableName, relatedTableName, userMappingTable, relationType.getName());
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, String relationAuthor, String relationName) {
        return this.addRelationship(baseTableName, relatedTableName, userMappingTable, this.buildRelationName(relationAuthor, relationName));
    }

    public ExtendedRelation addRelationship(String baseTableName, String relatedTableName, UserMappingTable userMappingTable, String relationName) {
        this.validateRelationship(baseTableName, relatedTableName, relationName);
        this.createUserMappingTable(userMappingTable);
        ExtendedRelation extendedRelation = new ExtendedRelation();
        extendedRelation.setBaseTableName(baseTableName);
        extendedRelation.setBasePrimaryColumn(this.getPrimaryKeyColumnName(baseTableName));
        extendedRelation.setRelatedTableName(relatedTableName);
        extendedRelation.setRelatedPrimaryColumn(this.getPrimaryKeyColumnName(relatedTableName));
        extendedRelation.setMappingTableName(userMappingTable.getTableName());
        extendedRelation.setRelationName(relationName);
        try {
            this.extendedRelationsDao.create(extendedRelation);
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to add relationship '" + relationName + "' between " + baseTableName + " and " + relatedTableName, e);
        }
        return extendedRelation;
    }

    public ExtendedRelation addRelationship(String baseTableName, UserRelatedTable relatedTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)relatedTable, relatedTable.getRelationName(), mappingTableName);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserRelatedTable relatedTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)relatedTable, relatedTable.getRelationName(), userMappingTable);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserTable<? extends UserColumn> relatedTable, String mappingTableName) {
        return this.addRelationship(baseTableName, relatedTable, relatedTable.getDataType(), mappingTableName);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserTable<? extends UserColumn> relatedTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, relatedTable, relatedTable.getDataType(), userMappingTable);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserTable<? extends UserColumn> relatedTable, String relationName, String mappingTableName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        return this.addRelationship(baseTableName, relatedTable, relationName, userMappingTable);
    }

    public ExtendedRelation addRelationship(String baseTableName, UserTable<? extends UserColumn> relatedTable, String relationName, UserMappingTable userMappingTable) {
        this.createRelatedTable(relatedTable);
        return this.addRelationship(baseTableName, relatedTable.getTableName(), userMappingTable, relationName);
    }

    public ExtendedRelation addFeaturesRelationship(String baseFeaturesTableName, String relatedFeaturesTableName, String mappingTableName) {
        return this.addRelationship(baseFeaturesTableName, relatedFeaturesTableName, mappingTableName, RelationType.FEATURES);
    }

    public ExtendedRelation addFeaturesRelationship(String baseFeaturesTableName, String relatedFeaturesTableName, UserMappingTable userMappingTable) {
        return this.addRelationship(baseFeaturesTableName, relatedFeaturesTableName, userMappingTable, RelationType.FEATURES);
    }

    public ExtendedRelation addMediaRelationship(String baseTableName, MediaTable mediaTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserRelatedTable)mediaTable, mappingTableName);
    }

    public ExtendedRelation addMediaRelationship(String baseTableName, MediaTable mediaTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserRelatedTable)mediaTable, userMappingTable);
    }

    public ExtendedRelation addSimpleAttributesRelationship(String baseTableName, SimpleAttributesTable simpleAttributesTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserRelatedTable)simpleAttributesTable, mappingTableName);
    }

    public ExtendedRelation addSimpleAttributesRelationship(String baseTableName, SimpleAttributesTable simpleAttributesTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserRelatedTable)simpleAttributesTable, userMappingTable);
    }

    public ExtendedRelation addAttributesRelationship(String baseTableName, String relatedAttributesTableName, String mappingTableName) {
        return this.addRelationship(baseTableName, relatedAttributesTableName, mappingTableName, RelationType.ATTRIBUTES);
    }

    public ExtendedRelation addAttributesRelationship(String baseTableName, String relatedAttributesTableName, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, relatedAttributesTableName, userMappingTable, RelationType.ATTRIBUTES);
    }

    public ExtendedRelation addAttributesRelationship(String baseTableName, AttributesTable attributesTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)attributesTable, mappingTableName);
    }

    public ExtendedRelation addAttributesRelationship(String baseTableName, AttributesTable attributesTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)attributesTable, userMappingTable);
    }

    public ExtendedRelation addTilesRelationship(String baseTableName, String relatedTilesTableName, String mappingTableName) {
        return this.addRelationship(baseTableName, relatedTilesTableName, mappingTableName, RelationType.TILES);
    }

    public ExtendedRelation addTilesRelationship(String baseTableName, String relatedTilesTableName, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, relatedTilesTableName, userMappingTable, RelationType.TILES);
    }

    public ExtendedRelation addTilesRelationship(String baseTableName, TileTable tileTable, String mappingTableName) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)tileTable, mappingTableName);
    }

    public ExtendedRelation addTilesRelationship(String baseTableName, TileTable tileTable, UserMappingTable userMappingTable) {
        return this.addRelationship(baseTableName, (UserTable<? extends UserColumn>)tileTable, userMappingTable);
    }

    private void validateRelationship(String baseTableName, String relatedTableName, String relationName) {
        if (!this.geoPackage.isTableOrView(baseTableName)) {
            throw new GeoPackageException("Base Relationship table does not exist: " + baseTableName + ", Relation: " + relationName);
        }
        if (!this.geoPackage.isTableOrView(relatedTableName)) {
            throw new GeoPackageException("Related Relationship table does not exist: " + relatedTableName + ", Relation: " + relationName);
        }
        RelationType relationType = RelationType.fromName(relationName);
        if (relationType != null) {
            this.validateRelationship(baseTableName, relatedTableName, relationType);
        }
    }

    private void validateRelationship(String baseTableName, String relatedTableName, RelationType relationType) {
        if (relationType != null && !this.geoPackage.isTableType(relatedTableName, relationType.getDataType())) {
            throw new GeoPackageException("The related table must be a " + relationType.getDataType() + " table. Related Table: " + relatedTableName + ", Type: " + this.geoPackage.getTableType(relatedTableName));
        }
    }

    public boolean createUserMappingTable(String mappingTableName) {
        UserMappingTable userMappingTable = UserMappingTable.create(mappingTableName);
        return this.createUserMappingTable(userMappingTable);
    }

    public boolean createUserMappingTable(UserMappingTable userMappingTable) {
        boolean created = false;
        String userMappingTableName = userMappingTable.getTableName();
        this.getOrCreate(userMappingTableName);
        if (!this.geoPackage.isTableOrView(userMappingTableName)) {
            this.geoPackage.createUserTable(userMappingTable);
            created = true;
        }
        return created;
    }

    public boolean createRelatedTable(UserTable<? extends UserColumn> relatedTable) {
        boolean created = false;
        String relatedTableName = relatedTable.getTableName();
        if (!this.geoPackage.isTableOrView(relatedTableName)) {
            this.geoPackage.createUserTable(relatedTable);
            try {
                Contents contents = new Contents();
                contents.setTableName(relatedTableName);
                contents.setDataTypeName(relatedTable.getDataType());
                contents.setIdentifier(relatedTableName);
                ContentsDao contentsDao = this.geoPackage.getContentsDao();
                contentsDao.create(contents);
                contentsDao.refresh(contents);
                relatedTable.setContents(contents);
                this.geoPackage.saveSchema(relatedTable);
            }
            catch (RuntimeException e) {
                this.geoPackage.deleteTableQuietly(relatedTableName);
                throw e;
            }
            catch (SQLException e) {
                this.geoPackage.deleteTableQuietly(relatedTableName);
                throw new GeoPackageException("Failed to create table and metadata: " + relatedTableName, e);
            }
            created = true;
        }
        return created;
    }

    public void removeRelationship(String baseTableName, String relatedTableName, RelationType relationType) {
        this.removeRelationship(baseTableName, relatedTableName, relationType.getName());
    }

    public void removeRelationship(String baseTableName, String relatedTableName, String relationAuthor, String relationName) {
        this.removeRelationship(baseTableName, relatedTableName, this.buildRelationName(relationAuthor, relationName));
    }

    public void removeRelationship(ExtendedRelation extendedRelation) {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                this.geoPackage.deleteTable(extendedRelation.getMappingTableName());
                this.extendedRelationsDao.delete(extendedRelation);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to remove relationship '" + extendedRelation.getRelationName() + "' between " + extendedRelation.getBaseTableName() + " and " + extendedRelation.getRelatedTableName() + " with mapping table " + extendedRelation.getMappingTableName(), e);
        }
    }

    public void removeRelationship(String baseTableName, String relatedTableName, String relationName) {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                List<ExtendedRelation> extendedRelations = this.getRelations(baseTableName, relatedTableName, relationName, null);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.removeRelationship(extendedRelation);
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to remove relationship '" + relationName + "' between " + baseTableName + " and " + relatedTableName, e);
        }
    }

    public void removeRelationships(String table) {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                List<ExtendedRelation> extendedRelations = this.extendedRelationsDao.getTableRelations(table);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.removeRelationship(extendedRelation);
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to remove relationships for table: " + table, e);
        }
    }

    public void removeRelationshipsWithMappingTable(String mappingTable) {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                List<ExtendedRelation> extendedRelations = this.getRelations(null, null, mappingTable);
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.removeRelationship(extendedRelation);
                }
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to remove relationships for mapping table: " + mappingTable, e);
        }
    }

    public void removeExtension() {
        try {
            if (this.extendedRelationsDao.isTableExists()) {
                List extendedRelations = this.extendedRelationsDao.queryForAll();
                for (ExtendedRelation extendedRelation : extendedRelations) {
                    this.geoPackage.deleteTable(extendedRelation.getMappingTableName());
                }
                this.geoPackage.dropTable(this.extendedRelationsDao.getTableName());
            }
            if (this.extensionsDao.isTableExists()) {
                this.extensionsDao.deleteByExtension(EXTENSION_NAME);
            }
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to delete Related Tables extension and table. GeoPackage: " + this.geoPackage.getName(), e);
        }
    }

    public boolean hasRelations(String baseTable, String relatedTable) throws SQLException {
        return this.hasRelations(baseTable, null, relatedTable, null, null, null);
    }

    public List<ExtendedRelation> getRelations(String baseTable, String relatedTable) {
        return this.getRelations(baseTable, null, relatedTable, null, null, null);
    }

    public boolean hasRelations(String baseTable, String relatedTable, String mappingTable) throws SQLException {
        return this.hasRelations(baseTable, null, relatedTable, null, null, mappingTable);
    }

    public List<ExtendedRelation> getRelations(String baseTable, String relatedTable, String mappingTable) throws SQLException {
        return this.getRelations(baseTable, null, relatedTable, null, null, mappingTable);
    }

    public boolean hasRelations(String baseTable, String relatedTable, String relation, String mappingTable) {
        return this.hasRelations(baseTable, null, relatedTable, null, relation, mappingTable);
    }

    public List<ExtendedRelation> getRelations(String baseTable, String relatedTable, String relation, String mappingTable) throws SQLException {
        return this.getRelations(baseTable, null, relatedTable, null, relation, mappingTable);
    }

    public boolean hasRelations(String baseTable, String baseColumn, String relatedTable, String relatedColumn, String relation, String mappingTable) {
        return !this.getRelations(baseTable, baseColumn, relatedTable, relatedColumn, relation, mappingTable).isEmpty();
    }

    public List<ExtendedRelation> getRelations(String baseTable, String baseColumn, String relatedTable, String relatedColumn, String relation, String mappingTable) {
        List<ExtendedRelation> relations = null;
        try {
            relations = this.extendedRelationsDao.isTableExists() ? this.extendedRelationsDao.getRelations(baseTable, baseColumn, relatedTable, relatedColumn, relation, mappingTable) : new ArrayList<ExtendedRelation>();
        }
        catch (SQLException e) {
            throw new GeoPackageException("Failed to get relationships. Base Table: " + baseTable + ", Base Column: " + baseColumn + ", Related Table: " + relatedTable + ", Related Column: " + relatedColumn + ", Relation: " + relation + ", Mapping Table: " + mappingTable, e);
        }
        return relations;
    }

    public String buildRelationName(String author, String name) {
        return "x-" + author + "_" + name;
    }

    public List<ExtendedRelation> getBaseTableRelations(String baseTable) throws SQLException {
        List<ExtendedRelation> extendedRelations = null;
        ExtendedRelationsDao dao = this.getExtendedRelationsDao();
        if (dao.isTableExists()) {
            extendedRelations = this.getExtendedRelationsDao().getBaseTableRelations(baseTable);
        }
        return extendedRelations;
    }

    public boolean hasBaseTableRelations(String baseTable) throws SQLException {
        List<ExtendedRelation> extendedRelations = this.getBaseTableRelations(baseTable);
        return extendedRelations != null && !extendedRelations.isEmpty();
    }

    public List<ExtendedRelation> getRelatedTableRelations(String relatedTable) throws SQLException {
        List<ExtendedRelation> extendedRelations = null;
        ExtendedRelationsDao dao = this.getExtendedRelationsDao();
        if (dao.isTableExists()) {
            extendedRelations = this.getExtendedRelationsDao().getRelatedTableRelations(relatedTable);
        }
        return extendedRelations;
    }

    public boolean hasRelatedTableRelations(String relatedTable) throws SQLException {
        List<ExtendedRelation> extendedRelations = this.getRelatedTableRelations(relatedTable);
        return extendedRelations != null && !extendedRelations.isEmpty();
    }

    public List<ExtendedRelation> getTableRelations(String table) throws SQLException {
        List<ExtendedRelation> extendedRelations = null;
        ExtendedRelationsDao dao = this.getExtendedRelationsDao();
        if (dao.isTableExists()) {
            extendedRelations = this.getExtendedRelationsDao().getTableRelations(table);
        }
        return extendedRelations;
    }

    public boolean hasTableRelations(String table) throws SQLException {
        List<ExtendedRelation> extendedRelations = this.getTableRelations(table);
        return extendedRelations != null && !extendedRelations.isEmpty();
    }
}

