/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common;

import com.linecorp.armeria.common.ContextAwareFutureListener;
import com.linecorp.armeria.common.RequestContext;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import io.netty.util.concurrent.Promise;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

final class ContextAwarePromise<T>
implements Promise<T> {
    private final RequestContext context;
    private final Promise<T> delegate;

    ContextAwarePromise(RequestContext context, Promise<T> delegate) {
        this.context = context;
        this.delegate = delegate;
    }

    public Promise<T> setSuccess(T result) {
        this.delegate.setSuccess(result);
        return this;
    }

    public boolean trySuccess(T result) {
        return this.delegate.trySuccess(result);
    }

    public Promise<T> setFailure(Throwable cause) {
        this.delegate.setFailure(cause);
        return this;
    }

    public boolean tryFailure(Throwable cause) {
        return this.delegate.tryFailure(cause);
    }

    public boolean setUncancellable() {
        return this.delegate.setUncancellable();
    }

    public Promise<T> addListener(GenericFutureListener<? extends Future<? super T>> listener) {
        this.delegate.addListener(ContextAwareFutureListener.of(this.context, listener));
        return this;
    }

    @SafeVarargs
    public final Promise<T> addListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        for (GenericFutureListener<? extends Future<? super T>> l : listeners) {
            this.delegate.addListeners(new GenericFutureListener[]{ContextAwareFutureListener.of(this.context, l)});
        }
        return this;
    }

    public Promise<T> removeListener(GenericFutureListener<? extends Future<? super T>> listener) {
        throw new UnsupportedOperationException();
    }

    @SafeVarargs
    public final Promise<T> removeListeners(GenericFutureListener<? extends Future<? super T>> ... listeners) {
        throw new UnsupportedOperationException();
    }

    public Promise<T> sync() throws InterruptedException {
        this.delegate.sync();
        return this;
    }

    public Promise<T> syncUninterruptibly() {
        this.delegate.syncUninterruptibly();
        return this;
    }

    public boolean isSuccess() {
        return this.delegate.isSuccess();
    }

    public boolean isCancellable() {
        return this.delegate.isCancellable();
    }

    public Throwable cause() {
        return this.delegate.cause();
    }

    public Promise<T> await() throws InterruptedException {
        this.delegate.await();
        return this;
    }

    public boolean await(long timeout, TimeUnit unit) throws InterruptedException {
        return this.delegate.await(timeout, unit);
    }

    public boolean await(long timeoutMillis) throws InterruptedException {
        return this.delegate.await(timeoutMillis);
    }

    public Promise<T> awaitUninterruptibly() {
        this.delegate.awaitUninterruptibly();
        return this;
    }

    public boolean awaitUninterruptibly(long timeout, TimeUnit unit) {
        return this.delegate.awaitUninterruptibly(timeout, unit);
    }

    public boolean awaitUninterruptibly(long timeoutMillis) {
        return this.delegate.awaitUninterruptibly(timeoutMillis);
    }

    public T getNow() {
        return (T)this.delegate.getNow();
    }

    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.delegate.cancel(mayInterruptIfRunning);
    }

    public boolean isCancelled() {
        return this.delegate.isCancelled();
    }

    public boolean isDone() {
        return this.delegate.isDone();
    }

    public T get() throws InterruptedException, ExecutionException {
        return (T)this.delegate.get();
    }

    public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return (T)this.delegate.get(timeout, unit);
    }
}

