/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.common.metric;

import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.common.util.CertificateUtil;
import com.linecorp.armeria.internal.shaded.guava.base.MoreObjects;
import io.micrometer.core.instrument.Gauge;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.binder.MeterBinder;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.util.List;

final class CertificateMetrics
implements MeterBinder {
    private final List<X509Certificate> certificates;
    private final MeterIdPrefix meterIdPrefix;

    CertificateMetrics(List<X509Certificate> certificates, MeterIdPrefix meterIdPrefix) {
        this.certificates = certificates;
        this.meterIdPrefix = meterIdPrefix;
    }

    public void bindTo(MeterRegistry registry) {
        for (X509Certificate certificate : this.certificates) {
            String commonName = MoreObjects.firstNonNull(CertificateUtil.getCommonName(certificate), "");
            Gauge.builder((String)this.meterIdPrefix.name("tls.certificate.validity"), (Object)certificate, x509Cert -> {
                try {
                    x509Cert.checkValidity();
                }
                catch (CertificateExpiredException | CertificateNotYetValidException e) {
                    return 0.0;
                }
                return 1.0;
            }).description("1 if TLS certificate is in validity period, 0 if certificate is not in validity period").tags(new String[]{"common.name", commonName}).tags(this.meterIdPrefix.tags()).register(registry);
            Gauge.builder((String)this.meterIdPrefix.name("tls.certificate.validity.days"), (Object)certificate, x509Cert -> {
                Duration diff = Duration.between(Instant.now(), x509Cert.getNotAfter().toInstant());
                return diff.isNegative() ? -1.0 : (double)diff.toDays();
            }).description("Duration in days before TLS certificate expires, which becomes -1 if certificate is expired").tags(new String[]{"common.name", commonName}).tags(this.meterIdPrefix.tags()).register(registry);
        }
    }
}

