/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.metric;

import com.linecorp.armeria.common.metric.MeterIdPrefix;
import com.linecorp.armeria.internal.shaded.guava.collect.MapMaker;
import io.micrometer.core.instrument.MeterRegistry;
import java.util.ArrayDeque;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiFunction;

public final class MicrometerUtil {
    private static final ConcurrentMap<MeterRegistry, ConcurrentMap<MeterIdPrefix, Object>> map = new MapMaker().weakKeys().makeMap();
    private static final ThreadLocal<RegistrationState> registrationState = ThreadLocal.withInitial(() -> new RegistrationState());

    public static <T> T register(MeterRegistry registry, MeterIdPrefix idPrefix, Class<T> type, BiFunction<MeterRegistry, MeterIdPrefix, T> factory) {
        Objects.requireNonNull(registry, "registry");
        Objects.requireNonNull(idPrefix, "idPrefix");
        Objects.requireNonNull(type, "type");
        Objects.requireNonNull(factory, "factory");
        ConcurrentMap objects = map.computeIfAbsent(registry, unused -> new ConcurrentHashMap());
        RegistrationState registrationState = MicrometerUtil.registrationState.get();
        if (registrationState.isRegistering) {
            throw new IllegalStateException("nested registration prohibited");
        }
        Object object = MicrometerUtil.register(objects, registrationState, registry, idPrefix, type, factory);
        MicrometerUtil.handlePendingRegistrations(objects, registrationState);
        Object cast = object;
        return (T)cast;
    }

    private static <T> Object register(ConcurrentMap<MeterIdPrefix, Object> map, RegistrationState registrationState, MeterRegistry registry, MeterIdPrefix idPrefix, Class<T> type, BiFunction<MeterRegistry, MeterIdPrefix, T> factory) {
        Object object = map.computeIfAbsent(idPrefix, i -> {
            registrationState.isRegistering = true;
            try {
                Object r = factory.apply(registry, (MeterIdPrefix)i);
                return r;
            }
            finally {
                registrationState.isRegistering = false;
            }
        });
        if (!type.isInstance(object)) {
            throw new IllegalStateException("An object of different type has been registered already for idPrefix: " + idPrefix + " (expected: " + type.getName() + ", actual: " + (object != null ? object.getClass().getName() : "null") + ')');
        }
        return object;
    }

    private static void handlePendingRegistrations(ConcurrentMap<MeterIdPrefix, Object> map, RegistrationState registrationState) {
        PendingRegistration<?> pendingRegistration;
        while ((pendingRegistration = registrationState.pendingRegistrations.poll()) != null) {
            MicrometerUtil.register(map, registrationState, pendingRegistration.registry, pendingRegistration.idPrefix, pendingRegistration.type, pendingRegistration.factory);
        }
    }

    public static <T> void registerLater(MeterRegistry registry, MeterIdPrefix idPrefix, Class<T> type, BiFunction<MeterRegistry, MeterIdPrefix, T> factory) {
        RegistrationState registrationState = MicrometerUtil.registrationState.get();
        if (!registrationState.isRegistering) {
            MicrometerUtil.register(registry, idPrefix, type, factory);
        } else {
            registrationState.pendingRegistrations.add(new PendingRegistration<T>(registry, idPrefix, type, factory));
        }
    }

    public static void clear() {
        map.clear();
    }

    private MicrometerUtil() {
    }

    private static final class RegistrationState {
        boolean isRegistering;
        final Queue<PendingRegistration<?>> pendingRegistrations = new ArrayDeque();

        private RegistrationState() {
        }
    }

    private static final class PendingRegistration<T> {
        final MeterRegistry registry;
        final MeterIdPrefix idPrefix;
        final Class<T> type;
        final BiFunction<MeterRegistry, MeterIdPrefix, T> factory;

        PendingRegistration(MeterRegistry registry, MeterIdPrefix idPrefix, Class<T> type, BiFunction<MeterRegistry, MeterIdPrefix, T> factory) {
            this.registry = registry;
            this.idPrefix = idPrefix;
            this.type = type;
            this.factory = factory;
        }
    }
}

