/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.common.stream;

import com.linecorp.armeria.common.annotation.Nullable;
import com.linecorp.armeria.common.stream.AbortedStreamException;
import com.linecorp.armeria.common.stream.CancelledSubscriptionException;
import com.linecorp.armeria.common.stream.NoopSubscriber;
import com.linecorp.armeria.common.stream.PublisherBasedStreamMessage;
import com.linecorp.armeria.common.stream.StreamMessage;
import com.linecorp.armeria.common.stream.SubscriptionOption;
import com.linecorp.armeria.common.util.EventLoopCheckingFuture;
import com.linecorp.armeria.internal.common.stream.InternalStreamMessageUtil;
import com.linecorp.armeria.internal.common.stream.NoopSubscription;
import com.linecorp.armeria.internal.common.stream.StreamMessageUtil;
import com.linecorp.armeria.internal.shaded.guava.math.LongMath;
import io.netty.util.concurrent.EventExecutor;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import java.util.function.Function;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SurroundingPublisher<T>
implements StreamMessage<T> {
    private static final Logger logger = LoggerFactory.getLogger(SurroundingPublisher.class);
    private static final AtomicIntegerFieldUpdater<SurroundingPublisher> subscribedUpdater = AtomicIntegerFieldUpdater.newUpdater(SurroundingPublisher.class, "subscribed");
    @Nullable
    private final T head;
    private final StreamMessage<T> publisher;
    private final Function<@Nullable Throwable, ? extends @Nullable T> finalizer;
    private volatile int subscribed;
    private final CompletableFuture<Void> completionFuture = new EventLoopCheckingFuture<Void>();
    @Nullable
    private volatile SurroundingSubscriber<T> surroundingSubscriber;

    public SurroundingPublisher(@Nullable T head, Publisher<? extends T> publisher, Function<@Nullable Throwable, ? extends @Nullable T> finalizer) {
        Objects.requireNonNull(publisher, "publisher");
        Objects.requireNonNull(finalizer, "finalizer");
        this.head = head;
        this.publisher = publisher instanceof StreamMessage ? (StreamMessage)publisher : new PublisherBasedStreamMessage<T>(publisher);
        this.finalizer = finalizer;
    }

    @Override
    public boolean isOpen() {
        return !this.completionFuture.isDone();
    }

    @Override
    public boolean isEmpty() {
        if (this.isOpen()) {
            return false;
        }
        SurroundingSubscriber<T> surroundingSubscriber = this.surroundingSubscriber;
        return surroundingSubscriber == null || !((SurroundingSubscriber)surroundingSubscriber).publishedAny;
    }

    @Override
    public long demand() {
        SurroundingSubscriber<T> surroundingSubscriber = this.surroundingSubscriber;
        if (surroundingSubscriber != null) {
            return ((SurroundingSubscriber)surroundingSubscriber).requested;
        }
        return 0L;
    }

    @Override
    public CompletableFuture<Void> whenComplete() {
        return this.completionFuture;
    }

    @Override
    public void subscribe(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        Objects.requireNonNull(subscriber, "subscriber");
        Objects.requireNonNull(executor, "executor");
        Objects.requireNonNull(options, "options");
        if (!subscribedUpdater.compareAndSet(this, 0, 1)) {
            subscriber.onSubscribe((Subscription)NoopSubscription.get());
            if (this.completionFuture.isCompletedExceptionally()) {
                this.completionFuture.exceptionally(cause -> {
                    subscriber.onError(cause);
                    return null;
                });
            } else {
                subscriber.onError((Throwable)new IllegalStateException("Only single subscriber is allowed!"));
            }
            return;
        }
        if (executor.inEventLoop()) {
            this.subscribe0(subscriber, executor, options);
        } else {
            executor.execute(() -> this.subscribe0(subscriber, executor, options));
        }
    }

    private void subscribe0(Subscriber<? super T> subscriber, EventExecutor executor, SubscriptionOption ... options) {
        SurroundingSubscriber surroundingSubscriber = new SurroundingSubscriber(this.head, this.publisher, this.finalizer, subscriber, executor, this.completionFuture, options);
        this.surroundingSubscriber = surroundingSubscriber;
        subscriber.onSubscribe(surroundingSubscriber);
        if (this.completionFuture.isCompletedExceptionally()) {
            this.completionFuture.exceptionally(cause -> {
                surroundingSubscriber.close(cause);
                return null;
            });
        }
    }

    @Override
    public void abort() {
        this.abort(AbortedStreamException.get());
    }

    @Override
    public void abort(Throwable cause) {
        Objects.requireNonNull(cause, "cause");
        this.completionFuture.completeExceptionally(cause);
        if (subscribedUpdater.compareAndSet(this, 0, 1)) {
            this.publisher.abort(cause);
            if (this.head != null) {
                StreamMessageUtil.closeOrAbort(this.head, cause);
            }
            return;
        }
        SurroundingSubscriber<T> surroundingSubscriber = this.surroundingSubscriber;
        if (surroundingSubscriber != null) {
            ((SurroundingSubscriber)surroundingSubscriber).close(cause);
        }
    }

    private static final class SurroundingSubscriber<T>
    implements Subscriber<T>,
    Subscription {
        private State state;
        @Nullable
        private T head;
        private final StreamMessage<T> publisher;
        private final Function<@Nullable Throwable, ? extends @Nullable T> finalizer;
        private Subscriber<? super T> downstream;
        private final EventExecutor executor;
        @Nullable
        private volatile Subscription upstream;
        private long requested;
        private long upstreamRequested;
        private boolean subscribed;
        private volatile boolean publishedAny;
        private final CompletableFuture<Void> completionFuture;
        private final SubscriptionOption[] options;

        SurroundingSubscriber(@Nullable T head, StreamMessage<T> publisher, Function<@Nullable Throwable, ? extends @Nullable T> finalizer, Subscriber<? super T> downstream, EventExecutor executor, CompletableFuture<Void> completionFuture, SubscriptionOption ... options) {
            Objects.requireNonNull(publisher, "publisher");
            Objects.requireNonNull(downstream, "downstream");
            Objects.requireNonNull(executor, "executor");
            this.state = head != null ? State.REQUIRE_HEAD : State.REQUIRE_BODY;
            this.head = head;
            this.publisher = publisher;
            this.finalizer = finalizer;
            this.downstream = downstream;
            this.executor = executor;
            this.completionFuture = completionFuture;
            this.options = options;
        }

        public void request(long n) {
            if (n <= 0L) {
                this.close(new IllegalArgumentException("non-positive request signals are illegal"));
                return;
            }
            if (this.executor.inEventLoop()) {
                this.request0(n);
            } else {
                this.executor.execute(() -> this.request0(n));
            }
        }

        private void request0(long n) {
            if (this.state == State.DONE) {
                return;
            }
            long oldRequested = this.requested;
            if (oldRequested == Long.MAX_VALUE) {
                return;
            }
            this.requested = n == Long.MAX_VALUE ? Long.MAX_VALUE : LongMath.saturatedAdd(oldRequested, n);
            if (oldRequested > 0L) {
                return;
            }
            this.publish();
        }

        private void publish() {
            if (this.state == State.DONE || this.requested <= 0L && this.upstreamRequested <= 0L) {
                return;
            }
            switch (this.state.ordinal()) {
                case 0: {
                    this.sendHead();
                    break;
                }
                case 1: {
                    if (!this.subscribed) {
                        this.subscribed = true;
                        this.publisher.subscribe(this, this.executor, this.options);
                        return;
                    }
                    if (this.upstreamRequested > 0L) {
                        return;
                    }
                    Subscription upstream = this.upstream;
                    if (upstream == null) break;
                    this.requestUpstream(upstream);
                    break;
                }
                case 2: {
                    this.sendTail();
                }
            }
        }

        private void sendHead() {
            this.setState(State.REQUIRE_HEAD, State.REQUIRE_BODY);
            assert (this.head != null);
            T head = this.head;
            this.head = null;
            this.publishDownstream(head, true);
        }

        private void sendTail() {
            assert (this.state == State.REQUIRE_TAIL);
            this.finalize(null);
        }

        private void finalize(@Nullable Throwable cause) {
            T tail;
            try {
                tail = this.finalizer.apply(cause);
            }
            catch (Throwable ex) {
                if (cause != null) {
                    logger.warn("Unexpected exception from finalizer:", ex);
                    this.close0(cause);
                } else {
                    this.close0(ex);
                }
                return;
            }
            if (tail == null) {
                this.close0(cause);
            } else {
                this.downstream.onNext(tail);
                this.close0(null);
            }
        }

        private void requestUpstream(Subscription subscription) {
            if (this.requested <= 0L) {
                return;
            }
            assert (this.upstreamRequested == 0L);
            this.upstreamRequested = this.requested;
            if (this.requested < Long.MAX_VALUE) {
                this.requested = 0L;
            }
            subscription.request(this.upstreamRequested);
        }

        private void publishDownstream(T item, boolean head) {
            Objects.requireNonNull(item, "item");
            if (this.state == State.DONE) {
                StreamMessageUtil.closeOrAbort(item);
                return;
            }
            this.downstream.onNext(item);
            if (head) {
                if (this.requested < Long.MAX_VALUE) {
                    --this.requested;
                }
                this.subscribed = true;
                this.publisher.subscribe(this, this.executor, this.options);
            } else {
                assert (this.upstreamRequested > 0L);
                if (this.upstreamRequested < Long.MAX_VALUE) {
                    --this.upstreamRequested;
                }
            }
            if (!this.publishedAny) {
                this.publishedAny = true;
            }
            this.publish();
        }

        public void onSubscribe(Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription");
            if (this.state == State.DONE) {
                subscription.cancel();
                return;
            }
            this.upstream = subscription;
            this.requestUpstream(subscription);
        }

        public void onNext(T item) {
            Objects.requireNonNull(item, "item");
            this.publishDownstream(item, false);
        }

        public void onError(Throwable cause) {
            Objects.requireNonNull(cause, "cause");
            this.finalize(cause);
        }

        public void onComplete() {
            if (this.state == State.DONE) {
                return;
            }
            this.setState(State.REQUIRE_BODY, State.REQUIRE_TAIL);
            this.publish();
        }

        public void cancel() {
            if (this.executor.inEventLoop()) {
                this.cancel0();
            } else {
                this.executor.execute(this::cancel0);
            }
        }

        private void cancel0() {
            if (this.state == State.DONE) {
                return;
            }
            this.state = State.DONE;
            Subscription upstream = this.upstream;
            if (upstream != null) {
                upstream.cancel();
            }
            CancelledSubscriptionException cause = CancelledSubscriptionException.get();
            if (InternalStreamMessageUtil.containsNotifyCancellation(this.options)) {
                this.downstream.onError((Throwable)cause);
            }
            this.downstream = NoopSubscriber.get();
            this.completionFuture.completeExceptionally(cause);
            this.release(null);
        }

        private void close(@Nullable Throwable cause) {
            if (this.executor.inEventLoop()) {
                this.close0(cause);
            } else {
                this.executor.execute(() -> this.close0(cause));
            }
        }

        private void close0(@Nullable Throwable cause) {
            if (this.state == State.DONE) {
                return;
            }
            this.state = State.DONE;
            if (cause == null) {
                this.downstream.onComplete();
                this.completionFuture.complete(null);
            } else {
                this.downstream.onError(cause);
                Subscription upstream = this.upstream;
                if (upstream != null) {
                    upstream.cancel();
                }
                this.completionFuture.completeExceptionally(cause);
            }
            this.release(cause);
        }

        private void release(@Nullable Throwable cause) {
            if (this.head != null) {
                StreamMessageUtil.closeOrAbort(this.head, cause);
            }
        }

        private void setState(State oldState, State newState) {
            assert (this.state == oldState) : "curState: " + (Object)((Object)this.state) + ", oldState: " + (Object)((Object)oldState) + ", newState: " + (Object)((Object)newState);
            assert (newState != State.REQUIRE_HEAD) : "oldState: " + (Object)((Object)oldState) + ", newState: " + (Object)((Object)newState);
            this.state = newState;
        }

        static enum State {
            REQUIRE_HEAD,
            REQUIRE_BODY,
            REQUIRE_TAIL,
            DONE;

        }
    }
}

