/*
 * Decompiled with CFR 0.152.
 */
package com.linecorp.armeria.internal.shaded.guava.base;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.linecorp.armeria.internal.shaded.guava.base.NullnessCasts;
import com.linecorp.armeria.internal.shaded.guava.base.Preconditions;
import java.util.Iterator;
import java.util.NoSuchElementException;
import javax.annotation.CheckForNull;

abstract class AbstractIterator<T>
implements Iterator<T> {
    private State state = State.NOT_READY;
    @CheckForNull
    private T next;

    protected AbstractIterator() {
    }

    @CheckForNull
    protected abstract T computeNext();

    @CheckForNull
    @CanIgnoreReturnValue
    protected final T endOfData() {
        this.state = State.DONE;
        return null;
    }

    @Override
    public final boolean hasNext() {
        Preconditions.checkState(this.state != State.FAILED);
        switch (this.state) {
            case DONE: {
                return false;
            }
            case READY: {
                return true;
            }
        }
        return this.tryToComputeNext();
    }

    private boolean tryToComputeNext() {
        this.state = State.FAILED;
        this.next = this.computeNext();
        if (this.state != State.DONE) {
            this.state = State.READY;
            return true;
        }
        return false;
    }

    @Override
    public final T next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        this.state = State.NOT_READY;
        T result = NullnessCasts.uncheckedCastNullableTToT(this.next);
        this.next = null;
        return result;
    }

    @Override
    public final void remove() {
        throw new UnsupportedOperationException();
    }

    private static final class State
    extends Enum<State> {
        public static final /* enum */ State READY = new State();
        public static final /* enum */ State NOT_READY = new State();
        public static final /* enum */ State DONE = new State();
        public static final /* enum */ State FAILED = new State();
        private static final /* synthetic */ State[] $VALUES;

        public static State[] values() {
            return (State[])$VALUES.clone();
        }

        static {
            $VALUES = new State[]{READY, NOT_READY, DONE, FAILED};
        }
    }
}

