/*
 * Decompiled with CFR 0.152.
 */
package org.locationtech.proj4j.proj;

import org.locationtech.proj4j.ProjCoordinate;
import org.locationtech.proj4j.ProjectionException;
import org.locationtech.proj4j.proj.AzimuthalProjection;
import org.locationtech.proj4j.util.ProjectionMath;

public class GnomonicAzimuthalProjection
extends AzimuthalProjection {
    public GnomonicAzimuthalProjection() {
        this(Math.toRadians(90.0), Math.toRadians(0.0));
    }

    public GnomonicAzimuthalProjection(double projectionLatitude, double projectionLongitude) {
        super(projectionLatitude, projectionLongitude);
        this.minLatitude = Math.toRadians(0.0);
        this.maxLatitude = Math.toRadians(90.0);
        this.initialize();
    }

    @Override
    public void initialize() {
        super.initialize();
    }

    @Override
    public ProjCoordinate project(double lam, double phi, ProjCoordinate xy) {
        double sinphi = Math.sin(phi);
        double cosphi = Math.cos(phi);
        double coslam = Math.cos(lam);
        switch (this.mode) {
            case 3: {
                xy.y = cosphi * coslam;
                break;
            }
            case 4: {
                xy.y = this.sinphi0 * sinphi + this.cosphi0 * cosphi * coslam;
                break;
            }
            case 2: {
                xy.y = -sinphi;
                break;
            }
            case 1: {
                xy.y = sinphi;
            }
        }
        if (Math.abs(xy.y) <= 1.0E-10) {
            throw new ProjectionException();
        }
        xy.y = 1.0 / xy.y;
        xy.x = xy.y * cosphi * Math.sin(lam);
        switch (this.mode) {
            case 3: {
                xy.y *= sinphi;
                break;
            }
            case 4: {
                xy.y *= this.cosphi0 * sinphi - this.sinphi0 * cosphi * coslam;
                break;
            }
            case 1: {
                coslam = -coslam;
            }
            case 2: {
                xy.y *= cosphi * coslam;
            }
        }
        return xy;
    }

    @Override
    public ProjCoordinate projectInverse(double x, double y, ProjCoordinate lp) {
        double rh = ProjectionMath.distance(x, y);
        lp.y = Math.atan(rh);
        double sinz = Math.sin(lp.y);
        double cosz = Math.sqrt(1.0 - sinz * sinz);
        if (Math.abs(rh) <= 1.0E-10) {
            lp.y = this.projectionLatitude;
            lp.x = 0.0;
        } else {
            switch (this.mode) {
                case 4: {
                    lp.y = cosz * this.sinphi0 + y * sinz * this.cosphi0 / rh;
                    lp.y = Math.abs(lp.y) >= 1.0 ? (lp.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(lp.y);
                    y = (cosz - this.sinphi0 * Math.sin(lp.y)) * rh;
                    x *= sinz * this.cosphi0;
                    break;
                }
                case 3: {
                    lp.y = y * sinz / rh;
                    lp.y = Math.abs(lp.y) >= 1.0 ? (lp.y > 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.asin(lp.y);
                    y = cosz * rh;
                    x *= sinz;
                    break;
                }
                case 2: {
                    lp.y -= 1.5707963267948966;
                    break;
                }
                case 1: {
                    lp.y = 1.5707963267948966 - lp.y;
                    y = -y;
                }
            }
            lp.x = Math.atan2(x, y);
        }
        return lp;
    }

    @Override
    public boolean hasInverse() {
        return true;
    }

    @Override
    public String toString() {
        return "Gnomonic Azimuthal";
    }
}

