/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.feature;

import java.util.Collection;
import java.util.EnumMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.feature.AbstractIdentifiedType;
import org.apache.sis.feature.AbstractOperation;
import org.apache.sis.feature.DefaultAssociationRole;
import org.apache.sis.feature.DefaultAttributeType;
import org.apache.sis.feature.LinkOperation;
import org.apache.sis.feature.OperationResult;
import org.apache.sis.feature.Property;
import org.apache.sis.feature.internal.AttributeConvention;
import org.apache.sis.feature.internal.FeatureUtilities;
import org.apache.sis.feature.internal.Resources;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.setup.GeometryLibrary;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.util.ScopedName;

final class GroupAsPolylineOperation
extends AbstractOperation {
    private static final long serialVersionUID = -1995248173704801739L;
    private static final ParameterDescriptorGroup EMPTY_PARAMS = FeatureUtilities.parameters("GroupAsPolyline", new ParameterDescriptor[0]);
    private final String propertyName;
    private final boolean isFeatureAssociation;
    private final Geometries<?> geometries;
    private static final EnumMap<GeometryLibrary, DefaultAttributeType<?>> TYPES = new EnumMap(GeometryLibrary.class);

    static AbstractOperation create(Map<String, ?> identification, GeometryLibrary library, AbstractIdentifiedType components) {
        boolean isFeatureAssociation;
        if (components instanceof LinkOperation) {
            components = ((LinkOperation)components).result;
        }
        if (components instanceof DefaultAttributeType) {
            if (((DefaultAttributeType)components).getMaximumOccurs() <= 1) {
                return new LinkOperation(identification, components);
            }
            isFeatureAssociation = false;
        } else {
            boolean bl = isFeatureAssociation = components instanceof DefaultAssociationRole && ((DefaultAssociationRole)components).getMaximumOccurs() == 1;
            if (!isFeatureAssociation) {
                throw new IllegalArgumentException(Resources.format((short)29, components.getName(), components.getClass()));
            }
        }
        return new GroupAsPolylineOperation(identification, Geometries.factory(library), components, isFeatureAssociation);
    }

    private GroupAsPolylineOperation(Map<String, ?> identification, Geometries<?> geometries, AbstractIdentifiedType components, boolean isFeatureAssociation) {
        super(identification);
        this.geometries = geometries;
        this.propertyName = components.getName().toString();
        this.isFeatureAssociation = isFeatureAssociation;
    }

    @Override
    public ParameterDescriptorGroup getParameters() {
        return EMPTY_PARAMS;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public final DefaultAttributeType<?> getResult() {
        EnumMap<GeometryLibrary, DefaultAttributeType<?>> enumMap = TYPES;
        synchronized (enumMap) {
            return TYPES.computeIfAbsent(this.geometries.library, library -> {
                Map<String, ScopedName> name = Map.of("name", AttributeConvention.ENVELOPE_PROPERTY);
                return new DefaultAttributeType<Object>(name, this.geometries.polylineClass, 1, 1, null, new DefaultAttributeType[0]);
            });
        }
    }

    @Override
    public final Property apply(AbstractFeature feature, ParameterValueGroup parameters) {
        return new Result(this.getResult(), feature);
    }

    @Override
    public int hashCode() {
        return super.hashCode() + this.propertyName.hashCode() + this.geometries.hashCode();
    }

    @Override
    public boolean equals(Object obj) {
        if (super.equals(obj)) {
            GroupAsPolylineOperation that = (GroupAsPolylineOperation)obj;
            return this.propertyName.equals(that.propertyName) && this.geometries.equals(that.geometries);
        }
        return false;
    }

    private final class Result<G>
    extends OperationResult<G> {
        private static final long serialVersionUID = 5558751012506417903L;
        private transient G geometry;

        Result(DefaultAttributeType<G> resultType, AbstractFeature feature) {
            super(resultType, feature);
        }

        @Override
        public G getValue() {
            if (this.geometry == null) {
                this.geometry = this.compute();
            }
            return this.geometry;
        }

        private G compute() {
            Iterator<Object> paths = ((Collection)this.feature.getPropertyValue(GroupAsPolylineOperation.this.propertyName)).iterator();
            if (GroupAsPolylineOperation.this.isFeatureAssociation) {
                final Iterator<Object> it = paths;
                paths = new Iterator<Object>(){

                    @Override
                    public boolean hasNext() {
                        return it.hasNext();
                    }

                    @Override
                    public Object next() {
                        return ((AbstractFeature)it.next()).getPropertyValue("sis:geometry");
                    }
                };
            }
            while (paths.hasNext()) {
                GeometryWrapper first = GroupAsPolylineOperation.this.geometries.castOrWrap(paths.next());
                if (first == null) continue;
                Object geom = first.mergePolylines(paths);
                return (G)this.getType().getValueClass().cast(geom);
            }
            return null;
        }
    }
}

