/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.filter;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import org.apache.sis.filter.Filter;
import org.apache.sis.filter.Optimization;
import org.apache.sis.filter.internal.Node;
import org.apache.sis.pending.geoapi.filter.LogicalOperator;
import org.apache.sis.pending.geoapi.filter.LogicalOperatorName;
import org.apache.sis.util.ArgumentChecks;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.util.internal.UnmodifiableArrayList;

abstract class LogicalFilter<R>
extends Node
implements LogicalOperator<R>,
Optimization.OnFilter<R> {
    private static final long serialVersionUID = 3696645262873257479L;
    protected final Filter<R>[] operands;

    LogicalFilter(Collection<? extends Filter<R>> op) {
        ArgumentChecks.ensureNonEmpty((String)"operands", op);
        this.operands = (Filter[])op.toArray(Filter[]::new);
        ArgumentChecks.ensureCountBetween((String)"operands", (boolean)true, (int)2, (int)Integer.MAX_VALUE, (int)this.operands.length);
        for (int i = 0; i < this.operands.length; ++i) {
            ArgumentChecks.ensureNonNullElement((String)"operands", (int)i, this.operands[i]);
        }
    }

    LogicalFilter(Filter<R> operand1, Filter<R> operand2) {
        this.operands = new Filter[]{operand1, operand2};
    }

    protected abstract LogicalFilter<R> createSameType(Collection<? extends Filter<R>> var1);

    @Override
    public Class<? super R> getResourceClass() {
        Class<Object> type = Object.class;
        for (Filter<R> operand : this.operands) {
            type = LogicalFilter.specializedClass(type, operand.getResourceClass());
        }
        return type;
    }

    @Override
    public final List<Filter<R>> getOperands() {
        return UnmodifiableArrayList.wrap((Object[])this.operands);
    }

    @Override
    protected final Collection<?> getChildren() {
        return this.getOperands();
    }

    final Filter<R> optimize(Optimization optimization, Filter<R> ignore, Filter<R> shortCircuit) {
        boolean unchanged = true;
        Class<?> inline = this.getClass();
        LinkedHashSet<Filter<R>> effective = new LinkedHashSet<Filter<R>>();
        for (Filter<R> f : this.operands) {
            unchanged &= f == (f = optimization.apply(f));
            if (f == ignore) {
                unchanged = false;
                continue;
            }
            if (f == shortCircuit) {
                return shortCircuit;
            }
            if (f.getClass() != inline) {
                unchanged &= effective.add(f);
                continue;
            }
            unchanged = false;
            for (Filter<R> s : ((LogicalFilter)f).operands) {
                if (f == ignore) continue;
                if (f == shortCircuit) {
                    return shortCircuit;
                }
                assert (s.getClass() != inline);
                effective.add(optimization.apply(s));
            }
        }
        for (Filter filter : effective) {
            if (!LogicalOperatorName.NOT.equals(filter.getOperatorType()) || !effective.containsAll(((LogicalOperator)filter).getOperands())) continue;
            return shortCircuit;
        }
        if (unchanged) {
            return this;
        }
        LogicalFilter<R> c = (LogicalFilter<R>)CollectionsExt.singletonOrNull(effective);
        return c != null ? c : this.createSameType(effective);
    }

    static final class Not<R>
    extends Node
    implements LogicalOperator<R>,
    Optimization.OnFilter<R> {
        private static final long serialVersionUID = -1296823195138427781L;
        private final Filter<R> operand;

        Not(Filter<R> operand) {
            ArgumentChecks.ensureNonNull((String)"operand", operand);
            this.operand = operand;
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.NOT;
        }

        @Override
        public Class<? super R> getResourceClass() {
            return this.operand.getResourceClass();
        }

        @Override
        protected char symbol() {
            return '\u00ac';
        }

        @Override
        protected final Collection<?> getChildren() {
            return this.getOperands();
        }

        @Override
        public List<Filter<R>> getOperands() {
            return List.of(this.operand);
        }

        @Override
        public boolean test(R object) {
            return !this.operand.test(object);
        }

        @Override
        public Filter<R> optimize(Optimization optimization) {
            Filter<R> effective = optimization.apply(this.operand);
            if (effective == Filter.include()) {
                return Filter.exclude();
            }
            if (effective == Filter.exclude()) {
                return Filter.include();
            }
            if (effective instanceof Not) {
                return ((Not)effective).operand;
            }
            return effective != this.operand ? new Not<R>(effective) : this;
        }
    }

    static final class Or<R>
    extends LogicalFilter<R> {
        private static final long serialVersionUID = 3805785720811330282L;

        Or(Collection<? extends Filter<R>> op) {
            super(op);
        }

        Or(Filter<R> operand1, Filter<R> operand2) {
            super(operand1, operand2);
        }

        @Override
        protected LogicalFilter<R> createSameType(Collection<? extends Filter<R>> op) {
            return new Or<R>(op);
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.OR;
        }

        @Override
        protected char symbol() {
            return this.operands.length <= 2 ? (char)'\u2228' : '\u22c1';
        }

        @Override
        public boolean test(R object) {
            for (Filter filter : this.operands) {
                if (!filter.test(object)) continue;
                return true;
            }
            return false;
        }

        @Override
        public Filter<R> optimize(Optimization optimization) {
            return this.optimize(optimization, Filter.exclude(), Filter.include());
        }
    }

    static final class And<R>
    extends LogicalFilter<R> {
        private static final long serialVersionUID = 152892064260384713L;

        And(Collection<? extends Filter<R>> op) {
            super(op);
        }

        And(Filter<R> operand1, Filter<R> operand2) {
            super(operand1, operand2);
        }

        @Override
        protected LogicalFilter<R> createSameType(Collection<? extends Filter<R>> op) {
            return new And<R>(op);
        }

        @Override
        public LogicalOperatorName getOperatorType() {
            return LogicalOperatorName.AND;
        }

        @Override
        protected char symbol() {
            return this.operands.length <= 2 ? (char)'\u2227' : '\u22c0';
        }

        @Override
        public boolean test(R object) {
            for (Filter filter : this.operands) {
                if (filter.test(object)) continue;
                return false;
            }
            return true;
        }

        @Override
        public Filter<R> optimize(Optimization optimization) {
            return this.optimize(optimization, Filter.include(), Filter.exclude());
        }
    }
}

