/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.geometry.wrapper.jts;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import org.apache.sis.geometry.wrapper.j2d.EmptyShape;
import org.apache.sis.geometry.wrapper.jts.Factory;
import org.apache.sis.geometry.wrapper.jts.PathIteratorAdapter;
import org.apache.sis.referencing.util.j2d.AbstractShape;
import org.apache.sis.referencing.util.j2d.IntervalRectangle;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.Point;

final class ShapeAdapter
extends AbstractShape
implements Serializable {
    private static final long serialVersionUID = -8536828815289601141L;
    private static final GeometryFactory SMALL_FACTORY = new GeometryFactory();
    protected final Geometry geometry;

    protected ShapeAdapter(Geometry geometry) {
        this.geometry = geometry;
    }

    protected boolean isFloat() {
        CoordinateSequence cs;
        if (this.geometry instanceof Point) {
            cs = ((Point)this.geometry).getCoordinateSequence();
        } else if (this.geometry instanceof LineString) {
            cs = ((LineString)this.geometry).getCoordinateSequence();
        } else {
            return super.isFloat();
        }
        return Factory.isFloat(cs);
    }

    public Rectangle getBounds() {
        return this.getBounds2D().getBounds();
    }

    public Rectangle2D getBounds2D() {
        Envelope e = this.geometry.getEnvelopeInternal();
        return new IntervalRectangle(e.getMinX(), e.getMinY(), e.getMaxX(), e.getMaxY());
    }

    public boolean contains(Point2D p) {
        return this.contains(p.getX(), p.getY());
    }

    public boolean contains(double x, double y) {
        return this.geometry.contains((Geometry)SMALL_FACTORY.createPoint(new Coordinate(x, y)));
    }

    public boolean contains(Rectangle2D r) {
        return this.geometry.contains(ShapeAdapter.createRect(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY()));
    }

    public boolean contains(double x, double y, double width, double height) {
        return this.geometry.contains(ShapeAdapter.createRect(x, y, x + width, y + height));
    }

    public boolean intersects(Rectangle2D r) {
        return this.geometry.intersects(ShapeAdapter.createRect(r.getMinX(), r.getMinY(), r.getMaxX(), r.getMaxY()));
    }

    public boolean intersects(double x, double y, double width, double height) {
        return this.geometry.intersects(ShapeAdapter.createRect(x, y, x + width, y + height));
    }

    private static Geometry createRect(double xmin, double ymin, double xmax, double ymax) {
        Coordinate origin = new Coordinate(xmin, ymin);
        LinearRing ring = SMALL_FACTORY.createLinearRing(new Coordinate[]{origin, new Coordinate(xmin, ymax), new Coordinate(xmax, ymax), new Coordinate(xmax, ymin), origin});
        return SMALL_FACTORY.createPolygon(ring);
    }

    public PathIterator getPathIterator(AffineTransform at, double flatness) {
        return this.getPathIterator(at);
    }

    public PathIterator getPathIterator(AffineTransform at) {
        if (this.geometry.isEmpty()) {
            return EmptyShape.INSTANCE;
        }
        return new PathIteratorAdapter(this.geometry, at);
    }
}

