/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.function.ProjectionTransformer;
import org.apache.baremaps.openstreetmap.model.Element;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.locationtech.jts.geom.Geometry;

public class EntityProjectionTransformer
implements Consumer<Entity> {
    private final int sourceSrid;
    private final int targetSrid;
    private final ProjectionTransformer projectionTransformer;

    public EntityProjectionTransformer(int sourceSrid, int targetSrid) {
        this.sourceSrid = sourceSrid;
        this.targetSrid = targetSrid;
        this.projectionTransformer = new ProjectionTransformer(sourceSrid, targetSrid);
    }

    @Override
    public void accept(Entity entity) {
        Element element;
        if (this.sourceSrid != this.targetSrid && entity instanceof Element && (element = (Element)entity).getGeometry() != null) {
            Geometry geometry = this.projectionTransformer.transform(element.getGeometry());
            element.setGeometry(geometry);
        }
    }
}

