/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Member;
import org.apache.baremaps.openstreetmap.model.Relation;
import org.apache.baremaps.openstreetmap.utils.GeometryUtils;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.prep.PreparedGeometry;
import org.locationtech.jts.geom.prep.PreparedGeometryFactory;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.locationtech.jts.geom.util.PolygonExtracter;
import org.locationtech.jts.operation.linemerge.LineMerger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RelationMultiPolygonBuilder
implements Consumer<Entity> {
    private static final Logger logger = LoggerFactory.getLogger(RelationMultiPolygonBuilder.class);
    private final Map<Long, Coordinate> coordinateMap;
    private final Map<Long, List<Long>> referenceMap;

    public RelationMultiPolygonBuilder(Map<Long, Coordinate> coordinateMap, Map<Long, List<Long>> referenceMap) {
        this.coordinateMap = coordinateMap;
        this.referenceMap = referenceMap;
    }

    @Override
    public void accept(Entity entity) {
        if (entity instanceof Relation) {
            Relation relation = (Relation)entity;
            try {
                long start = System.currentTimeMillis();
                this.buildMultiPolygon(relation);
                long end = System.currentTimeMillis();
                long duration = end - start;
                if (duration > 60000L) {
                    logger.debug("Relation #{} processed in {} ms", (Object)relation.getId(), (Object)duration);
                }
            }
            catch (Exception e) {
                logger.debug("Unable to build the geometry for relation #" + relation.getId(), (Throwable)e);
                MultiPolygon emptyMultiPolygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createMultiPolygon();
                relation.setGeometry((Geometry)emptyMultiPolygon);
            }
        }
    }

    private void buildMultiPolygon(Relation relation) {
        ArrayList<Member> outerMembers = new ArrayList<Member>();
        ArrayList<Member> innerMembers = new ArrayList<Member>();
        ArrayList<Member> otherMembers = new ArrayList<Member>();
        block8: for (Member member : relation.getMembers()) {
            if (!Member.MemberType.WAY.equals((Object)member.type())) continue;
            switch (member.role()) {
                case "outer": {
                    outerMembers.add(member);
                    continue block8;
                }
                case "inner": {
                    innerMembers.add(member);
                    continue block8;
                }
            }
            otherMembers.add(member);
        }
        List<Polygon> outerPolygons = this.createPolygons(outerMembers);
        List<Polygon> innerPolygons = this.createPolygons(innerMembers);
        innerPolygons = this.combinePolygons(innerPolygons);
        List<Polygon> otherPolygons = this.createPolygons(otherMembers);
        otherPolygons = this.combinePolygons(otherPolygons);
        for (Polygon polygon : otherPolygons) {
            for (Polygon outerPolygon : outerPolygons) {
                if (!outerPolygon.contains((Geometry)polygon)) continue;
                innerPolygons.add(polygon);
            }
            if (innerPolygons.contains(polygon)) continue;
            outerPolygons.add(polygon);
        }
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        for (Polygon outerPolygon : outerPolygons) {
            LinearRing shell = outerPolygon.getExteriorRing();
            ArrayList<LinearRing> holes = new ArrayList<LinearRing>();
            for (int i = 0; i < outerPolygon.getNumInteriorRing(); ++i) {
                holes.add(outerPolygon.getInteriorRingN(i));
            }
            PreparedGeometry preparedOuterPolygon = PreparedGeometryFactory.prepare((Geometry)outerPolygon);
            for (Polygon innerPolygon : innerPolygons) {
                if (!preparedOuterPolygon.contains((Geometry)innerPolygon)) continue;
                holes.add(innerPolygon.getExteriorRing());
                for (int i = 0; i < innerPolygon.getNumInteriorRing(); ++i) {
                    Polygon innerPolygonHole = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(innerPolygon.getInteriorRingN(i));
                    this.repairPolygon(innerPolygonHole, polygons);
                }
            }
            Polygon polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(shell, holes.toArray(new LinearRing[0]));
            this.repairPolygon(polygon, polygons);
        }
        if (!polygons.isEmpty()) {
            MultiPolygon multiPolygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createMultiPolygon(polygons.toArray(new Polygon[0]));
            relation.setGeometry((Geometry)multiPolygon);
        } else {
            MultiPolygon multiPolygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createMultiPolygon();
            relation.setGeometry((Geometry)multiPolygon);
        }
    }

    private List<Polygon> createPolygons(List<Member> members) {
        Polygon polygon;
        LineString lineString;
        ArrayList<Polygon> polygons = new ArrayList<Polygon>();
        LineMerger lineMerger = new LineMerger();
        for (Member member : members) {
            lineString = this.createLineString(member);
            if (lineString.isClosed()) {
                polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(lineString.getCoordinateSequence());
                this.repairPolygon(polygon, polygons);
                continue;
            }
            lineMerger.add((Geometry)lineString);
        }
        for (Member geometry : lineMerger.getMergedLineStrings()) {
            if (!(geometry instanceof LineString) || !(lineString = (LineString)geometry).isClosed()) continue;
            polygon = GeometryUtils.GEOMETRY_FACTORY_WGS84.createPolygon(lineString.getCoordinates());
            this.repairPolygon(polygon, polygons);
        }
        return polygons;
    }

    private LineString createLineString(Member member) {
        List<Long> refs = this.referenceMap.get(member.ref());
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        Coordinate previous = null;
        for (Long id : refs) {
            Coordinate coordinate = this.coordinateMap.get(id);
            if (coordinate == null || coordinate.equals(previous)) continue;
            list.add(coordinate);
            previous = coordinate;
        }
        Coordinate[] array = list.toArray(new Coordinate[0]);
        return GeometryUtils.GEOMETRY_FACTORY_WGS84.createLineString(array);
    }

    private List<Polygon> combinePolygons(List<Polygon> polygons) {
        Geometry geometry = GeometryUtils.GEOMETRY_FACTORY_WGS84.createEmpty(0);
        for (Polygon polygon : polygons) {
            geometry = geometry.symDifference((Geometry)polygon);
        }
        ArrayList<Polygon> combinedPolygons = new ArrayList<Polygon>();
        PolygonExtracter.getPolygons((Geometry)geometry, combinedPolygons);
        return combinedPolygons;
    }

    private void repairPolygon(Polygon polygon, List<Polygon> accumulator) {
        if (polygon.isValid()) {
            accumulator.add(polygon);
        } else {
            GeometryFixer geometryFixer = new GeometryFixer((Geometry)polygon);
            Geometry fixedGeometry = geometryFixer.getResult();
            if (fixedGeometry instanceof Polygon) {
                Polygon fixedPolygon = (Polygon)fixedGeometry;
                accumulator.add(fixedPolygon);
            } else if (fixedGeometry instanceof MultiPolygon) {
                MultiPolygon fixedMultiPolygon = (MultiPolygon)fixedGeometry;
                PolygonExtracter.getPolygons((Geometry)fixedMultiPolygon, accumulator);
            }
        }
    }
}

