/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.function;

import java.util.ArrayList;
import java.util.Map;
import java.util.function.Consumer;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.Way;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.PrecisionModel;
import org.locationtech.jts.geom.util.GeometryFixer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WayGeometryBuilder
implements Consumer<Entity> {
    private static final Logger logger = LoggerFactory.getLogger(WayGeometryBuilder.class);
    private final GeometryFactory geometryFactory = new GeometryFactory(new PrecisionModel(), 4326);
    private final Map<Long, Coordinate> coordinateMap;

    public WayGeometryBuilder(Map<Long, Coordinate> coordinateMap) {
        this.coordinateMap = coordinateMap;
    }

    @Override
    public void accept(Entity entity) {
        if (entity instanceof Way) {
            Way way = (Way)entity;
            try {
                ArrayList<Coordinate> list = new ArrayList<Coordinate>();
                Coordinate previous = null;
                for (Long id : way.getNodes()) {
                    Coordinate coordinate = this.coordinateMap.get(id);
                    if (coordinate == null || coordinate.equals(previous)) continue;
                    list.add(coordinate);
                    previous = coordinate;
                }
                Coordinate[] array = list.toArray(new Coordinate[0]);
                LineString line = this.geometryFactory.createLineString(array);
                if (!line.isEmpty()) {
                    if (!line.isClosed() || way.getTags().containsKey("railway") || way.getTags().containsKey("highway") || way.getTags().containsKey("barrier")) {
                        way.setGeometry((Geometry)line);
                    } else {
                        Polygon polygon = this.geometryFactory.createPolygon(line.getCoordinates());
                        if (polygon.isValid()) {
                            way.setGeometry((Geometry)polygon);
                        } else {
                            GeometryFixer geometryFixer = new GeometryFixer((Geometry)polygon);
                            Geometry fixedGeometry = geometryFixer.getResult();
                            way.setGeometry(fixedGeometry);
                        }
                    }
                }
            }
            catch (Exception e) {
                logger.debug("Unable to build the geometry for way #" + way.getId(), (Throwable)e);
                way.setGeometry(this.geometryFactory.createEmpty(0));
            }
        }
    }
}

