/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.pbf;

import java.io.InputStream;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import org.apache.baremaps.openstreetmap.model.DataBlock;
import org.apache.baremaps.openstreetmap.model.Entity;
import org.apache.baremaps.openstreetmap.model.HeaderBlock;
import org.apache.baremaps.openstreetmap.pbf.PbfBlockReader;
import org.apache.baremaps.openstreetmap.pbf.PbfReader;
import org.apache.baremaps.openstreetmap.stream.StreamException;
import org.locationtech.jts.geom.Coordinate;

public class PbfEntityReader
implements PbfReader<Entity> {
    private final PbfBlockReader reader = new PbfBlockReader();

    @Override
    public int getBuffer() {
        return this.reader.getBuffer();
    }

    public PbfEntityReader setBuffer(int buffer) {
        this.reader.setBuffer(buffer);
        return this;
    }

    @Override
    public boolean getGeometries() {
        return this.reader.getGeometries();
    }

    public PbfEntityReader setGeometries(boolean geometries) {
        this.reader.setGeometries(geometries);
        return this;
    }

    @Override
    public int getSrid() {
        return this.reader.getSrid();
    }

    public PbfEntityReader setSrid(int srid) {
        this.reader.setSrid(srid);
        return this;
    }

    @Override
    public Map<Long, Coordinate> getCoordinateMap() {
        return this.reader.getCoordinateMap();
    }

    public PbfEntityReader setCoordinateMap(Map<Long, Coordinate> coordinateMap) {
        this.reader.setCoordinateMap((Map)coordinateMap);
        return this;
    }

    @Override
    public Map<Long, List<Long>> getReferenceMap() {
        return this.reader.getReferenceMap();
    }

    public PbfEntityReader setReferenceMap(Map<Long, List<Long>> referenceMap) {
        this.reader.setReferenceMap((Map)referenceMap);
        return this;
    }

    @Override
    public Stream<Entity> read(InputStream inputStream) {
        return this.reader.read(inputStream).flatMap(block -> {
            try {
                Stream.Builder<Record> entities = Stream.builder();
                if (block instanceof HeaderBlock) {
                    HeaderBlock headerBlock = (HeaderBlock)block;
                    entities.add(headerBlock.getHeader());
                    entities.add(headerBlock.getBound());
                } else if (block instanceof DataBlock) {
                    DataBlock dataBlock = (DataBlock)block;
                    dataBlock.getDenseNodes().forEach(entities::add);
                    dataBlock.getNodes().forEach(entities::add);
                    dataBlock.getWays().forEach(entities::add);
                    dataBlock.getRelations().forEach(entities::add);
                } else {
                    throw new StreamException("Unknown block type.");
                }
                return entities.build();
            }
            catch (Exception e) {
                throw new StreamException(e);
            }
        });
    }
}

