/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.openstreetmap.stream;

import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;

@FunctionalInterface
public interface ThrowingFunction<T, R, E extends Exception> {
    public R apply(T var1) throws E;

    public static <T, R> Function<T, Optional<R>> optional(ThrowingFunction<? super T, ? extends R, ?> throwingFunction) {
        Objects.requireNonNull(throwingFunction);
        return t -> {
            try {
                return Optional.ofNullable(throwingFunction.apply(t));
            }
            catch (Exception e) {
                return Optional.empty();
            }
        };
    }

    public static <T, R> Function<T, R> unchecked(ThrowingFunction<? super T, ? extends R, ?> throwingFunction) {
        Objects.requireNonNull(throwingFunction);
        return t -> {
            try {
                return throwingFunction.apply(t);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }
}

