/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.pmtiles;

import com.google.common.io.LittleEndianDataInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.List;
import org.apache.baremaps.pmtiles.Entry;
import org.apache.baremaps.pmtiles.Header;
import org.apache.baremaps.pmtiles.PMTilesUtils;

public class PMTilesReader {
    private final Path path;
    private Header header;
    private List<Entry> rootEntries;

    public PMTilesReader(Path path) {
        this.path = path;
    }

    public Header getHeader() throws IOException {
        if (this.header == null) {
            try (LittleEndianDataInputStream inputStream = new LittleEndianDataInputStream(Files.newInputStream(this.path, new OpenOption[0]));){
                this.header = PMTilesUtils.deserializeHeader((InputStream)inputStream);
            }
        }
        return this.header;
    }

    public List<Entry> getRootDirectory() throws IOException {
        if (this.rootEntries == null) {
            Header header = this.getHeader();
            this.rootEntries = this.getDirectory(header.getRootDirectoryOffset());
        }
        return this.rootEntries;
    }

    public List<Entry> getDirectory(long offset) throws IOException {
        Header header = this.getHeader();
        try (InputStream input = Files.newInputStream(this.path, new OpenOption[0]);){
            List<Entry> list;
            for (long skipped = 0L; skipped < offset; skipped += input.skip(offset - skipped)) {
            }
            try (LittleEndianDataInputStream decompressed = new LittleEndianDataInputStream(header.getInternalCompression().decompress(input));){
                list = PMTilesUtils.deserializeEntries((InputStream)decompressed);
            }
            return list;
        }
    }

    public ByteBuffer getTile(int z, long x, long y) throws IOException {
        long tileId = PMTilesUtils.zxyToTileId(z, x, y);
        Header fileHeader = this.getHeader();
        List<Entry> entries = this.getRootDirectory();
        Entry entry = PMTilesUtils.findTile(entries, tileId);
        if (entry == null) {
            return null;
        }
        try (FileChannel channel = FileChannel.open(this.path, new OpenOption[0]);){
            ByteBuffer byteBuffer;
            ByteBuffer compressed = ByteBuffer.allocate((int)entry.getLength());
            channel.position(fileHeader.getTileDataOffset() + entry.getOffset());
            channel.read(compressed);
            compressed.flip();
            try (ByteArrayInputStream tile = new ByteArrayInputStream(compressed.array());){
                byteBuffer = ByteBuffer.wrap(tile.readAllBytes());
            }
            return byteBuffer;
        }
    }
}

