/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import org.apache.sis.util.Classes;
import org.apache.sis.util.resources.Errors;

final class CacheKey {
    final Class<?> type;
    final Class<?> propertyType;

    CacheKey(Class<?> type) {
        this.type = type;
        this.propertyType = Object.class;
    }

    CacheKey(Class<?> type, Class<?> propertyType) {
        this.type = type;
        this.propertyType = propertyType != null ? propertyType : Object.class;
    }

    final boolean isValid() {
        return this.type != null && this.propertyType.isAssignableFrom(this.type);
    }

    public int hashCode() {
        int code = this.propertyType.hashCode();
        if (this.type != null) {
            code += 31 * this.type.hashCode();
        }
        return code;
    }

    public boolean equals(Object obj) {
        if (obj instanceof CacheKey) {
            CacheKey other = (CacheKey)obj;
            return this.type == other.type && this.propertyType == other.propertyType;
        }
        return false;
    }

    public String toString() {
        Object name = Classes.getShortName(this.type);
        if (this.propertyType != Object.class) {
            name = (String)name + " as " + Classes.getShortName(this.propertyType);
        }
        return name;
    }

    final String unrecognized() {
        return Errors.format((short)149, this.type);
    }

    final String invalid() {
        return Errors.format((short)43, (Object)"type", this.propertyType, this.type);
    }
}

