/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.List;
import java.util.function.Predicate;
import org.apache.sis.metadata.MetadataFormat;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.TreeNode;
import org.apache.sis.metadata.ValueExistencePolicy;
import org.apache.sis.system.Semaphores;
import org.apache.sis.util.collection.TableColumn;
import org.apache.sis.util.collection.TreeTable;
import org.apache.sis.util.internal.TreeFormatCustomization;
import org.apache.sis.util.internal.UnmodifiableArrayList;
import org.apache.sis.xml.bind.NonMarshalledAuthority;
import org.apache.sis.xml.bind.SpecializedIdentifier;
import org.opengis.metadata.citation.Citation;

final class TreeTableView
implements TreeTable,
TreeFormatCustomization,
Serializable {
    private static final long serialVersionUID = 3911016927808764394L;
    static final List<TableColumn<?>> COLUMNS = UnmodifiableArrayList.wrap((Object[])new TableColumn[]{TableColumn.IDENTIFIER, TableColumn.INDEX, TableColumn.NAME, TableColumn.TYPE, TableColumn.VALUE, TableColumn.REMARKS});
    private transient TreeNode root;
    final MetadataStandard standard;
    final ValueExistencePolicy valuePolicy;

    TreeTableView(MetadataStandard standard, Object metadata, Class<?> baseType, ValueExistencePolicy valuePolicy) {
        this.standard = standard;
        this.valuePolicy = valuePolicy;
        this.root = new TreeNode(this, metadata, baseType);
    }

    public List<TableColumn<?>> getColumns() {
        return COLUMNS;
    }

    public TreeTable.Node getRoot() {
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String toString() {
        boolean allowNull = Semaphores.queryAndSet((int)1);
        try {
            MetadataFormat metadataFormat = MetadataFormat.INSTANCE;
            synchronized (metadataFormat) {
                String string = MetadataFormat.INSTANCE.format(this);
                return string;
            }
        }
        finally {
            Semaphores.clear((int)1, (boolean)allowNull);
        }
    }

    public Predicate<TreeTable.Node> filter() {
        return TreeTableView::filter;
    }

    private static boolean filter(TreeTable.Node node) {
        TreeTable.Node parent = node.getParent();
        if (parent instanceof TreeNode && Citation.class.isAssignableFrom(((TreeNode)parent).baseType)) {
            Citation authority;
            Object value = null;
            if (node instanceof TreeNode) {
                value = ((TreeNode)node).cachedValue;
            }
            if (value == null) {
                value = node.getUserObject();
            }
            if (value instanceof SpecializedIdentifier && (authority = ((SpecializedIdentifier)value).getAuthority()) instanceof NonMarshalledAuthority && ((NonMarshalledAuthority)authority).isBookOrSerialNumber()) {
                return false;
            }
        }
        return true;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.root.baseType);
        out.writeObject(this.root.metadata);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        Class baseType = (Class)in.readObject();
        this.root = new TreeNode(this, in.readObject(), baseType);
    }
}

