/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.metadata.iso;

import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import java.net.URI;
import java.net.URISyntaxException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.sis.converter.SurjectiveConverter;
import org.apache.sis.math.FunctionProperty;
import org.apache.sis.metadata.MetadataCopier;
import org.apache.sis.metadata.MetadataStandard;
import org.apache.sis.metadata.internal.Dependencies;
import org.apache.sis.metadata.internal.ImplementationHelper;
import org.apache.sis.metadata.iso.DefaultIdentifier;
import org.apache.sis.metadata.iso.DefaultMetadataScope;
import org.apache.sis.metadata.iso.ISOMetadata;
import org.apache.sis.metadata.iso.MetadataScopeAdapter;
import org.apache.sis.metadata.iso.citation.DefaultCitation;
import org.apache.sis.metadata.iso.citation.DefaultCitationDate;
import org.apache.sis.metadata.iso.citation.DefaultOnlineResource;
import org.apache.sis.metadata.iso.identification.AbstractIdentification;
import org.apache.sis.metadata.iso.identification.DefaultDataIdentification;
import org.apache.sis.metadata.iso.legacy.LegacyPropertyAdapter;
import org.apache.sis.util.Emptiable;
import org.apache.sis.util.ObjectConverter;
import org.apache.sis.util.SimpleInternationalString;
import org.apache.sis.util.collection.Containers;
import org.apache.sis.util.internal.CollectionsExt;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.bind.FilterByVersion;
import org.apache.sis.xml.bind.gmi.MI_Metadata;
import org.apache.sis.xml.bind.lan.LocaleAdapter;
import org.apache.sis.xml.bind.lan.LocaleAndCharset;
import org.apache.sis.xml.bind.lan.OtherLocales;
import org.apache.sis.xml.bind.lan.PT_Locale;
import org.apache.sis.xml.bind.metadata.CI_Citation;
import org.apache.sis.xml.bind.metadata.MD_Identifier;
import org.apache.sis.xml.bind.metadata.code.MD_CharacterSetCode;
import org.opengis.annotation.Obligation;
import org.opengis.annotation.Specification;
import org.opengis.annotation.UML;
import org.opengis.metadata.ApplicationSchemaInformation;
import org.opengis.metadata.Identifier;
import org.opengis.metadata.Metadata;
import org.opengis.metadata.MetadataExtensionInformation;
import org.opengis.metadata.PortrayalCatalogueReference;
import org.opengis.metadata.acquisition.AcquisitionInformation;
import org.opengis.metadata.citation.Citation;
import org.opengis.metadata.citation.CitationDate;
import org.opengis.metadata.citation.DateType;
import org.opengis.metadata.citation.OnlineResource;
import org.opengis.metadata.citation.ResponsibleParty;
import org.opengis.metadata.constraint.Constraints;
import org.opengis.metadata.content.ContentInformation;
import org.opengis.metadata.distribution.Distribution;
import org.opengis.metadata.identification.CharacterSet;
import org.opengis.metadata.identification.Identification;
import org.opengis.metadata.lineage.Lineage;
import org.opengis.metadata.maintenance.MaintenanceInformation;
import org.opengis.metadata.maintenance.ScopeCode;
import org.opengis.metadata.quality.DataQuality;
import org.opengis.metadata.spatial.SpatialRepresentation;
import org.opengis.referencing.ReferenceSystem;
import org.opengis.util.InternationalString;

@XmlType(name="MD_Metadata_Type", propOrder={"metadataIdentifier", "defaultLocale", "parentMetadata", "fileIdentifier", "language", "charset", "parentIdentifier", "hierarchyLevels", "hierarchyLevelNames", "contacts", "dates", "metadataStandard", "metadataProfile", "alternativeMetadataReference", "otherLocales", "metadataLinkage", "dateStamp", "metadataStandardName", "metadataStandardVersion", "dataSetUri", "locales", "spatialRepresentationInfo", "referenceSystemInfo", "metadataExtensionInfo", "identificationInfo", "contentInfo", "distributionInfo", "dataQualityInfo", "portrayalCatalogueInfo", "metadataConstraints", "applicationSchemaInfo", "metadataMaintenance", "resourceLineage", "metadataScope", "acquisitionInformation"})
@XmlRootElement(name="MD_Metadata")
@XmlSeeAlso(value={MI_Metadata.class})
public class DefaultMetadata
extends ISOMetadata
implements Metadata {
    private static final long serialVersionUID = -76483485174667242L;
    private Map<Locale, Charset> locales;
    private Citation parentMetadata;
    private Collection<DefaultMetadataScope> metadataScopes;
    private Collection<ResponsibleParty> contacts;
    private Collection<CitationDate> dateInfo;
    private Collection<Citation> metadataStandards;
    private Collection<Citation> metadataProfiles;
    private Collection<Citation> alternativeMetadataReferences;
    private Collection<OnlineResource> metadataLinkages;
    private Collection<SpatialRepresentation> spatialRepresentationInfo;
    private Collection<ReferenceSystem> referenceSystemInfo;
    private Collection<MetadataExtensionInformation> metadataExtensionInfo;
    private Collection<Identification> identificationInfo;
    private Collection<ContentInformation> contentInfo;
    private Distribution distributionInfo;
    private Collection<DataQuality> dataQualityInfo;
    private Collection<PortrayalCatalogueReference> portrayalCatalogueInfo;
    private Collection<Constraints> metadataConstraints;
    private Collection<ApplicationSchemaInformation> applicationSchemaInfo;
    private MaintenanceInformation metadataMaintenance;
    private Collection<AcquisitionInformation> acquisitionInformation;
    private Collection<Lineage> resourceLineages;

    public DefaultMetadata() {
    }

    public DefaultMetadata(ResponsibleParty contact, Date dateStamp, Identification identificationInfo) {
        this.contacts = this.singleton(contact, ResponsibleParty.class);
        this.identificationInfo = this.singleton(identificationInfo, Identification.class);
        if (dateStamp != null) {
            this.dateInfo = this.singleton(new DefaultCitationDate(dateStamp, DateType.CREATION), CitationDate.class);
        }
    }

    public DefaultMetadata(Metadata object) {
        super(object);
        if (object != null) {
            this.contacts = this.copyCollection(object.getContacts(), ResponsibleParty.class);
            this.spatialRepresentationInfo = this.copyCollection(object.getSpatialRepresentationInfo(), SpatialRepresentation.class);
            this.referenceSystemInfo = this.copyCollection(object.getReferenceSystemInfo(), ReferenceSystem.class);
            this.metadataExtensionInfo = this.copyCollection(object.getMetadataExtensionInfo(), MetadataExtensionInformation.class);
            this.identificationInfo = this.copyCollection(object.getIdentificationInfo(), Identification.class);
            this.contentInfo = this.copyCollection(object.getContentInfo(), ContentInformation.class);
            this.distributionInfo = object.getDistributionInfo();
            this.dataQualityInfo = this.copyCollection(object.getDataQualityInfo(), DataQuality.class);
            this.portrayalCatalogueInfo = this.copyCollection(object.getPortrayalCatalogueInfo(), PortrayalCatalogueReference.class);
            this.metadataConstraints = this.copyCollection(object.getMetadataConstraints(), Constraints.class);
            this.applicationSchemaInfo = this.copyCollection(object.getApplicationSchemaInfo(), ApplicationSchemaInformation.class);
            this.metadataMaintenance = object.getMetadataMaintenance();
            this.acquisitionInformation = this.copyCollection(object.getAcquisitionInformation(), AcquisitionInformation.class);
            if (object instanceof DefaultMetadata) {
                DefaultMetadata c = (DefaultMetadata)object;
                this.identifiers = this.singleton(c.getMetadataIdentifier(), Identifier.class);
                this.parentMetadata = c.getParentMetadata();
                this.locales = this.copyMap(c.getLocalesAndCharsets(), Locale.class);
                this.metadataScopes = this.copyCollection(c.getMetadataScopes(), DefaultMetadataScope.class);
                this.dateInfo = this.copyCollection(c.getDateInfo(), CitationDate.class);
                this.metadataStandards = this.copyCollection(c.getMetadataStandards(), Citation.class);
                this.metadataProfiles = this.copyCollection(c.getMetadataProfiles(), Citation.class);
                this.alternativeMetadataReferences = this.copyCollection(c.getAlternativeMetadataReferences(), Citation.class);
                this.metadataLinkages = this.copyCollection(c.getMetadataLinkages(), OnlineResource.class);
                this.resourceLineages = this.copyCollection(c.getResourceLineages(), Lineage.class);
            } else {
                this.setFileIdentifier(object.getFileIdentifier());
                this.setParentIdentifier(object.getParentIdentifier());
                this.setLanguage(object.getLanguage());
                this.setLocales(object.getLocales());
                this.setCharacterSet(object.getCharacterSet());
                this.setHierarchyLevels(object.getHierarchyLevels());
                this.setHierarchyLevelNames(object.getHierarchyLevelNames());
                this.setDateStamp(object.getDateStamp());
                this.setMetadataStandardName(object.getMetadataStandardName());
                this.setMetadataStandardVersion(object.getMetadataStandardVersion());
                try {
                    this.setDataSetUri(object.getDataSetUri());
                }
                catch (URISyntaxException e) {
                    throw new IllegalArgumentException(e);
                }
            }
        }
    }

    public static DefaultMetadata castOrCopy(Metadata object) {
        if (object == null || object instanceof DefaultMetadata) {
            return (DefaultMetadata)object;
        }
        return new DefaultMetadata(object);
    }

    public static DefaultMetadata deepCopy(Metadata object) {
        if (object == null) {
            return null;
        }
        return (DefaultMetadata)new MetadataCopier(MetadataStandard.ISO_19115).copy(Metadata.class, object);
    }

    @XmlElement(name="metadataIdentifier")
    @XmlJavaTypeAdapter(value=MD_Identifier.Since2014.class)
    @UML(identifier="metadataIdentifier", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Identifier getMetadataIdentifier() {
        return super.getIdentifier();
    }

    public void setMetadataIdentifier(Identifier newValue) {
        super.setIdentifier(newValue);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMetadataIdentifier"})
    @XmlElement(name="fileIdentifier", namespace="http://www.isotc211.org/2005/gmd")
    public String getFileIdentifier() {
        Identifier identifier;
        if (FilterByVersion.LEGACY_METADATA.accept() && (identifier = this.getMetadataIdentifier()) != null) {
            return identifier.getCode();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setFileIdentifier(String newValue) {
        DefaultIdentifier identifier = DefaultIdentifier.castOrCopy(super.getIdentifier());
        if (identifier == null) {
            if (newValue == null) {
                return;
            }
            identifier = new DefaultIdentifier();
        }
        identifier.setCode(newValue);
        if (newValue == null && identifier instanceof Emptiable && identifier.isEmpty()) {
            identifier = null;
        }
        this.setMetadataIdentifier(identifier);
    }

    @UML(identifier="defaultLocale+otherLocale", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Map<Locale, Charset> getLocalesAndCharsets() {
        this.locales = this.nonNullMap(this.locales, Locale.class);
        return this.locales;
    }

    public void setLocalesAndCharsets(Map<? extends Locale, ? extends Charset> newValues) {
        this.locales = this.writeMap(newValues, this.locales, Locale.class);
    }

    @Deprecated(since="1.0", forRemoval=true)
    @Dependencies(value={"getLocalesAndCharsets"})
    public Collection<Locale> getLanguages() {
        return FilterByVersion.LEGACY_METADATA.accept() ? LocaleAndCharset.getLanguages(this.getLocalesAndCharsets()) : null;
    }

    @Deprecated(since="1.0", forRemoval=true)
    public void setLanguages(Collection<Locale> newValues) {
        this.setLocalesAndCharsets(LocaleAndCharset.setLanguages(this.getLocalesAndCharsets(), newValues));
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="language", namespace="http://www.isotc211.org/2005/gmd")
    public Locale getLanguage() {
        return FilterByVersion.LEGACY_METADATA.accept() ? (Locale)CollectionsExt.first(this.getLanguages()) : null;
    }

    @Deprecated(since="1.0")
    public void setLanguage(Locale newValue) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, new PT_Locale(newValue)));
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    @XmlElement(name="locale", namespace="http://www.isotc211.org/2005/gmd")
    @XmlJavaTypeAdapter(value=LocaleAdapter.Wrapped.class)
    public Collection<Locale> getLocales() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            Set<PT_Locale> locales = OtherLocales.filter(this.getLocalesAndCharsets());
            return Containers.derivedSet(locales, (ObjectConverter)ToLocale.INSTANCE);
        }
        return null;
    }

    @Deprecated
    public void setLocales(Collection<? extends Locale> newValues) {
        Collection<Locale> legacy = this.getLocales();
        if (legacy != null) {
            legacy.addAll(newValues);
        } else if (!newValues.isEmpty()) {
            LinkedHashMap<Locale, Object> locales = new LinkedHashMap<Locale, Object>();
            for (Locale locale : newValues) {
                locales.put(locale, null);
            }
            this.setLocalesAndCharsets(locales);
        }
    }

    @Deprecated(since="1.0", forRemoval=true)
    @Dependencies(value={"getLocalesAndCharsets"})
    public Collection<Charset> getCharacterSets() {
        return LocaleAndCharset.getCharacterSets(this.getLocalesAndCharsets());
    }

    @Deprecated(since="1.0", forRemoval=true)
    public void setCharacterSets(Collection<? extends Charset> newValues) {
        this.setLocalesAndCharsets(LocaleAndCharset.setCharacterSets(this.getLocalesAndCharsets(), newValues));
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getLocalesAndCharsets"})
    public CharacterSet getCharacterSet() {
        return MD_CharacterSetCode.fromCharset(LegacyPropertyAdapter.getSingleton(this.getCharacterSets(), Charset.class, null, DefaultMetadata.class, "getCharacterSet"));
    }

    @Deprecated(since="1.0")
    public void setCharacterSet(CharacterSet newValue) {
        this.setCharacterSets(CollectionsExt.singletonOrEmpty((Object)(newValue != null ? newValue.toCharset() : null)));
    }

    @XmlElement(name="parentMetadata")
    @XmlJavaTypeAdapter(value=CI_Citation.Since2014.class)
    @UML(identifier="parentMetadata", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Citation getParentMetadata() {
        return this.parentMetadata;
    }

    public void setParentMetadata(Citation newValue) {
        this.checkWritePermission(this.parentMetadata);
        this.parentMetadata = newValue;
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getParentMetadata"})
    @XmlElement(name="parentIdentifier", namespace="http://www.isotc211.org/2005/gmd")
    public String getParentIdentifier() {
        InternationalString title;
        Citation parentMetadata;
        if (FilterByVersion.LEGACY_METADATA.accept() && (parentMetadata = this.getParentMetadata()) != null && (title = parentMetadata.getTitle()) != null) {
            return title.toString();
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setParentIdentifier(String newValue) {
        this.checkWritePermission(this.parentMetadata);
        DefaultCitation parent = DefaultCitation.castOrCopy(this.parentMetadata);
        if (newValue != null) {
            if (parent == null) {
                parent = new DefaultCitation();
            }
            parent.setTitle((InternationalString)new SimpleInternationalString(newValue));
            this.setParentMetadata(parent);
        } else if (parent != null) {
            parent.setTitle(null);
        }
    }

    @UML(identifier="metadataScope", obligation=Obligation.CONDITIONAL, specification=Specification.ISO_19115)
    public Collection<DefaultMetadataScope> getMetadataScopes() {
        this.metadataScopes = this.nonNullCollection(this.metadataScopes, DefaultMetadataScope.class);
        return this.metadataScopes;
    }

    public void setMetadataScopes(Collection<? extends DefaultMetadataScope> newValues) {
        this.metadataScopes = this.writeCollection(newValues, this.metadataScopes, DefaultMetadataScope.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMetadataScopes"})
    @XmlElement(name="hierarchyLevel", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<ScopeCode> getHierarchyLevels() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new MetadataScopeAdapter<ScopeCode>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(ScopeCode value) {
                return new DefaultMetadataScope(value, null);
            }

            @Override
            protected ScopeCode unwrap(DefaultMetadataScope container) {
                return container.getResourceScope();
            }

            @Override
            protected boolean update(DefaultMetadataScope container, ScopeCode value) {
                container.setResourceScope(value);
                return true;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setHierarchyLevels(Collection<? extends ScopeCode> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.metadataScopes));
        ((LegacyPropertyAdapter)this.getHierarchyLevels()).setValues(newValues);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMetadataScopes"})
    @XmlElement(name="hierarchyLevelName", namespace="http://www.isotc211.org/2005/gmd")
    public final Collection<String> getHierarchyLevelNames() {
        if (!FilterByVersion.LEGACY_METADATA.accept()) {
            return null;
        }
        return new MetadataScopeAdapter<String>(this.getMetadataScopes()){

            @Override
            protected DefaultMetadataScope wrap(String value) {
                return new DefaultMetadataScope(null, value);
            }

            @Override
            protected String unwrap(DefaultMetadataScope container) {
                InternationalString name = container.getName();
                return name != null ? name.toString() : null;
            }

            @Override
            protected boolean update(DefaultMetadataScope container, String value) {
                container.setName((InternationalString)(value != null ? new SimpleInternationalString(value) : null));
                return true;
            }
        }.validOrNull();
    }

    @Deprecated(since="1.0")
    public void setHierarchyLevelNames(Collection<? extends String> newValues) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.metadataScopes));
        ((LegacyPropertyAdapter)this.getHierarchyLevelNames()).setValues(newValues);
    }

    @XmlElement(name="contact", required=true)
    public Collection<ResponsibleParty> getContacts() {
        this.contacts = this.nonNullCollection(this.contacts, ResponsibleParty.class);
        return this.contacts;
    }

    public void setContacts(Collection<? extends ResponsibleParty> newValues) {
        this.contacts = this.writeCollection(newValues, this.contacts, ResponsibleParty.class);
    }

    @UML(identifier="dateInfo", obligation=Obligation.MANDATORY, specification=Specification.ISO_19115)
    public Collection<CitationDate> getDateInfo() {
        this.dateInfo = this.nonNullCollection(this.dateInfo, CitationDate.class);
        return this.dateInfo;
    }

    public void setDateInfo(Collection<? extends CitationDate> newValues) {
        this.dateInfo = this.writeCollection(newValues, this.dateInfo, CitationDate.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getDateInfo"})
    @XmlElement(name="dateStamp", namespace="http://www.isotc211.org/2005/gmd")
    public Date getDateStamp() {
        Collection<CitationDate> dates;
        if (FilterByVersion.LEGACY_METADATA.accept() && (dates = this.getDateInfo()) != null) {
            for (CitationDate date : dates) {
                if (!DateType.CREATION.equals((Object)date.getDateType())) continue;
                return date.getDate();
            }
        }
        return null;
    }

    @Deprecated(since="1.0")
    public void setDateStamp(Date newValue) {
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.dateInfo));
        Collection<CitationDate> newValues = this.dateInfo;
        if (newValues == null) {
            if (newValue == null) {
                return;
            }
            newValues = new ArrayList<CitationDate>(1);
        } else {
            Iterator<CitationDate> it = newValues.iterator();
            while (it.hasNext()) {
                CitationDate date = it.next();
                if (!DateType.CREATION.equals((Object)date.getDateType())) continue;
                if (newValue == null) {
                    it.remove();
                    return;
                }
                if (date instanceof DefaultCitationDate) {
                    ((DefaultCitationDate)date).setDate(newValue);
                    return;
                }
                it.remove();
                break;
            }
        }
        newValues.add(new DefaultCitationDate(newValue, DateType.CREATION));
        this.setDateInfo(newValues);
    }

    @UML(identifier="metadataStandard", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataStandards() {
        this.metadataStandards = this.nonNullCollection(this.metadataStandards, Citation.class);
        return this.metadataStandards;
    }

    public void setMetadataStandards(Collection<? extends Citation> newValues) {
        this.metadataStandards = this.writeCollection(newValues, this.metadataStandards, Citation.class);
    }

    @UML(identifier="metadataProfile", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getMetadataProfiles() {
        this.metadataProfiles = this.nonNullCollection(this.metadataProfiles, Citation.class);
        return this.metadataProfiles;
    }

    public void setMetadataProfiles(Collection<? extends Citation> newValues) {
        this.metadataProfiles = this.writeCollection(newValues, this.metadataProfiles, Citation.class);
    }

    @UML(identifier="alternativeMetadataReference", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Citation> getAlternativeMetadataReferences() {
        this.alternativeMetadataReferences = this.nonNullCollection(this.alternativeMetadataReferences, Citation.class);
        return this.alternativeMetadataReferences;
    }

    public void setAlternativeMetadataReferences(Collection<? extends Citation> newValues) {
        this.alternativeMetadataReferences = this.writeCollection(newValues, this.alternativeMetadataReferences, Citation.class);
    }

    private String getMetadataStandard(boolean version) {
        Citation standard;
        if (FilterByVersion.LEGACY_METADATA.accept() && (standard = LegacyPropertyAdapter.getSingleton(this.getMetadataStandards(), Citation.class, null, DefaultMetadata.class, version ? "getMetadataStandardName" : "getMetadataStandardVersion")) != null) {
            InternationalString title;
            InternationalString internationalString = title = version ? standard.getEdition() : standard.getTitle();
            if (title != null) {
                return title.toString();
            }
        }
        return null;
    }

    private void setMetadataStandard(boolean version, String newValue) {
        DefaultCitation citation;
        this.checkWritePermission(ImplementationHelper.valueIfDefined(this.metadataStandards));
        SimpleInternationalString i18n = newValue != null ? new SimpleInternationalString(newValue) : null;
        ArrayList<Citation> newValues = this.metadataStandards != null ? new ArrayList<Citation>(this.metadataStandards) : new ArrayList(1);
        DefaultCitation defaultCitation = citation = newValues.isEmpty() ? null : DefaultCitation.castOrCopy((Citation)newValues.get(0));
        if (citation == null) {
            citation = new DefaultCitation();
        }
        if (version) {
            citation.setEdition((InternationalString)i18n);
        } else {
            citation.setTitle((InternationalString)i18n);
        }
        if (newValues.isEmpty()) {
            newValues.add(citation);
        } else {
            newValues.set(0, citation);
        }
        this.setMetadataStandards(newValues);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMetadataStandards"})
    @XmlElement(name="metadataStandardName", namespace="http://www.isotc211.org/2005/gmd")
    public String getMetadataStandardName() {
        return this.getMetadataStandard(false);
    }

    @Deprecated(since="1.0")
    public void setMetadataStandardName(String newValue) {
        this.setMetadataStandard(false, newValue);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getMetadataStandards"})
    @XmlElement(name="metadataStandardVersion", namespace="http://www.isotc211.org/2005/gmd")
    public String getMetadataStandardVersion() {
        return this.getMetadataStandard(true);
    }

    @Deprecated(since="1.0")
    public void setMetadataStandardVersion(String newValue) {
        this.setMetadataStandard(true, newValue);
    }

    @UML(identifier="metadataLinkage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<OnlineResource> getMetadataLinkages() {
        this.metadataLinkages = this.nonNullCollection(this.metadataLinkages, OnlineResource.class);
        return this.metadataLinkages;
    }

    public void setMetadataLinkages(Collection<? extends OnlineResource> newValues) {
        this.metadataLinkages = this.writeCollection(newValues, this.metadataLinkages, OnlineResource.class);
    }

    @Deprecated(since="1.0")
    @Dependencies(value={"getIdentificationInfo"})
    @XmlElement(name="dataSetURI", namespace="http://www.isotc211.org/2005/gmd")
    public String getDataSetUri() {
        Collection<Identification> info;
        String linkage = null;
        if (FilterByVersion.LEGACY_METADATA.accept() && (info = this.getIdentificationInfo()) != null) {
            block0: for (Identification identification : info) {
                Collection<OnlineResource> onlineResources;
                Citation citation = identification.getCitation();
                if (!(citation instanceof DefaultCitation) || (onlineResources = ((DefaultCitation)citation).getOnlineResources()) == null) continue;
                for (OnlineResource link : onlineResources) {
                    URI uri = link.getLinkage();
                    if (uri == null) continue;
                    if (linkage == null) {
                        linkage = uri.toString();
                        continue;
                    }
                    LegacyPropertyAdapter.warnIgnoredExtraneous(OnlineResource.class, DefaultMetadata.class, "getDataSetUri");
                    continue block0;
                }
            }
        }
        return linkage;
    }

    @Deprecated(since="1.0")
    public void setDataSetUri(String newValue) throws URISyntaxException {
        Collection<OnlineResource> onlineResources;
        DefaultOnlineResource firstOnline;
        DefaultCitation citation;
        URI uri = newValue != null ? new URI(newValue) : null;
        Collection<Identification> info = this.identificationInfo;
        this.checkWritePermission(ImplementationHelper.valueIfDefined(info));
        AbstractIdentification firstId = AbstractIdentification.castOrCopy((Identification)CollectionsExt.first(info));
        if (firstId == null) {
            if (uri == null) {
                return;
            }
            firstId = new DefaultDataIdentification();
        }
        if ((citation = DefaultCitation.castOrCopy(firstId.getCitation())) == null) {
            if (uri == null) {
                return;
            }
            citation = new DefaultCitation();
        }
        if ((firstOnline = DefaultOnlineResource.castOrCopy((OnlineResource)CollectionsExt.first(onlineResources = citation.getOnlineResources()))) == null) {
            if (uri == null) {
                return;
            }
            firstOnline = new DefaultOnlineResource();
        }
        firstOnline.setLinkage(uri);
        onlineResources = ImplementationHelper.setFirst(onlineResources, firstOnline);
        citation.setOnlineResources(onlineResources);
        firstId.setCitation(citation);
        info = ImplementationHelper.setFirst(info, firstId);
        this.setIdentificationInfo(info);
    }

    @XmlElement(name="spatialRepresentationInfo")
    public Collection<SpatialRepresentation> getSpatialRepresentationInfo() {
        this.spatialRepresentationInfo = this.nonNullCollection(this.spatialRepresentationInfo, SpatialRepresentation.class);
        return this.spatialRepresentationInfo;
    }

    public void setSpatialRepresentationInfo(Collection<? extends SpatialRepresentation> newValues) {
        this.spatialRepresentationInfo = this.writeCollection(newValues, this.spatialRepresentationInfo, SpatialRepresentation.class);
    }

    @XmlElement(name="referenceSystemInfo")
    public Collection<ReferenceSystem> getReferenceSystemInfo() {
        this.referenceSystemInfo = this.nonNullCollection(this.referenceSystemInfo, ReferenceSystem.class);
        return this.referenceSystemInfo;
    }

    public void setReferenceSystemInfo(Collection<? extends ReferenceSystem> newValues) {
        this.referenceSystemInfo = this.writeCollection(newValues, this.referenceSystemInfo, ReferenceSystem.class);
    }

    @XmlElement(name="metadataExtensionInfo")
    public Collection<MetadataExtensionInformation> getMetadataExtensionInfo() {
        this.metadataExtensionInfo = this.nonNullCollection(this.metadataExtensionInfo, MetadataExtensionInformation.class);
        return this.metadataExtensionInfo;
    }

    public void setMetadataExtensionInfo(Collection<? extends MetadataExtensionInformation> newValues) {
        this.metadataExtensionInfo = this.writeCollection(newValues, this.metadataExtensionInfo, MetadataExtensionInformation.class);
    }

    @XmlElement(name="identificationInfo", required=true)
    public Collection<Identification> getIdentificationInfo() {
        this.identificationInfo = this.nonNullCollection(this.identificationInfo, Identification.class);
        return this.identificationInfo;
    }

    public void setIdentificationInfo(Collection<? extends Identification> newValues) {
        this.identificationInfo = this.writeCollection(newValues, this.identificationInfo, Identification.class);
    }

    @XmlElement(name="contentInfo")
    public Collection<ContentInformation> getContentInfo() {
        this.contentInfo = this.nonNullCollection(this.contentInfo, ContentInformation.class);
        return this.contentInfo;
    }

    public void setContentInfo(Collection<? extends ContentInformation> newValues) {
        this.contentInfo = this.writeCollection(newValues, this.contentInfo, ContentInformation.class);
    }

    @XmlElement(name="distributionInfo")
    public Distribution getDistributionInfo() {
        return this.distributionInfo;
    }

    public void setDistributionInfo(Distribution newValue) {
        this.checkWritePermission(this.distributionInfo);
        this.distributionInfo = newValue;
    }

    @XmlElement(name="dataQualityInfo")
    public Collection<DataQuality> getDataQualityInfo() {
        this.dataQualityInfo = this.nonNullCollection(this.dataQualityInfo, DataQuality.class);
        return this.dataQualityInfo;
    }

    public void setDataQualityInfo(Collection<? extends DataQuality> newValues) {
        this.dataQualityInfo = this.writeCollection(newValues, this.dataQualityInfo, DataQuality.class);
    }

    @XmlElement(name="portrayalCatalogueInfo")
    public Collection<PortrayalCatalogueReference> getPortrayalCatalogueInfo() {
        this.portrayalCatalogueInfo = this.nonNullCollection(this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
        return this.portrayalCatalogueInfo;
    }

    public void setPortrayalCatalogueInfo(Collection<? extends PortrayalCatalogueReference> newValues) {
        this.portrayalCatalogueInfo = this.writeCollection(newValues, this.portrayalCatalogueInfo, PortrayalCatalogueReference.class);
    }

    @XmlElement(name="metadataConstraints")
    public Collection<Constraints> getMetadataConstraints() {
        this.metadataConstraints = this.nonNullCollection(this.metadataConstraints, Constraints.class);
        return this.metadataConstraints;
    }

    public void setMetadataConstraints(Collection<? extends Constraints> newValues) {
        this.metadataConstraints = this.writeCollection(newValues, this.metadataConstraints, Constraints.class);
    }

    @XmlElement(name="applicationSchemaInfo")
    public Collection<ApplicationSchemaInformation> getApplicationSchemaInfo() {
        this.applicationSchemaInfo = this.nonNullCollection(this.applicationSchemaInfo, ApplicationSchemaInformation.class);
        return this.applicationSchemaInfo;
    }

    public void setApplicationSchemaInfo(Collection<? extends ApplicationSchemaInformation> newValues) {
        this.applicationSchemaInfo = this.writeCollection(newValues, this.applicationSchemaInfo, ApplicationSchemaInformation.class);
    }

    @XmlElement(name="acquisitionInformation")
    public Collection<AcquisitionInformation> getAcquisitionInformation() {
        this.acquisitionInformation = this.nonNullCollection(this.acquisitionInformation, AcquisitionInformation.class);
        return this.acquisitionInformation;
    }

    public void setAcquisitionInformation(Collection<? extends AcquisitionInformation> newValues) {
        this.acquisitionInformation = this.writeCollection(newValues, this.acquisitionInformation, AcquisitionInformation.class);
    }

    @XmlElement(name="metadataMaintenance")
    public MaintenanceInformation getMetadataMaintenance() {
        return this.metadataMaintenance;
    }

    public void setMetadataMaintenance(MaintenanceInformation newValue) {
        this.checkWritePermission(this.metadataMaintenance);
        this.metadataMaintenance = newValue;
    }

    @UML(identifier="resourceLineage", obligation=Obligation.OPTIONAL, specification=Specification.ISO_19115)
    public Collection<Lineage> getResourceLineages() {
        this.resourceLineages = this.nonNullCollection(this.resourceLineages, Lineage.class);
        return this.resourceLineages;
    }

    public void setResourceLineages(Collection<? extends Lineage> newValues) {
        this.resourceLineages = this.writeCollection(newValues, this.resourceLineages, Lineage.class);
    }

    private void beforeMarshal(Marshaller marshaller) {
        Context.push((Locale)CollectionsExt.first(LocaleAndCharset.getLanguages(this.getLocalesAndCharsets())));
    }

    private void afterMarshal(Marshaller marshaller) {
        Context.pull();
    }

    @XmlElement(name="defaultLocale")
    private PT_Locale getDefaultLocale() {
        return FilterByVersion.CURRENT_METADATA.accept() ? PT_Locale.first(this.getLocalesAndCharsets()) : null;
    }

    private void setDefaultLocale(PT_Locale newValue) {
        this.setLocalesAndCharsets(OtherLocales.setFirst(this.locales, newValue));
    }

    @XmlElement(name="otherLocale")
    private Collection<PT_Locale> getOtherLocales() {
        return FilterByVersion.CURRENT_METADATA.accept() ? OtherLocales.filter(this.getLocalesAndCharsets()) : null;
    }

    @XmlElement(name="characterSet", namespace="http://www.isotc211.org/2005/gmd")
    private Charset getCharset() {
        if (FilterByVersion.LEGACY_METADATA.accept()) {
            return LegacyPropertyAdapter.getSingleton(this.getCharacterSets(), Charset.class, null, DefaultMetadata.class, "getCharacterSet");
        }
        return null;
    }

    private void setCharset(Charset newValue) {
        this.setCharacterSets(CollectionsExt.singletonOrEmpty((Object)newValue));
    }

    @XmlElement(name="dateInfo", required=true)
    private Collection<CitationDate> getDates() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getDateInfo() : null;
    }

    @XmlElement(name="metadataStandard")
    private Collection<Citation> getMetadataStandard() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataStandards() : null;
    }

    @XmlElement(name="metadataProfile")
    private Collection<Citation> getMetadataProfile() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataProfiles() : null;
    }

    @XmlElement(name="alternativeMetadataReference")
    private Collection<Citation> getAlternativeMetadataReference() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getAlternativeMetadataReferences() : null;
    }

    @XmlElement(name="metadataLinkage")
    private Collection<OnlineResource> getMetadataLinkage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataLinkages() : null;
    }

    @XmlElement(name="resourceLineage")
    private Collection<Lineage> getResourceLineage() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getResourceLineages() : null;
    }

    @XmlElement(name="metadataScope")
    private Collection<DefaultMetadataScope> getMetadataScope() {
        return FilterByVersion.CURRENT_METADATA.accept() ? this.getMetadataScopes() : null;
    }

    private static final class ToLocale
    extends SurjectiveConverter<PT_Locale, Locale> {
        static final ToLocale INSTANCE = new ToLocale();

        private ToLocale() {
        }

        public Class<PT_Locale> getSourceClass() {
            return PT_Locale.class;
        }

        public Class<Locale> getTargetClass() {
            return Locale.class;
        }

        public Locale apply(PT_Locale p) {
            return p.getLocale();
        }

        public ObjectConverter<Locale, PT_Locale> inverse() {
            return FromLocale.INSTANCE;
        }
    }

    private static final class FromLocale
    implements ObjectConverter<Locale, PT_Locale> {
        static final FromLocale INSTANCE = new FromLocale();

        private FromLocale() {
        }

        public Set<FunctionProperty> properties() {
            return EnumSet.of(FunctionProperty.INJECTIVE);
        }

        public Class<Locale> getSourceClass() {
            return Locale.class;
        }

        public Class<PT_Locale> getTargetClass() {
            return PT_Locale.class;
        }

        public PT_Locale apply(Locale o) {
            return o != null ? new PT_Locale(o) : null;
        }

        public ObjectConverter<PT_Locale, Locale> inverse() {
            return ToLocale.INSTANCE;
        }
    }
}

