/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.xml;

import jakarta.xml.bind.JAXBException;
import jakarta.xml.bind.Marshaller;
import jakarta.xml.bind.PropertyException;
import jakarta.xml.bind.ValidationEventHandler;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.IllformedLocaleException;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.function.UnaryOperator;
import java.util.logging.Filter;
import javax.xml.validation.Schema;
import org.apache.sis.util.ArraysExt;
import org.apache.sis.util.CharSequences;
import org.apache.sis.util.Locales;
import org.apache.sis.util.Version;
import org.apache.sis.util.internal.Strings;
import org.apache.sis.util.resources.Errors;
import org.apache.sis.xml.ReferenceResolver;
import org.apache.sis.xml.TransformVersion;
import org.apache.sis.xml.ValueConverter;
import org.apache.sis.xml.bind.Context;
import org.apache.sis.xml.util.LegacyNamespaces;

abstract class Pooled {
    private static final String[] SCHEMA_KEYS = new String[]{"cat", "gmd", "gmi", "gml"};
    final Map<Object, Object> initialProperties = new LinkedHashMap<Object, Object>();
    private int bitMasks;
    private Locale locale;
    private TimeZone timezone;
    private Map<String, String> schemas;
    private Version versionGML;
    private Version versionMetadata;
    private ReferenceResolver resolver;
    private ValueConverter converter;
    private UnaryOperator<Object>[] rootAdapters;
    private Filter logFilter;
    volatile long resetTime;

    Pooled() {
    }

    Pooled(Pooled template) {
    }

    final void initialize(Pooled template) throws JAXBException {
        this.reset(template);
        for (Map.Entry<Object, Object> entry : template.initialProperties.entrySet()) {
            this.setStandardProperty((String)entry.getKey(), entry.getValue());
        }
    }

    public final void reset(Pooled template) throws JAXBException {
        for (Map.Entry<Object, Object> entry : this.initialProperties.entrySet()) {
            this.reset(entry.getKey(), entry.getValue());
        }
        this.initialProperties.clear();
        this.bitMasks = template.bitMasks;
        this.locale = template.locale;
        this.timezone = template.timezone;
        this.schemas = template.schemas;
        this.versionGML = template.versionGML;
        this.versionMetadata = template.versionMetadata;
        this.resolver = template.resolver;
        this.converter = template.converter;
        this.rootAdapters = template.rootAdapters;
        this.logFilter = template.logFilter;
        this.resetTime = System.nanoTime();
        if (this instanceof Marshaller) {
            this.bitMasks |= 1;
        }
    }

    protected abstract void reset(Object var1, Object var2) throws JAXBException;

    final TransformVersion getTransformVersion() {
        int combine;
        boolean byDefault = (this.bitMasks & 0x41) == 64;
        int n = combine = (this.specificBitMasks() & 0x20) != 0 ? 2 : 0;
        if (this.versionGML == null ? byDefault : this.versionGML.compareTo(LegacyNamespaces.VERSION_3_2_1) < 0) {
            combine = 1;
        }
        if (this.versionMetadata == null ? byDefault : this.versionMetadata.compareTo(LegacyNamespaces.VERSION_2014) < 0) {
            combine |= 2;
        }
        switch (combine) {
            case 0: {
                return null;
            }
            case 1: {
                return TransformVersion.GML31;
            }
            case 2: {
                return TransformVersion.ISO19139;
            }
            case 3: {
                return TransformVersion.ALL;
            }
        }
        throw new AssertionError(combine);
    }

    final boolean isPropertySaved(Class<?> key) {
        return this.initialProperties.containsKey(key);
    }

    final <E> void saveProperty(Class<E> type, E value) {
        if (this.initialProperties.put(type, value) != null) {
            throw new ConcurrentModificationException(Errors.format((short)134, (Object)(type.getInterfaces()[0].getSimpleName() + ".get" + type.getSimpleName())));
        }
    }

    public final void setProperty(String name, Object value) throws PropertyException {
        try {
            switch (name) {
                case "org.apache.sis.xml.locale": {
                    this.locale = value instanceof CharSequence ? Locales.parse((String)value.toString()) : (Locale)value;
                    return;
                }
                case "org.apache.sis.xml.timezone": {
                    this.timezone = value instanceof CharSequence ? TimeZone.getTimeZone(value.toString()) : (TimeZone)value;
                    return;
                }
                case "org.apache.sis.xml.schemas": {
                    Map map = (Map)value;
                    Map<String, String> copy = null;
                    if (map != null) {
                        copy = new HashMap(4);
                        for (String key : SCHEMA_KEYS) {
                            Object schema = map.get(key);
                            if (schema == null) continue;
                            if (!(schema instanceof String)) {
                                throw new PropertyException(Errors.format((short)58, (Object)Strings.bracket((String)name, (Object)key), schema.getClass()));
                            }
                            copy.put(key, (String)schema);
                        }
                        copy = Map.copyOf(copy);
                    }
                    this.schemas = copy;
                    return;
                }
                case "org.apache.sis.gml.version": {
                    this.versionGML = value instanceof CharSequence ? new Version(value.toString()) : (Version)value;
                    return;
                }
                case "org.apache.sis.xml.version.metadata": {
                    this.versionMetadata = value instanceof CharSequence ? new Version(value.toString()) : (Version)value;
                    return;
                }
                case "org.apache.sis.xml.resolver": {
                    this.resolver = (ReferenceResolver)value;
                    return;
                }
                case "org.apache.sis.xml.converter": {
                    this.converter = (ValueConverter)value;
                    return;
                }
                case "org.apache.sis.xml.lenient": {
                    this.bitMasks = value != null && (value instanceof CharSequence ? Boolean.parseBoolean(value.toString()) : (Boolean)value != false) ? (this.bitMasks |= 0x40) : (this.bitMasks &= 0xFFFFFFBF);
                    return;
                }
                case "org.apache.sis.xml.stringSubstitutes": {
                    this.bitMasks &= 0xFFFFFFE1;
                    if (value != null) {
                        for (CharSequence substitute : (CharSequence[])value) {
                            if (CharSequences.equalsIgnoreCase((CharSequence)substitute, (CharSequence)"language")) {
                                this.bitMasks |= 2;
                                continue;
                            }
                            if (CharSequences.equalsIgnoreCase((CharSequence)substitute, (CharSequence)"country")) {
                                this.bitMasks |= 4;
                                continue;
                            }
                            if (CharSequences.equalsIgnoreCase((CharSequence)substitute, (CharSequence)"filename")) {
                                this.bitMasks |= 8;
                                continue;
                            }
                            if (!CharSequences.equalsIgnoreCase((CharSequence)substitute, (CharSequence)"mimetype")) continue;
                            this.bitMasks |= 0x10;
                        }
                    }
                    return;
                }
                case "org.apache.sis.xml.warningFilter": {
                    this.logFilter = (Filter)value;
                    return;
                }
                case "org.apache.sis.xml.rootAdapters": {
                    UnaryOperator[] c = (UnaryOperator[])value;
                    this.rootAdapters = c;
                    return;
                }
            }
        }
        catch (ClassCastException | IllformedLocaleException e) {
            throw new PropertyException(Errors.format((short)58, (Object)name, value.getClass()), (Throwable)e);
        }
        if (!this.initialProperties.containsKey(name) && this.initialProperties.put(name, this.getStandardProperty(name)) != null) {
            throw new ConcurrentModificationException(name);
        }
        this.setStandardProperty(name, value);
    }

    public final Object getProperty(String name) throws PropertyException {
        switch (name) {
            case "org.apache.sis.xml.locale": {
                return this.locale;
            }
            case "org.apache.sis.xml.timezone": {
                return this.timezone;
            }
            case "org.apache.sis.xml.schemas": {
                return this.schemas;
            }
            case "org.apache.sis.gml.version": {
                return this.versionGML;
            }
            case "org.apache.sis.xml.version.metadata": {
                return this.versionMetadata;
            }
            case "org.apache.sis.xml.resolver": {
                return this.resolver;
            }
            case "org.apache.sis.xml.converter": {
                return this.converter;
            }
            case "org.apache.sis.xml.warningFilter": {
                return this.logFilter;
            }
            case "org.apache.sis.xml.lenient": {
                return (this.bitMasks & 0x40) != 0;
            }
            case "org.apache.sis.xml.stringSubstitutes": {
                int n = 0;
                Object[] substitutes = new String[4];
                if ((this.bitMasks & 2) != 0) {
                    substitutes[n++] = "language";
                }
                if ((this.bitMasks & 4) != 0) {
                    substitutes[n++] = "country";
                }
                if ((this.bitMasks & 8) != 0) {
                    substitutes[n++] = "filename";
                }
                if ((this.bitMasks & 0x10) != 0) {
                    substitutes[n++] = "mimetype";
                }
                return n != 0 ? ArraysExt.resize((Object[])substitutes, (int)n) : null;
            }
            case "org.apache.sis.xml.rootAdapters": {
                return this.rootAdapters != null ? this.rootAdapters.clone() : null;
            }
        }
        return this.getStandardProperty(name);
    }

    abstract void setStandardProperty(String var1, Object var2) throws PropertyException;

    abstract Object getStandardProperty(String var1) throws PropertyException;

    public <A extends XmlAdapter<?, ?>> void setAdapter(A adapter) {
        this.setAdapter(adapter.getClass(), adapter);
    }

    public <A extends XmlAdapter<?, ?>> void setAdapter(Class<A> type, A adapter) {
        if (!this.isPropertySaved(type)) {
            this.saveProperty(type, this.getAdapter(type));
        }
    }

    public abstract <A extends XmlAdapter<?, ?>> A getAdapter(Class<A> var1);

    final UnaryOperator<Object>[] getRootAdapters() {
        return this.rootAdapters;
    }

    public void setSchema(Schema schema) {
        if (!this.isPropertySaved(Schema.class)) {
            this.saveProperty(Schema.class, this.getSchema());
        }
    }

    public abstract Schema getSchema();

    public void setEventHandler(ValidationEventHandler handler) throws JAXBException {
        if (!this.initialProperties.containsKey(ValidationEventHandler.class)) {
            this.saveProperty(ValidationEventHandler.class, this.getEventHandler());
        }
    }

    public abstract ValidationEventHandler getEventHandler() throws JAXBException;

    int specificBitMasks() {
        return 0;
    }

    final Context begin() {
        return new Context(this.bitMasks | this.specificBitMasks(), this.locale, this.timezone, this.schemas, this.versionGML, this.versionMetadata, this.resolver, this.converter, this.logFilter);
    }
}

