/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.flatgeobuf;

import java.nio.ByteBuffer;
import java.util.List;
import org.locationtech.jts.geom.Geometry;

public class FlatGeoBuf {
    protected static final byte[] MAGIC_BYTES = new byte[]{102, 103, 98, 3, 102, 103, 98, 0};

    private FlatGeoBuf() {
    }

    public static boolean isFlatGeoBuf(ByteBuffer bb) {
        return bb.get() == MAGIC_BYTES[0] && bb.get() == MAGIC_BYTES[1] && bb.get() == MAGIC_BYTES[2] && bb.get() == MAGIC_BYTES[3] && bb.get() == MAGIC_BYTES[4] && bb.get() == MAGIC_BYTES[5] && bb.get() == MAGIC_BYTES[6] && bb.get() == MAGIC_BYTES[7];
    }

    public record Feature(List<Object> properties, Geometry geometry) {
    }

    public record Header(String name, List<Double> envelope, GeometryType geometryType, boolean hasZ, boolean hasM, boolean hasT, boolean hasTM, List<Column> columns, long featuresCount, int indexNodeSize, Crs crs, String title, String description, String metadata) {
    }

    public record Crs(String org, int code, String name, String description, String wkt, String codeString) {
    }

    public record Column(String name, ColumnType type, String title, String description, int width, int precision, int scale, boolean nullable, boolean unique, boolean primaryKey, String metadata) {
    }

    public static enum ColumnType {
        BYTE,
        UBYTE,
        BOOL,
        SHORT,
        USHORT,
        INT,
        UINT,
        LONG,
        ULONG,
        FLOAT,
        DOUBLE,
        STRING,
        JSON,
        DATETIME,
        BINARY;

    }

    public static enum GeometryType {
        UNKNOWN(0),
        POINT(1),
        LINESTRING(2),
        POLYGON(3),
        MULTIPOINT(4),
        MULTILINESTRING(5),
        MULTIPOLYGON(6),
        GEOMETRYCOLLECTION(7),
        CIRCULARSTRING(8),
        COMPOUNDCURVE(9),
        CURVEPOLYGON(10),
        MULTICURVE(11),
        MULTISURFACE(12),
        CURVE(13),
        SURFACE(14),
        POLYHEDRALSURFACE(15),
        TIN(16),
        TRIANGLE(17);

        private final int value;

        private GeometryType(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }
    }
}

