/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.store;

import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataSchema;

public interface DataTable
extends Iterable<DataRow> {
    public DataSchema schema();

    public long size();

    default public boolean isEmpty() {
        return this.size() == 0L;
    }

    @Override
    public Iterator<DataRow> iterator();

    @Override
    default public Spliterator<DataRow> spliterator() {
        return Spliterators.spliteratorUnknownSize(this.iterator(), 16);
    }

    default public Stream<DataRow> stream() {
        return StreamSupport.stream(this.spliterator(), false);
    }

    default public Stream<DataRow> parallelStream() {
        return StreamSupport.stream(this.spliterator(), true);
    }

    default public boolean add(DataRow e) {
        throw new UnsupportedOperationException();
    }

    default public boolean addAll(Iterable<DataRow> c) {
        boolean modified = false;
        for (DataRow e : c) {
            if (!this.add(e)) continue;
            modified = true;
        }
        return modified;
    }

    default public boolean contains(Object o) {
        for (DataRow e : this) {
            if (!e.equals(o)) continue;
            return true;
        }
        return false;
    }

    default public boolean containsAll(Iterable<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public void clear();
}

