/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.store;

import java.util.List;
import java.util.function.UnaryOperator;
import org.apache.baremaps.store.DataColumn;
import org.apache.baremaps.store.DataRow;
import org.apache.baremaps.store.DataTable;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.util.GeometryTransformer;

public class DataTableGeometryMapper
implements UnaryOperator<DataRow> {
    private final DataTable table;
    private final GeometryTransformer mapper;

    public DataTableGeometryMapper(DataTable table, GeometryTransformer mapper) {
        this.table = table;
        this.mapper = mapper;
    }

    @Override
    public DataRow apply(DataRow row) {
        List<DataColumn> columns = this.table.schema().columns().stream().filter(column -> column.type().binding().isAssignableFrom(Geometry.class)).toList();
        for (DataColumn column2 : columns) {
            String name = column2.name();
            Geometry geometry = (Geometry)row.get(name);
            if (geometry == null) continue;
            row.set(name, (Object)this.mapper.transform(geometry));
        }
        return row;
    }
}

