/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.shapefile;

import java.nio.ByteOrder;
import java.nio.MappedByteBuffer;
import org.apache.baremaps.shapefile.ShapefileGeometryType;

public class ShapefileDescriptor {
    private int fileCode;
    private int fileLength;
    private int version;
    private ShapefileGeometryType shapefileGeometryType;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double zmin;
    private double zmax;
    private double mmin;
    private double mmax;

    public ShapefileDescriptor(MappedByteBuffer byteBuffer) {
        this.fileCode = byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        byteBuffer.getInt();
        this.fileLength = byteBuffer.getInt() * 2;
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        this.version = byteBuffer.getInt();
        this.shapefileGeometryType = ShapefileGeometryType.get(byteBuffer.getInt());
        this.xmin = byteBuffer.getDouble();
        this.ymin = byteBuffer.getDouble();
        this.xmax = byteBuffer.getDouble();
        this.ymax = byteBuffer.getDouble();
        this.zmin = byteBuffer.getDouble();
        this.zmax = byteBuffer.getDouble();
        this.mmin = byteBuffer.getDouble();
        this.mmax = byteBuffer.getDouble();
        byteBuffer.order(ByteOrder.BIG_ENDIAN);
    }

    public int getVersion() {
        return this.version;
    }

    public ShapefileGeometryType getShapeType() {
        return this.shapefileGeometryType;
    }

    public double getXmin() {
        return this.xmin;
    }

    public double getYmin() {
        return this.ymin;
    }

    public double getXmax() {
        return this.xmax;
    }

    public double getYmax() {
        return this.ymax;
    }

    public double getZmin() {
        return this.zmin;
    }

    public double getZmax() {
        return this.zmax;
    }

    public double getMmin() {
        return this.mmin;
    }

    public double getMmax() {
        return this.mmax;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        String lineSeparator = System.lineSeparator();
        s.append("FileCode: ").append(this.fileCode).append(lineSeparator);
        s.append("FileLength: ").append(this.fileLength).append(lineSeparator);
        s.append("Version: ").append(this.version).append(lineSeparator);
        s.append("ShapeType: ").append((Object)this.shapefileGeometryType).append(lineSeparator);
        s.append("xmin: ").append(this.xmin).append(lineSeparator);
        s.append("ymin: ").append(this.ymin).append(lineSeparator);
        s.append("xmax: ").append(this.xmax).append(lineSeparator);
        s.append("ymax: ").append(this.ymax).append(lineSeparator);
        s.append("zmin: ").append(this.zmin).append(lineSeparator);
        s.append("zmax: ").append(this.zmax).append(lineSeparator);
        s.append("mmin: ").append(this.mmin).append(lineSeparator);
        s.append("mmax: ").append(this.mmax).append(lineSeparator);
        s.append("------------------------").append(lineSeparator);
        return s.toString();
    }
}

