/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.base;

import java.awt.Point;
import java.awt.image.ColorModel;
import java.awt.image.DataBuffer;
import java.awt.image.MultiPixelPackedSampleModel;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import org.apache.sis.coverage.CannotEvaluateException;
import org.apache.sis.coverage.grid.DisjointExtentException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.j2d.DeferredProperty;
import org.apache.sis.coverage.grid.j2d.TiledImage;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.base.TiledDeferredImage;
import org.apache.sis.storage.base.TiledGridResource;
import org.apache.sis.storage.internal.Resources;
import org.apache.sis.util.collection.WeakValueHashMap;
import org.apache.sis.util.internal.Numerics;
import org.apache.sis.util.resources.Errors;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.util.GenericName;

public abstract class TiledGridCoverage
extends GridCoverage {
    protected static final int BIDIMENSIONAL = 2;
    protected static final int X_DIMENSION = 0;
    protected static final int Y_DIMENSION = 1;
    private final GridExtent readExtent;
    private final boolean forceTileSize;
    private final int[] tileSize;
    private final int[] tileStrides;
    private final int indexOfFirstTile;
    private final long[] tmcOfFirstTile;
    private final int[] subsampling;
    private final int[] subsamplingOffsets;
    protected final int[] includedBands;
    private final WeakValueHashMap<TiledGridResource.CacheKey, Raster> rasters;
    protected final SampleModel model;
    protected final ColorModel colors;
    protected final Number fillValue;
    private final boolean deferredTileReading;

    protected TiledGridCoverage(TiledGridResource.Subset subset) {
        super(subset.domain, subset.ranges);
        GridExtent extent = subset.domain.getExtent();
        int dimension = subset.sourceExtent.getDimension();
        this.deferredTileReading = subset.deferredTileReading();
        this.readExtent = subset.readExtent;
        this.subsampling = subset.subsampling;
        this.subsamplingOffsets = subset.subsamplingOffsets;
        this.includedBands = subset.includedBands;
        this.rasters = subset.cache;
        this.tileSize = subset.tileSize;
        this.tmcOfFirstTile = new long[dimension];
        this.tileStrides = new int[dimension];
        int[] subSize = new int[dimension];
        int tileStride = 1;
        long indexOfFirstTile = 0L;
        for (int i = 0; i < dimension; ++i) {
            int ts = this.tileSize[i];
            this.tmcOfFirstTile[i] = Math.floorDiv(this.readExtent.getLow(i), ts);
            this.tileStrides[i] = tileStride;
            subSize[i] = (int)Math.min((long)((ts - 1) / this.subsampling[i] + 1), extent.getSize(i));
            indexOfFirstTile = Math.addExact(indexOfFirstTile, Math.multiplyExact(this.tmcOfFirstTile[i], tileStride));
            int tileCount = Math.toIntExact(Numerics.ceilDiv((long)subset.sourceExtent.getSize(i), (long)ts));
            tileStride = Math.multiplyExact(tileCount, tileStride);
        }
        this.indexOfFirstTile = Math.toIntExact(indexOfFirstTile);
        SampleModel model = subset.modelForBandSubset;
        if (model.getWidth() != subSize[0] || model.getHeight() != subSize[1]) {
            model = model.createCompatibleSampleModel(subSize[0], subSize[1]);
        }
        this.model = model;
        this.colors = subset.colorsForBandSubset;
        this.fillValue = subset.fillValue;
        this.forceTileSize = subSize[0] * this.subsampling[0] == this.tileSize[0];
    }

    protected abstract GenericName getIdentifier();

    protected Locale getLocale() {
        return null;
    }

    protected final int getTileSize(int dimension) {
        return this.tileSize[dimension];
    }

    protected final int getSubsampling(int dimension) {
        return this.subsampling[dimension];
    }

    private long toFullResolution(long coordinate, int dimension) {
        return Math.addExact(Math.multiplyExact(coordinate, this.subsampling[dimension]), (long)this.subsamplingOffsets[dimension]);
    }

    private long toSubsampledPixel(long coordinate, int dimension) {
        return Math.floorDiv(Math.subtractExact(coordinate, (long)this.subsamplingOffsets[dimension]), this.subsampling[dimension]);
    }

    private long toTileMatrixCoordinate(long coordinate, int dimension) {
        return Math.floorDiv(this.toFullResolution(coordinate, dimension), this.tileSize[dimension]);
    }

    protected final int getPixelsPerElement() {
        return TiledGridCoverage.getPixelsPerElement(this.model);
    }

    static int getPixelsPerElement(SampleModel model) {
        int sampleSize;
        int typeSize;
        int pixelsPerElement;
        if (model instanceof MultiPixelPackedSampleModel && (pixelsPerElement = (typeSize = DataBuffer.getDataTypeSize(model.getDataType())) / (sampleSize = ((MultiPixelPackedSampleModel)model).getPixelBitStride())) > 0) {
            return pixelsPerElement;
        }
        return 1;
    }

    public RenderedImage render(GridExtent sliceExtent) {
        TiledDeferredImage image;
        GridExtent available = this.gridGeometry.getExtent();
        int dimension = available.getDimension();
        if (sliceExtent == null) {
            sliceExtent = available;
        } else {
            int sd = sliceExtent.getDimension();
            if (sd != dimension) {
                throw new MismatchedDimensionException(Errors.format((short)81, (Object)"sliceExtent", (Object)dimension, (Object)sd));
            }
        }
        int[] selectedDimensions = sliceExtent.getSubspaceDimensions(2);
        if (selectedDimensions[1] != 1) {
            throw new UnsupportedOperationException("Non-horizontal slices not yet implemented.");
        }
        try {
            int[] tileLower = new int[dimension];
            int[] tileUpper = new int[dimension];
            int[] offsetAOI = new int[dimension];
            int[] imageSize = new int[dimension];
            for (int i = 0; i < dimension; ++i) {
                long tileLo;
                long min = available.getLow(i);
                long max = available.getHigh(i);
                long aoiMin = sliceExtent.getLow(i);
                long aoiMax = sliceExtent.getHigh(i);
                long tileUp = Math.incrementExact(this.toTileMatrixCoordinate(Math.min(aoiMax, max), i));
                if (tileUp <= (tileLo = this.toTileMatrixCoordinate(Math.max(aoiMin, min), i))) {
                    String message = Errors.getResources((Locale)this.getLocale()).getString((short)60, (Object)aoiMin, (Object)aoiMax);
                    if (aoiMin > aoiMax) {
                        throw new IllegalArgumentException(message);
                    }
                    throw new DisjointExtentException(message);
                }
                long lower = Math.max(this.toSubsampledPixel(Math.multiplyExact(tileLo, this.tileSize[i]), i), min);
                long upper = Math.incrementExact(Math.min(this.toSubsampledPixel(Math.decrementExact(Math.multiplyExact(tileUp, this.tileSize[i])), i), max));
                imageSize[i] = Math.toIntExact(Math.subtractExact(upper, lower));
                offsetAOI[i] = Math.toIntExact(Math.subtractExact(lower, aoiMin));
                tileLower[i] = Math.toIntExact(Math.subtractExact(tileLo, this.tmcOfFirstTile[i]));
                tileUpper[i] = Math.toIntExact(Math.subtractExact(tileUp, this.tmcOfFirstTile[i]));
            }
            AOI iterator = new AOI(tileLower, tileUpper, offsetAOI, dimension);
            Map properties = DeferredProperty.forGridGeometry((GridGeometry)this.gridGeometry, (int[])selectedDimensions);
            if (this.deferredTileReading) {
                image = new TiledDeferredImage(imageSize, tileLower, properties, iterator);
            } else {
                Raster[] result = this.readTiles(iterator);
                image = new TiledImage(properties, this.colors, imageSize[0], imageSize[1], tileLower[0], tileLower[1], result);
            }
        }
        catch (Exception e) {
            throw new CannotEvaluateException(Resources.forLocale(this.getLocale()).getString((short)61, this.getIdentifier().toFullyQualifiedName()), (Throwable)e);
        }
        return image;
    }

    private TiledGridResource.CacheKey createCacheKey(int indexInTileVector) {
        return new TiledGridResource.CacheKey(indexInTileVector, this.includedBands, this.subsampling, this.subsamplingOffsets);
    }

    protected abstract Raster[] readTiles(AOI var1) throws IOException, DataStoreException;

    protected final class AOI {
        public final int tileCountInQuery;
        private final int[] tileLower;
        private final int[] tileUpper;
        private final int[] offsetAOI;
        private final int[] tmcInSubset;
        private final long[] tileOffsetFull;
        private int indexInResultArray;
        private int indexInTileVector;

        AOI(int[] tileLower, int[] tileUpper, int[] offsetAOI, int dimension) {
            this.tileLower = tileLower;
            this.tileUpper = tileUpper;
            this.offsetAOI = offsetAOI;
            this.tileOffsetFull = new long[offsetAOI.length];
            this.indexInTileVector = TiledGridCoverage.this.indexOfFirstTile;
            int tileCountInQuery = 1;
            for (int i = 0; i < dimension; ++i) {
                int lower = tileLower[i];
                int count = Math.subtractExact(tileUpper[i], lower);
                this.indexInTileVector = Math.addExact(this.indexInTileVector, Math.multiplyExact(TiledGridCoverage.this.tileStrides[i], lower));
                tileCountInQuery = Math.multiplyExact(tileCountInQuery, count);
                this.tileOffsetFull[i] = Math.multiplyFull(offsetAOI[i], TiledGridCoverage.this.subsampling[i]);
                int max = Math.addExact(offsetAOI[i], Math.multiplyExact(TiledGridCoverage.this.tileSize[i], count));
                assert (max > Math.max(offsetAOI[i], 0)) : max;
            }
            this.tileCountInQuery = tileCountInQuery;
            this.tmcInSubset = (int[])tileLower.clone();
        }

        public AOI subset(int[] tileLower, int[] tileUpper) {
            int[] offset = (int[])this.offsetAOI.clone();
            int[] lower = (int[])this.tileLower.clone();
            int i = Math.min(tileLower.length, lower.length);
            while (--i >= 0) {
                int s = tileLower[i];
                int base = lower[i];
                if (s <= base) continue;
                lower[i] = s;
                offset[i] = Math.addExact(offset[i], Numerics.ceilDiv((int)Math.multiplyExact(s - base, TiledGridCoverage.this.tileSize[i]), (int)TiledGridCoverage.this.subsampling[i]));
            }
            int[] upper = (int[])this.tileUpper.clone();
            int i2 = Math.min(tileUpper.length, upper.length);
            while (--i2 >= 0) {
                upper[i2] = Math.max(lower[i2], Math.min(upper[i2], tileUpper[i2]));
            }
            return new AOI(lower, upper, offset, offset.length);
        }

        final TiledGridCoverage getCoverage() {
            return TiledGridCoverage.this;
        }

        public final int getIndexInResultArray() {
            return this.indexInResultArray;
        }

        public Raster getCachedTile() {
            Raster tile = (Raster)TiledGridCoverage.this.rasters.get((Object)TiledGridCoverage.this.createCacheKey(this.indexInTileVector));
            if (tile != null) {
                int x = this.getTileOrigin(0);
                int y = this.getTileOrigin(1);
                if (TiledGridCoverage.this.model.equals(tile.getSampleModel())) {
                    if (tile.getMinX() == x && tile.getMinY() == y) {
                        return tile;
                    }
                    return tile.createTranslatedChild(x, y);
                }
                SampleModel sm = tile.getSampleModel();
                if (sm.getWidth() == TiledGridCoverage.this.model.getWidth() && sm.getHeight() == TiledGridCoverage.this.model.getHeight()) {
                    int width = tile.getWidth();
                    int height = tile.getHeight();
                    Raster r = Raster.createRaster(TiledGridCoverage.this.model, tile.getDataBuffer(), new Point(x, y));
                    if (r.getWidth() != width || r.getHeight() != height) {
                        r = r.createChild(x, y, width, height, x, y, null);
                    }
                    return r;
                }
            }
            return null;
        }

        final int getTileOrigin(int dimension) {
            return Math.toIntExact(Numerics.ceilDiv((long)this.tileOffsetFull[dimension], (long)TiledGridCoverage.this.subsampling[dimension]));
        }

        public boolean next() {
            if (++this.indexInResultArray >= this.tileCountInQuery) {
                return false;
            }
            for (int i = 0; i < this.tmcInSubset.length; ++i) {
                this.indexInTileVector += TiledGridCoverage.this.tileStrides[i];
                int n = i;
                this.tmcInSubset[n] = this.tmcInSubset[n] + 1;
                if (this.tmcInSubset[n] < this.tileUpper[i]) {
                    int n2 = i;
                    this.tileOffsetFull[n2] = this.tileOffsetFull[n2] + (long)TiledGridCoverage.this.tileSize[i];
                    break;
                }
                this.indexInTileVector -= (this.tmcInSubset[i] - this.tileLower[i]) * TiledGridCoverage.this.tileStrides[i];
                this.tmcInSubset[i] = this.tileLower[i];
                this.tileOffsetFull[i] = Math.multiplyFull(this.offsetAOI[i], TiledGridCoverage.this.subsampling[i]);
            }
            return true;
        }
    }

    protected static class Snapshot {
        private final TiledGridCoverage coverage;
        private final int[] tmcInSubset;
        public final int indexInResultArray;
        public final int indexInTileVector;
        public final int originX;
        public final int originY;

        public Snapshot(AOI iterator) {
            this.coverage = iterator.getCoverage();
            this.tmcInSubset = (int[])iterator.tmcInSubset.clone();
            this.indexInResultArray = iterator.indexInResultArray;
            this.indexInTileVector = iterator.indexInTileVector;
            this.originX = iterator.getTileOrigin(0);
            this.originY = iterator.getTileOrigin(1);
        }

        public boolean getRegionInsideTile(long[] lower, long[] upper, int[] subsampling, int dimension) {
            System.arraycopy(this.coverage.subsampling, 0, subsampling, 0, dimension);
            while (--dimension >= 0) {
                int s;
                int tileSize = this.coverage.tileSize[dimension];
                long tileIndex = Math.addExact(this.coverage.tmcOfFirstTile[dimension], (long)this.tmcInSubset[dimension]);
                long tileBase = Math.multiplyExact(tileIndex, tileSize);
                long offset = Math.subtractExact(this.coverage.readExtent.getLow(dimension), tileBase);
                long limit = Math.min(Math.addExact(offset, this.coverage.readExtent.getSize(dimension)), (long)tileSize);
                if (offset < 0L && (offset %= (long)(s = this.coverage.subsampling[dimension])) != 0L) {
                    offset += (long)s;
                }
                if (offset >= limit) {
                    return false;
                }
                if (dimension == 0 && this.coverage.forceTileSize) {
                    limit = tileSize;
                }
                lower[dimension] = offset;
                upper[dimension] = limit;
            }
            return true;
        }

        public Raster cache(Raster tile) {
            TiledGridResource.CacheKey key = this.coverage.createCacheKey(this.indexInTileVector);
            Raster existing = (Raster)this.coverage.rasters.put((Object)key, (Object)tile);
            if (existing != null && existing.getSampleModel().equals(tile.getSampleModel()) && existing.getWidth() == tile.getWidth() && existing.getHeight() == tile.getHeight() && this.coverage.rasters.replace((Object)key, (Object)tile, (Object)existing)) {
                int x = tile.getMinX();
                int y = tile.getMinY();
                if (existing.getMinX() != x || existing.getMinY() != y) {
                    existing = existing.createTranslatedChild(x, y);
                }
                return existing;
            }
            return tile;
        }
    }
}

