/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.image;

import java.awt.geom.AffineTransform;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.OpenOption;
import java.nio.file.StandardOpenOption;
import java.util.function.BiConsumer;
import javax.imageio.ImageReader;
import javax.imageio.ImageWriter;
import javax.imageio.spi.IIORegistry;
import javax.imageio.spi.ImageReaderSpi;
import javax.imageio.spi.ImageReaderWriterSpi;
import javax.imageio.spi.ImageWriterSpi;
import javax.imageio.stream.ImageInputStream;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.referencing.operation.matrix.AffineTransforms2D;
import org.apache.sis.setup.OptionKey;
import org.apache.sis.storage.DataStoreClosedException;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.IncompatibleResourceException;
import org.apache.sis.storage.Resource;
import org.apache.sis.storage.UnsupportedStorageException;
import org.apache.sis.storage.WritableGridCoverageResource;
import org.apache.sis.storage.image.FormatFinder;
import org.apache.sis.storage.image.WarningListener;
import org.apache.sis.storage.image.WorldFileResource;
import org.apache.sis.storage.image.WorldFileStore;
import org.apache.sis.storage.image.WritableResource;
import org.apache.sis.util.ComparisonMode;
import org.opengis.referencing.operation.MathTransform;

class WritableStore
extends WorldFileStore {
    private final long streamBeginning;
    private ImageWriter writer;
    private int numImages;

    WritableStore(FormatFinder format) throws DataStoreException, IOException {
        super(format, false);
        if (this.getCurrentReader() != null) {
            this.numImages = -1;
        } else {
            this.writer = format.getOrCreateWriter(null);
            if (this.writer == null) {
                throw new UnsupportedStorageException(super.getLocale(), "World file", format.storage, (OpenOption[])format.connector.getOption(OptionKey.OPEN_OPTIONS));
            }
            this.configureWriter();
            if (!format.fileIsEmpty) {
                this.numImages = -1;
            }
        }
        this.streamBeginning = format.storage instanceof ImageInputStream ? ((ImageInputStream)format.storage).getStreamPosition() : 0L;
    }

    private void configureWriter() {
        try {
            this.writer.setLocale(this.listeners.getLocale());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        this.writer.addIIOWriteWarningListener(new WarningListener(this.listeners));
    }

    @Override
    public String[] getImageFormat(boolean asMimeType) {
        ImageWriterSpi provider;
        if (this.writer != null && (provider = this.writer.getOriginatingProvider()) != null) {
            String[] names;
            String[] stringArray = names = asMimeType ? provider.getMIMETypes() : provider.getFormatNames();
            if (names != null) {
                return names;
            }
        }
        return super.getImageFormat(asMimeType);
    }

    final int isMultiImages() throws IOException, DataStoreException {
        if (this.numImages < 0) {
            WorldFileStore.Components components = this.components(true, this.numImages);
            if (components.isEmpty()) {
                this.numImages = 0;
            } else {
                if (components.exists(1)) {
                    return 2;
                }
                this.numImages = 1;
            }
        }
        return this.numImages;
    }

    @Override
    String setGridGeometry(int index, GridGeometry gg) throws IOException, DataStoreException {
        String suffix;
        assert (Thread.holdsLock(this));
        GridExtent extent = gg.getExtent();
        long[] translation = new long[extent.getDimension()];
        for (int i = 0; i < translation.length; ++i) {
            translation[i] = Math.negateExact(extent.getLow(i));
        }
        gg = gg.shiftGrid(translation);
        if (!(index == 0 && this.isMultiImages() <= 1 || this.getGridGeometry(0).equals((Object)gg, ComparisonMode.IGNORE_METADATA))) {
            throw new IncompatibleResourceException(this.resources().getString((short)72));
        }
        AffineTransform gridToCRS = null;
        if (gg.isDefined(8)) {
            try {
                gridToCRS = AffineTransforms2D.castOrCopy((MathTransform)gg.getGridToCRS(CELL_ANCHOR));
            }
            catch (IllegalArgumentException e) {
                throw new IncompatibleResourceException(e.getLocalizedMessage(), e);
            }
        }
        if ((suffix = super.setGridGeometry(index, gg)) != null) {
            block24: {
                if (gridToCRS == null) {
                    this.deleteAuxiliaryFile(suffix);
                } else {
                    try (BufferedWriter out = this.writeAuxiliaryFile(suffix);){
                        int i = 0;
                        while (true) {
                            double c;
                            switch (i) {
                                case 0: {
                                    c = gridToCRS.getScaleX();
                                    break;
                                }
                                case 1: {
                                    c = gridToCRS.getShearY();
                                    break;
                                }
                                case 2: {
                                    c = gridToCRS.getShearX();
                                    break;
                                }
                                case 3: {
                                    c = gridToCRS.getScaleY();
                                    break;
                                }
                                case 4: {
                                    c = gridToCRS.getTranslateX();
                                    break;
                                }
                                case 5: {
                                    c = gridToCRS.getTranslateY();
                                    break;
                                }
                                default: {
                                    break block24;
                                }
                            }
                            out.write(Double.toString(c));
                            out.newLine();
                            ++i;
                        }
                    }
                }
            }
            this.writePRJ();
        }
        return suffix;
    }

    @Override
    WorldFileResource createImageResource(int index) throws DataStoreException, IOException {
        return new WritableResource(this, this.listeners, index, this.getGridGeometry(index));
    }

    public synchronized Resource add(Resource resource) throws DataStoreException {
        Exception cause = null;
        if (resource instanceof GridCoverageResource) {
            try {
                WorldFileStore.Components components = this.components(true, this.numImages);
                if (this.numImages < 0) {
                    this.numImages = components.size();
                }
                GridGeometry domain = null;
                if (this.numImages != 0) {
                    domain = this.getGridGeometry(0);
                }
                GridCoverage coverage = ((GridCoverageResource)resource).read(domain, null);
                if (domain == null) {
                    domain = coverage.getGridGeometry();
                }
                WritableResource image = new WritableResource(this, this.listeners, this.numImages, domain);
                image.write(coverage, new WritableGridCoverageResource.Option[0]);
                components.added(image);
                ++this.numImages;
                return image;
            }
            catch (IOException | RuntimeException e) {
                cause = e;
            }
        }
        throw new DataStoreException(this.resources().getString((short)69, WritableStore.label(resource)), cause);
    }

    @Override
    public synchronized void remove(Resource resource) throws DataStoreException {
        WritableResource image;
        Exception cause = null;
        if (resource instanceof WritableResource && (image = (WritableResource)resource).store() == this) {
            try {
                int imageIndex = image.getImageIndex();
                this.writer().removeImage(imageIndex);
                WorldFileStore.Components components = this.components(false, this.numImages);
                if (components != null) {
                    components.removed(imageIndex);
                    image.dispose();
                    --this.numImages;
                }
            }
            catch (IOException | RuntimeException e) {
                cause = e;
            }
        }
        throw new DataStoreException(this.resources().getString((short)49, this.getDisplayName(), WritableStore.label(resource)), cause);
    }

    private static String label(Resource resource) throws DataStoreException {
        return resource.getIdentifier().map(Object::toString).orElse("?");
    }

    @Override
    ImageReader prepareReader(ImageReader current) throws IOException {
        Object output;
        ImageWriter writer = this.writer;
        if (writer != null && (output = writer.getOutput()) != null) {
            ImageReaderSpi rp;
            ImageWriterSpi wp;
            if (current == null && (wp = writer.getOriginatingProvider()) != null && (rp = this.getProviderByClass(ImageReaderSpi.class, wp.getImageReaderSpiNames(), wp)) != null) {
                current = rp.createReaderInstance();
            }
            if (current != null) {
                writer.setOutput(null);
                this.setStream(current, output, ImageReader::setInput);
                return current;
            }
        }
        return null;
    }

    final ImageWriter writer() throws DataStoreException, IOException {
        Object input;
        assert (Thread.holdsLock(this));
        ImageWriter current = this.writer;
        if (current != null && current.getOutput() != null) {
            return current;
        }
        ImageReader reader = this.getCurrentReader();
        if (reader != null && (input = reader.getInput()) != null) {
            ImageWriterSpi wp;
            ImageReaderSpi rp;
            if (current == null && (rp = reader.getOriginatingProvider()) != null && (wp = this.getProviderByClass(ImageWriterSpi.class, rp.getImageWriterSpiNames(), rp)) != null) {
                current = wp.createWriterInstance();
            }
            if (current != null) {
                reader.setInput(null);
                this.setStream(current, input, ImageWriter::setOutput);
                this.writer = current;
                this.configureWriter();
                return current;
            }
        }
        throw new DataStoreClosedException(this.getLocale(), "World file", StandardOpenOption.WRITE);
    }

    private <T> void setStream(T codec, Object stream, BiConsumer<T, Object> setter) throws IOException {
        try {
            if (stream instanceof ImageInputStream) {
                ((ImageInputStream)stream).seek(this.streamBeginning);
            }
            setter.accept(codec, stream);
        }
        catch (Throwable exception) {
            if (stream instanceof AutoCloseable) {
                try {
                    ((AutoCloseable)stream).close();
                }
                catch (Throwable s) {
                    exception.addSuppressed(s);
                }
            }
            throw exception;
        }
    }

    private <T extends ImageReaderWriterSpi> T getProviderByClass(Class<T> type, String[] classNames, ImageReaderWriterSpi originating) {
        if (classNames != null) {
            IIORegistry registry = IIORegistry.getDefaultInstance();
            ClassLoader loader = originating.getClass().getClassLoader();
            for (String name : classNames) {
                Class<T> impl;
                try {
                    impl = Class.forName(name, true, loader).asSubclass(type);
                }
                catch (ClassCastException | ClassNotFoundException e) {
                    this.listeners.warning(e);
                    continue;
                }
                ImageReaderWriterSpi candidate = (ImageReaderWriterSpi)registry.getServiceProviderByClass(impl);
                if (candidate == null) continue;
                return (T)candidate;
            }
        }
        return null;
    }

    @Override
    public synchronized void close() throws DataStoreException {
        block8: {
            this.listeners.close();
            try {
                ImageWriter codec = this.writer;
                this.writer = null;
                if (codec == null) break block8;
                try {
                    Object output = codec.getOutput();
                    codec.setOutput(null);
                    codec.dispose();
                    if (output instanceof AutoCloseable) {
                        ((AutoCloseable)output).close();
                    }
                }
                catch (Exception e) {
                    throw new DataStoreException(e);
                }
            }
            finally {
                super.close();
            }
        }
    }
}

