/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.referencing.operation.provider;

import jakarta.xml.bind.annotation.XmlTransient;
import org.apache.sis.measure.Units;
import org.apache.sis.metadata.iso.citation.Citations;
import org.apache.sis.parameter.ParameterBuilder;
import org.apache.sis.parameter.Parameters;
import org.apache.sis.referencing.operation.provider.AbstractProvider;
import org.apache.sis.referencing.operation.provider.SouthPoleRotation;
import org.apache.sis.referencing.operation.transform.PoleRotation;
import org.opengis.metadata.citation.Citation;
import org.opengis.parameter.GeneralParameterDescriptor;
import org.opengis.parameter.ParameterDescriptor;
import org.opengis.parameter.ParameterDescriptorGroup;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.IdentifiedObject;
import org.opengis.referencing.cs.EllipsoidalCS;
import org.opengis.referencing.operation.Conversion;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.MathTransformFactory;
import org.opengis.util.FactoryException;

@XmlTransient
public final class NorthPoleRotation
extends AbstractProvider {
    private static final long serialVersionUID = 3485083285768740448L;
    private static final ParameterDescriptor<Double> POLE_LATITUDE;
    private static final ParameterDescriptor<Double> POLE_LONGITUDE;
    private static final ParameterDescriptor<Double> AXIS_ANGLE;
    public static final ParameterDescriptorGroup PARAMETERS;

    public NorthPoleRotation() {
        super(Conversion.class, PARAMETERS, EllipsoidalCS.class, false, EllipsoidalCS.class, false);
    }

    @Override
    public MathTransform createMathTransform(MathTransformFactory factory, ParameterValueGroup parameters) throws FactoryException {
        Parameters p = Parameters.castOrWrap(parameters);
        return PoleRotation.rotateNorthPole(factory, p.getValue(POLE_LATITUDE), p.getValue(POLE_LONGITUDE), p.getValue(AXIS_ANGLE));
    }

    static {
        ParameterBuilder builder = ((ParameterBuilder)new ParameterBuilder().setCodeSpace((Citation)Citations.NETCDF, "NetCDF")).setRequired(true);
        POLE_LATITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addNameAndIdentifier(Citations.SIS, (IdentifiedObject)SouthPoleRotation.POLE_LATITUDE)).addName("grid_north_pole_latitude")).createBounded(-90.0, 90.0, Double.NaN, Units.DEGREE);
        POLE_LONGITUDE = ((ParameterBuilder)((ParameterBuilder)builder.addNameAndIdentifier(Citations.SIS, (IdentifiedObject)SouthPoleRotation.POLE_LONGITUDE)).addName("grid_north_pole_longitude")).createBounded(-180.0, 180.0, Double.NaN, Units.DEGREE);
        AXIS_ANGLE = ((ParameterBuilder)((ParameterBuilder)builder.setRequired(false).addNameAndIdentifier(Citations.SIS, (IdentifiedObject)SouthPoleRotation.AXIS_ANGLE)).addName("north_pole_grid_longitude")).createBounded(-180.0, 180.0, 0.0, Units.DEGREE);
        PARAMETERS = ((ParameterBuilder)((ParameterBuilder)builder.setRequired(true).addName(Citations.SIS, "North pole rotation")).addName("rotated_latitude_longitude")).createGroup(new GeneralParameterDescriptor[]{POLE_LATITUDE, POLE_LONGITUDE, AXIS_ANGLE});
    }
}

