/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tasks;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.Enumeration;
import java.util.StringJoiner;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.apache.baremaps.workflow.Task;
import org.apache.baremaps.workflow.WorkflowContext;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DecompressFile
implements Task {
    private static final Logger logger = LoggerFactory.getLogger(DecompressFile.class);
    private Path source;
    private Path target;
    private Compression compression;

    public DecompressFile() {
    }

    public DecompressFile(Path source, Path target, Compression compression) {
        this.source = source;
        this.target = target;
        this.compression = compression;
    }

    @Override
    public void execute(WorkflowContext context) throws Exception {
        Path sourcePath = this.source.toAbsolutePath();
        Path targetPath = this.target.toAbsolutePath();
        switch (this.compression) {
            case ZIP: {
                DecompressFile.decompressZip(sourcePath, targetPath);
                break;
            }
            case TARGZ: {
                DecompressFile.decompressTarGz(sourcePath, targetPath);
                break;
            }
            case TARBZ2: {
                DecompressFile.decompressTarBz2(sourcePath, targetPath);
                break;
            }
            case GZIP: {
                DecompressFile.decompressGzip(sourcePath, targetPath);
                break;
            }
            case BZIP2: {
                DecompressFile.decompressBzip2(sourcePath, targetPath);
            }
        }
    }

    protected static void decompressBzip2(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             BZip2CompressorInputStream bzip2InputStream = new BZip2CompressorInputStream((InputStream)bufferedInputStream);){
            Files.copy((InputStream)bzip2InputStream, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static void decompressGzip(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             GZIPInputStream zis = new GZIPInputStream(bufferedInputStream);){
            Files.copy(zis, target, StandardCopyOption.REPLACE_EXISTING);
        }
    }

    protected static void decompressTarGz(Path source, Path target) throws IOException {
        Files.createDirectories(target.getParent(), new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             GZIPInputStream gzipInputStream = new GZIPInputStream(bufferedInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)gzipInputStream);){
            DecompressFile.decompressTar(target, tarInputStream);
        }
    }

    protected static void decompressTarBz2(Path source, Path target) throws IOException {
        Files.createDirectories(target, new FileAttribute[0]);
        try (BufferedInputStream bufferedInputStream = new BufferedInputStream(Files.newInputStream(source, new OpenOption[0]));
             BZip2CompressorInputStream bzip2InputStream = new BZip2CompressorInputStream((InputStream)bufferedInputStream);
             TarArchiveInputStream tarInputStream = new TarArchiveInputStream((InputStream)bzip2InputStream);){
            DecompressFile.decompressTar(target, tarInputStream);
        }
    }

    public static void decompressTar(Path target, TarArchiveInputStream tarInputStream) throws IOException {
        TarArchiveEntry entry;
        while ((entry = tarInputStream.getNextEntry()) != null) {
            String canonicalTargetPath;
            File destination = target.resolve(entry.getName()).normalize().toFile();
            String canonicalDestinationPath = destination.getCanonicalPath();
            if (canonicalDestinationPath.startsWith(canonicalTargetPath = target.toFile().getCanonicalPath())) {
                if (entry.isDirectory()) {
                    Files.createDirectories(destination.toPath(), new FileAttribute[0]);
                    continue;
                }
                Files.createDirectories(destination.toPath().getParent(), new FileAttribute[0]);
                BufferedOutputStream outputStream = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                try {
                    tarInputStream.transferTo((OutputStream)outputStream);
                    continue;
                }
                finally {
                    outputStream.close();
                    continue;
                }
            }
            throw new IOException("Entry is outside of the target directory");
        }
    }

    protected static void decompressZip(Path source, Path target) throws IOException {
        try (ZipFile zipFile = new ZipFile(source.toFile());){
            Enumeration<? extends ZipEntry> entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                String canonicalTargetPath;
                ZipEntry entry = entries.nextElement();
                File destination = target.resolve(entry.getName()).normalize().toFile();
                String canonicalDestinationPath = destination.getCanonicalPath();
                if (canonicalDestinationPath.startsWith(canonicalTargetPath = target.toFile().getCanonicalPath())) {
                    if (entry.isDirectory()) {
                        Files.createDirectories(destination.toPath(), new FileAttribute[0]);
                        continue;
                    }
                    Files.createDirectories(destination.toPath().getParent(), new FileAttribute[0]);
                    BufferedInputStream input = new BufferedInputStream(zipFile.getInputStream(entry));
                    try {
                        BufferedOutputStream output = new BufferedOutputStream(Files.newOutputStream(destination.toPath(), StandardOpenOption.CREATE, StandardOpenOption.TRUNCATE_EXISTING));
                        try {
                            input.transferTo(output);
                            continue;
                        }
                        finally {
                            output.close();
                            continue;
                        }
                    }
                    finally {
                        input.close();
                        continue;
                    }
                }
                throw new IOException("Entry is outside of the target directory");
            }
        }
    }

    public String toString() {
        return new StringJoiner(", ", DecompressFile.class.getSimpleName() + "[", "]").add("source=" + String.valueOf(this.source)).add("target=" + String.valueOf(this.target)).add("compression=" + String.valueOf((Object)this.compression)).toString();
    }

    public static enum Compression {
        ZIP,
        TARGZ,
        TARBZ2,
        GZIP,
        BZIP2;

    }
}

