/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.file;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.TileStore;
import org.apache.baremaps.tilestore.TileStoreException;

public class FileTileStore
implements TileStore<ByteBuffer> {
    private final Path path;

    public FileTileStore(Path path) {
        this.path = path;
    }

    @Override
    public ByteBuffer read(TileCoord tileCoord) throws TileStoreException {
        try {
            return ByteBuffer.wrap(Files.readAllBytes(this.resolve(tileCoord)));
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void write(TileCoord tileCoord, ByteBuffer blob) throws TileStoreException {
        try {
            Path file = this.resolve(tileCoord);
            Files.createDirectories(file.getParent(), new FileAttribute[0]);
            Files.write(file, blob.array(), new OpenOption[0]);
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    @Override
    public void delete(TileCoord tileCoord) throws TileStoreException {
        try {
            Files.deleteIfExists(this.resolve(tileCoord));
        }
        catch (IOException e) {
            throw new TileStoreException(e);
        }
    }

    public Path resolve(TileCoord tileCoord) {
        return this.path.resolve(String.format("%s/%s/%s.mvt", tileCoord.z(), tileCoord.x(), tileCoord.y()));
    }

    @Override
    public void close() {
    }
}

