/*
 * Decompiled with CFR 0.152.
 */
package org.apache.baremaps.tilestore.raster;

import java.awt.image.RenderedImage;
import java.nio.file.Path;
import java.util.Collection;
import org.apache.baremaps.tilestore.TileCoord;
import org.apache.baremaps.tilestore.raster.BicubicInterpolation;
import org.apache.baremaps.tilestore.raster.GeoTiffException;
import org.apache.sis.coverage.grid.GridCoverage;
import org.apache.sis.coverage.grid.GridCoverageProcessor;
import org.apache.sis.coverage.grid.GridExtent;
import org.apache.sis.coverage.grid.GridGeometry;
import org.apache.sis.coverage.grid.GridOrientation;
import org.apache.sis.geometry.Envelopes;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.image.ImageProcessor;
import org.apache.sis.image.Interpolation;
import org.apache.sis.referencing.CRS;
import org.apache.sis.referencing.CommonCRS;
import org.apache.sis.storage.Aggregate;
import org.apache.sis.storage.DataStore;
import org.apache.sis.storage.DataStoreException;
import org.apache.sis.storage.DataStores;
import org.apache.sis.storage.GridCoverageResource;
import org.apache.sis.storage.RasterLoadingStrategy;
import org.locationtech.jts.geom.Envelope;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;
import org.opengis.util.FactoryException;

public class GeoTiffReader
implements AutoCloseable {
    private static final CoordinateReferenceSystem WEB_MERCATOR;
    private final DataStore dataStore;
    private final GridCoverage gridCoverage;

    public GeoTiffReader(Path path) throws GeoTiffException {
        try {
            this.dataStore = DataStores.open((Object)path);
            Collection allImages = ((Aggregate)this.dataStore).components();
            GridCoverageResource firstImage = (GridCoverageResource)allImages.iterator().next();
            firstImage.setLoadingStrategy(RasterLoadingStrategy.AT_GET_TILE_TIME);
            this.gridCoverage = firstImage.read(null, new int[0]);
        }
        catch (DataStoreException e) {
            throw new GeoTiffException(e);
        }
    }

    public double[] read(TileCoord tileCoord, int tileSizePx, int tileBufferPx) throws GeoTiffException {
        try {
            int imageSize = tileSizePx + 2 * tileBufferPx;
            Envelope tileEnvelope = tileCoord.envelope();
            double tileWidth = tileEnvelope.getWidth();
            double tileHeight = tileEnvelope.getHeight();
            double pixelWidth = tileWidth / (double)tileSizePx;
            double pixelHeight = tileHeight / (double)tileSizePx;
            tileEnvelope.expandBy(pixelWidth * (double)tileBufferPx, pixelHeight * (double)tileBufferPx);
            GeneralEnvelope sourceEnvelope = new GeneralEnvelope((CoordinateReferenceSystem)CommonCRS.WGS84.normalizedGeographic());
            sourceEnvelope.setRange(0, tileEnvelope.getMinX(), tileEnvelope.getMaxX());
            sourceEnvelope.setRange(1, tileEnvelope.getMinY(), tileEnvelope.getMaxY());
            org.opengis.geometry.Envelope targetEnvelope = Envelopes.transform((org.opengis.geometry.Envelope)sourceEnvelope, (CoordinateReferenceSystem)WEB_MERCATOR);
            GridExtent targetSize = new GridExtent((long)imageSize, (long)imageSize);
            GridGeometry targetGridGeometry = new GridGeometry(targetSize, targetEnvelope, GridOrientation.DISPLAY);
            GridCoverageProcessor gridCoverageProcessor = new GridCoverageProcessor();
            gridCoverageProcessor.setInterpolation((Interpolation)new BicubicInterpolation());
            GridCoverage tileGridCoverage = gridCoverageProcessor.resample(this.gridCoverage, targetGridGeometry);
            RenderedImage renderedImage = tileGridCoverage.render(null);
            ImageProcessor imageProcessor = new ImageProcessor();
            renderedImage = imageProcessor.prefetch(renderedImage, null);
            double[] values = new double[renderedImage.getWidth() * renderedImage.getHeight()];
            renderedImage.getData().getPixels(0, 0, renderedImage.getWidth(), renderedImage.getHeight(), values);
            return values;
        }
        catch (TransformException e) {
            throw new GeoTiffException(e);
        }
    }

    @Override
    public void close() throws Exception {
        this.dataStore.close();
    }

    static {
        try {
            WEB_MERCATOR = CRS.fromWKT((String)"ProjectedCRS[\"WGS 84 / Pseudo-Mercator\",\n  BaseGeodCRS[\"WGS 84\",\n    Datum[\"World Geodetic System 1984\",\n      Ellipsoid[\"WGS 84\", 6378137.0, 298.257223563]],\n    Unit[\"degree\", 0.017453292519943295]],\n  Conversion[\"Popular Visualisation Pseudo-Mercator\",\n    Method[\"Popular Visualisation Pseudo Mercator\"]],\n  CS[Cartesian, 2],\n    Axis[\"Easting (X)\", east],\n    Axis[\"Northing (Y)\", north],\n    Unit[\"metre\", 1],\n  Scope[\"Certain Web mapping and visualisation applications.\"],\n  Id[\"EPSG\", 3857]]\n");
        }
        catch (FactoryException e) {
            throw new IllegalArgumentException(e);
        }
    }
}

