/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.config;

import aQute.bnd.annotation.spi.ServiceConsumer;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.Appender;
import org.apache.logging.log4j.core.Core;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.LifeCycle;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.Logger;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.Version;
import org.apache.logging.log4j.core.appender.AsyncAppender;
import org.apache.logging.log4j.core.appender.ConsoleAppender;
import org.apache.logging.log4j.core.config.AppenderRef;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationAwarePostProcessor;
import org.apache.logging.log4j.core.config.ConfigurationExtension;
import org.apache.logging.log4j.core.config.ConfigurationFileWatcher;
import org.apache.logging.log4j.core.config.ConfigurationProcessor;
import org.apache.logging.log4j.core.config.ConfigurationScheduler;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.CustomLevelConfig;
import org.apache.logging.log4j.core.config.CustomLevels;
import org.apache.logging.log4j.core.config.DefaultAdvertiser;
import org.apache.logging.log4j.core.config.LoggerConfig;
import org.apache.logging.log4j.core.config.Loggers;
import org.apache.logging.log4j.core.config.Reconfigurable;
import org.apache.logging.log4j.core.config.ReliabilityStrategy;
import org.apache.logging.log4j.core.config.ReliabilityStrategyFactory;
import org.apache.logging.log4j.core.config.Scheduled;
import org.apache.logging.log4j.core.config.arbiters.Arbiter;
import org.apache.logging.log4j.core.config.arbiters.SelectArbiter;
import org.apache.logging.log4j.core.filter.AbstractFilterable;
import org.apache.logging.log4j.core.impl.Log4jPropertyKey;
import org.apache.logging.log4j.core.layout.PatternLayout;
import org.apache.logging.log4j.core.lookup.ConfigurationStrSubstitutor;
import org.apache.logging.log4j.core.lookup.Interpolator;
import org.apache.logging.log4j.core.lookup.InterpolatorFactory;
import org.apache.logging.log4j.core.lookup.PropertiesLookup;
import org.apache.logging.log4j.core.lookup.RuntimeStrSubstitutor;
import org.apache.logging.log4j.core.lookup.StrLookup;
import org.apache.logging.log4j.core.lookup.StrSubstitutor;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.core.script.ScriptManager;
import org.apache.logging.log4j.core.script.ScriptManagerFactory;
import org.apache.logging.log4j.core.time.NanoClock;
import org.apache.logging.log4j.core.util.Constants;
import org.apache.logging.log4j.core.util.Source;
import org.apache.logging.log4j.core.util.WatchManager;
import org.apache.logging.log4j.core.util.Watcher;
import org.apache.logging.log4j.core.util.WatcherFactory;
import org.apache.logging.log4j.plugins.Inject;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Node;
import org.apache.logging.log4j.plugins.di.ConfigurableInstanceFactory;
import org.apache.logging.log4j.plugins.di.DI;
import org.apache.logging.log4j.plugins.di.Key;
import org.apache.logging.log4j.plugins.di.spi.InstancePostProcessor;
import org.apache.logging.log4j.plugins.di.spi.StringValueResolver;
import org.apache.logging.log4j.plugins.model.PluginNamespace;
import org.apache.logging.log4j.plugins.model.PluginType;
import org.apache.logging.log4j.util.Cast;
import org.apache.logging.log4j.util.Lazy;
import org.apache.logging.log4j.util.NameUtil;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.PropertyEnvironment;
import org.apache.logging.log4j.util.PropertyKey;
import org.apache.logging.log4j.util.ServiceLoaderUtil;

@ServiceConsumer(value=ScriptManagerFactory.class, cardinality="single", resolution="optional")
public abstract class AbstractConfiguration
extends AbstractFilterable
implements Configuration {
    private static final List<String> EXPECTED_ELEMENTS = List.of("\"Appenders\"", "\"Loggers\"", "\"Properties\"", "\"Scripts\"", "\"CustomLevels\"");
    protected final ConfigurableInstanceFactory instanceFactory;
    protected final ConfigurationProcessor configurationProcessor;
    protected Node rootNode = new Node();
    protected final List<Consumer<Reconfigurable>> listeners = new CopyOnWriteArrayList<Consumer<Reconfigurable>>();
    protected PluginNamespace corePlugins;
    protected boolean isShutdownHookEnabled = true;
    protected long shutdownTimeoutMillis;
    protected ScriptManager scriptManager;
    private Advertiser advertiser = new DefaultAdvertiser();
    private Node advertiserNode;
    private Object advertisement;
    private String name;
    private ConcurrentMap<String, Appender> appenders = new ConcurrentHashMap<String, Appender>();
    private ConcurrentMap<String, LoggerConfig> loggerConfigs = new ConcurrentHashMap<String, LoggerConfig>();
    private List<CustomLevelConfig> customLevels = List.of();
    private final ConcurrentMap<String, String> properties = new ConcurrentHashMap<String, String>();
    private final InterpolatorFactory interpolatorFactory;
    private final Interpolator tempLookup;
    private final StrSubstitutor runtimeStrSubstitutor;
    private final StrSubstitutor configurationStrSubstitutor;
    private LoggerConfig root = new LoggerConfig();
    private final ConcurrentMap<String, Object> componentMap = new ConcurrentHashMap<String, Object>();
    private final ConfigurationSource configurationSource;
    private final ConfigurationScheduler configurationScheduler;
    private final WatchManager watchManager;
    private final WeakReference<LoggerContext> loggerContext;
    private final PropertyEnvironment contextProperties;
    private final Lock configLock = new ReentrantLock();
    private final List<ConfigurationExtension> extensions = new CopyOnWriteArrayList<ConfigurationExtension>();

    protected AbstractConfiguration(LoggerContext loggerContext, ConfigurationSource configurationSource) {
        this.loggerContext = new WeakReference<LoggerContext>(loggerContext);
        this.configurationSource = Objects.requireNonNull(configurationSource, "configurationSource is null");
        if (loggerContext != null) {
            this.instanceFactory = loggerContext.newChildInstanceFactory();
            this.contextProperties = loggerContext.getProperties();
        } else {
            this.instanceFactory = DI.createInitializedFactory();
            this.contextProperties = PropertiesUtil.getProperties();
        }
        this.configurationProcessor = new ConfigurationProcessor(this.instanceFactory);
        Lazy ref = Lazy.weak((Object)this);
        this.instanceFactory.registerBinding(Configuration.KEY, (Supplier)ref);
        this.instanceFactory.registerInstancePostProcessor((InstancePostProcessor)new ConfigurationAwarePostProcessor((Supplier<? extends Configuration>)ref));
        this.componentMap.put("ContextProperties", this.properties);
        this.interpolatorFactory = (InterpolatorFactory)this.instanceFactory.getInstance(InterpolatorFactory.class);
        this.tempLookup = this.interpolatorFactory.newInterpolator(new PropertiesLookup(this.properties));
        this.instanceFactory.injectMembers((Object)this.tempLookup);
        this.runtimeStrSubstitutor = new RuntimeStrSubstitutor(this.tempLookup);
        this.configurationStrSubstitutor = new ConfigurationStrSubstitutor(this.runtimeStrSubstitutor);
        this.configurationScheduler = (ConfigurationScheduler)this.instanceFactory.getInstance(ConfigurationScheduler.class);
        this.watchManager = (WatchManager)this.instanceFactory.getInstance(WatchManager.class);
        this.setState(LifeCycle.State.INITIALIZING);
    }

    @Override
    public ConfigurationSource getConfigurationSource() {
        return this.configurationSource;
    }

    @Override
    public Map<String, String> getProperties() {
        return this.properties;
    }

    @Override
    public PropertyEnvironment getContextProperties() {
        return this.contextProperties;
    }

    @Override
    public ScriptManager getScriptManager() {
        return this.scriptManager;
    }

    @Inject
    public void setScriptManager(ScriptManager scriptManager) {
        this.scriptManager = scriptManager;
        this.instanceFactory.registerBinding(ScriptManager.KEY, this::getScriptManager);
    }

    public PluginNamespace getCorePlugins() {
        return this.corePlugins;
    }

    @Inject
    public void setCorePlugins(@Namespace(value="Core") @Namespace(value="Core") PluginNamespace corePlugins) {
        this.corePlugins = corePlugins;
        this.instanceFactory.registerBinding(Core.PLUGIN_NAMESPACE_KEY, this::getCorePlugins);
    }

    @Override
    public WatchManager getWatchManager() {
        return this.watchManager;
    }

    @Override
    public ConfigurationScheduler getScheduler() {
        return this.configurationScheduler;
    }

    public Node getRootNode() {
        return this.rootNode;
    }

    @Override
    public void initialize() {
        LOGGER.debug("{} initializing configuration {}", (Object)Version.getProductString(), (Object)this);
        this.runtimeStrSubstitutor.setConfiguration(this);
        this.configurationStrSubstitutor.setConfiguration(this);
        this.initializeScriptManager();
        this.corePlugins = (PluginNamespace)this.instanceFactory.getInstance(Core.PLUGIN_NAMESPACE_KEY);
        PluginNamespace levelPlugins = (PluginNamespace)this.instanceFactory.getInstance((Key)new Key<PluginNamespace>(){});
        levelPlugins.forEach(type -> {
            Class pluginClass = type.getPluginClass();
            try {
                Class.forName(pluginClass.getName(), true, pluginClass.getClassLoader());
            }
            catch (Exception e) {
                LOGGER.error("Unable to initialize {} due to {}", (Object)pluginClass.getName(), (Object)e.getClass().getSimpleName(), (Object)e);
            }
        });
        this.setup();
        this.setupAdvertisement();
        this.doConfigure();
        this.setState(LifeCycle.State.INITIALIZED);
        LOGGER.debug("Configuration {} initialized", (Object)this);
    }

    private void initializeScriptManager() {
        try {
            ServiceLoaderUtil.safeStream(ServiceLoader.load(ScriptManagerFactory.class, AbstractConfiguration.class.getClassLoader())).findFirst().ifPresent(factory -> this.setScriptManager(factory.createScriptManager(this, this.getWatchManager())));
        }
        catch (Exception | LinkageError e) {
            LOGGER.info("Cannot initialize scripting support because this JRE does not support it.", e);
        }
    }

    protected void initializeWatchers(Reconfigurable reconfigurable, ConfigurationSource configSource, int monitorIntervalSeconds) {
        if (configSource != null && (configSource.getFile() != null || configSource.getURL() != null)) {
            if (monitorIntervalSeconds > 0) {
                this.watchManager.setIntervalSeconds(monitorIntervalSeconds);
                if (configSource.getFile() != null) {
                    Source cfgSource = new Source(configSource);
                    long lastModified = configSource.getFile().lastModified();
                    ConfigurationFileWatcher watcher = new ConfigurationFileWatcher(this, reconfigurable, this.listeners, lastModified);
                    this.watchManager.watch(cfgSource, watcher);
                } else if (configSource.getURL() != null) {
                    this.monitorSource(reconfigurable, configSource);
                }
            } else if (this.watchManager.hasEventListeners() && configSource.getURL() != null && monitorIntervalSeconds >= 0) {
                this.monitorSource(reconfigurable, configSource);
            }
        }
    }

    private void monitorSource(Reconfigurable reconfigurable, ConfigurationSource configSource) {
        if (configSource.getLastModified() > 0L) {
            Source cfgSource = new Source(configSource);
            Watcher watcher = ((WatcherFactory)this.instanceFactory.getInstance(WatcherFactory.class)).newWatcher(cfgSource, this, reconfigurable, this.listeners, configSource.getLastModified());
            if (watcher != null) {
                this.watchManager.watch(cfgSource, watcher);
            }
        } else {
            LOGGER.info("{} does not support dynamic reconfiguration", (Object)configSource.getURI());
        }
    }

    @Override
    public void start() {
        if (this.getState().equals((Object)LifeCycle.State.INITIALIZING)) {
            this.initialize();
        }
        LOGGER.debug("Starting configuration {}", (Object)this);
        this.setStarting();
        if (this.watchManager.getIntervalSeconds() >= 0) {
            this.watchManager.start();
        }
        for (ConfigurationExtension extension : this.extensions) {
            if (!(extension instanceof LifeCycle)) continue;
            LifeCycle lifecycle = (LifeCycle)((Object)extension);
            lifecycle.start();
        }
        HashSet<LoggerConfig> alreadyStarted = new HashSet<LoggerConfig>();
        for (LoggerConfig logger : this.loggerConfigs.values()) {
            logger.start();
            alreadyStarted.add(logger);
        }
        for (Appender appender : this.appenders.values()) {
            appender.start();
        }
        if (!alreadyStarted.contains(this.root)) {
            this.root.start();
        }
        super.start();
        LOGGER.debug("Started configuration {} OK.", (Object)this);
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        super.stop(timeout, timeUnit, false);
        LOGGER.trace("Stopping {}...", (Object)this);
        for (Iterator loggerConfig : this.loggerConfigs.values()) {
            ((LoggerConfig)((Object)loggerConfig)).getReliabilityStrategy().beforeStopConfiguration(this);
        }
        this.root.getReliabilityStrategy().beforeStopConfiguration(this);
        String cls = this.getClass().getSimpleName();
        LOGGER.trace("{} notified {} ReliabilityStrategies that config will be stopped.", (Object)cls, (Object)(this.loggerConfigs.size() + 1));
        if (!this.loggerConfigs.isEmpty()) {
            LOGGER.trace("{} stopping {} LoggerConfigs.", (Object)cls, (Object)this.loggerConfigs.size());
            for (LoggerConfig logger : this.loggerConfigs.values()) {
                logger.stop(timeout, timeUnit);
            }
        }
        LOGGER.trace("{} stopping root LoggerConfig.", (Object)cls);
        if (!this.root.isStopped()) {
            this.root.stop(timeout, timeUnit);
        }
        for (ConfigurationExtension extension : this.extensions) {
            if (!(extension instanceof LifeCycle)) continue;
            LifeCycle lifecycle = (LifeCycle)((Object)extension);
            lifecycle.stop(timeout, timeUnit);
        }
        LOGGER.trace("{} notifying ReliabilityStrategies that appenders will be stopped.", (Object)cls);
        for (LoggerConfig loggerConfig : this.loggerConfigs.values()) {
            loggerConfig.getReliabilityStrategy().beforeStopAppenders();
        }
        this.root.getReliabilityStrategy().beforeStopAppenders();
        Appender[] array = this.appenders.values().toArray(Appender.EMPTY_ARRAY);
        List<Appender> async = this.getAsyncAppenders(array);
        if (!async.isEmpty()) {
            LOGGER.trace("{} stopping {} AsyncAppenders.", (Object)cls, (Object)async.size());
            for (Appender appender : async) {
                appender.stop(timeout, timeUnit);
            }
        }
        LOGGER.trace("{} stopping remaining Appenders.", (Object)cls);
        int appenderCount = 0;
        for (int i = array.length - 1; i >= 0; --i) {
            if (!array[i].isStarted()) continue;
            array[i].stop(timeout, timeUnit);
            ++appenderCount;
        }
        LOGGER.trace("{} stopped {} remaining Appenders.", (Object)cls, (Object)appenderCount);
        LOGGER.trace("{} cleaning Appenders from {} LoggerConfigs.", (Object)cls, (Object)(this.loggerConfigs.size() + 1));
        for (LoggerConfig loggerConfig : this.loggerConfigs.values()) {
            loggerConfig.clearAppenders();
        }
        this.root.clearAppenders();
        if (this.watchManager.isStarted()) {
            this.watchManager.stop(timeout, timeUnit);
        }
        this.configurationScheduler.stop(timeout, timeUnit);
        if (this.advertiser != null && this.advertisement != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        LOGGER.debug("Stopped {} OK", (Object)this);
        return true;
    }

    private List<Appender> getAsyncAppenders(Appender[] all) {
        ArrayList<Appender> result = new ArrayList<Appender>();
        for (int i = all.length - 1; i >= 0; --i) {
            if (!(all[i] instanceof AsyncAppender)) continue;
            result.add(all[i]);
        }
        return result;
    }

    @Override
    public boolean isShutdownHookEnabled() {
        return this.isShutdownHookEnabled;
    }

    @Override
    public long getShutdownTimeoutMillis() {
        return this.shutdownTimeoutMillis;
    }

    public void setup() {
    }

    protected Level getDefaultStatus() {
        return (Level)this.instanceFactory.getInstance(Constants.DEFAULT_STATUS_LEVEL_KEY);
    }

    protected void createAdvertiser(String advertiserString, ConfigurationSource configSource, byte[] buffer, String contentType) {
        if (advertiserString != null) {
            Node node = new Node(null, advertiserString, null);
            Map attributes = node.getAttributes();
            attributes.put("content", new String(buffer));
            attributes.put("contentType", contentType);
            attributes.put("name", "configuration");
            if (configSource.getLocation() != null) {
                attributes.put("location", configSource.getLocation());
            }
            this.advertiserNode = node;
        }
    }

    private void setupAdvertisement() {
        String nodeName;
        PluginType type;
        if (this.advertiserNode != null && (type = this.corePlugins.get(nodeName = this.advertiserNode.getName())) != null) {
            this.advertiser = (Advertiser)this.instanceFactory.getInstance(type.getPluginClass().asSubclass(Advertiser.class));
            this.advertisement = this.advertiser.advertise(this.advertiserNode.getAttributes());
        }
    }

    @Override
    public <T> T getComponent(String componentName) {
        return (T)Cast.cast(this.componentMap.get(componentName));
    }

    @Override
    public <T> Supplier<T> getFactory(Key<T> key) {
        return this.instanceFactory.getFactory(key);
    }

    @Override
    public void addComponent(String componentName, Object obj) {
        this.componentMap.putIfAbsent(componentName, obj);
    }

    protected void preConfigure(Node node) {
        try {
            for (Node child : node.getChildren()) {
                if (child.getType() == null) {
                    LOGGER.error("Unable to locate plugin type for {}", (Object)child.getName());
                    continue;
                }
                Class clazz = child.getType().getPluginClass();
                if (clazz.isAnnotationPresent(Scheduled.class)) {
                    this.configurationScheduler.incrementScheduledItems();
                }
                this.preConfigure(child);
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error capturing node data for node {}", (Object)node.getName(), (Object)ex);
        }
    }

    protected void processConditionals(Node node) {
        try {
            ArrayList<Node> addList = new ArrayList<Node>();
            ArrayList<Node> removeList = new ArrayList<Node>();
            for (Node child : node.getChildren()) {
                PluginType type = child.getType();
                if (type != null && "Arbiter".equals(type.getElementType())) {
                    Class clazz = type.getPluginClass();
                    if (SelectArbiter.class.isAssignableFrom(clazz)) {
                        removeList.add(child);
                        addList.addAll(this.processSelect(child, type));
                        continue;
                    }
                    if (Arbiter.class.isAssignableFrom(clazz)) {
                        removeList.add(child);
                        try {
                            Arbiter condition = (Arbiter)this.configurationProcessor.processNodeTree(child);
                            if (!condition.isCondition()) continue;
                            addList.addAll(child.getChildren());
                            this.processConditionals(child);
                        }
                        catch (Exception inner) {
                            LOGGER.error("Exception processing {}: Ignoring and including children", (Object)type.getPluginClass());
                            this.processConditionals(child);
                        }
                        continue;
                    }
                    LOGGER.error("Encountered Condition Plugin that does not implement Condition: {}", (Object)child.getName());
                    this.processConditionals(child);
                    continue;
                }
                this.processConditionals(child);
            }
            if (!removeList.isEmpty()) {
                List children = node.getChildren();
                children.removeAll(removeList);
                children.addAll(addList);
                for (Node grandChild : addList) {
                    grandChild.setParent(node);
                }
            }
        }
        catch (Exception ex) {
            LOGGER.error("Error capturing node data for node {}", (Object)node.getName(), (Object)ex);
        }
    }

    protected List<Node> processSelect(Node selectNode, PluginType<?> type) {
        ArrayList<Node> addList = new ArrayList<Node>();
        SelectArbiter select = (SelectArbiter)this.configurationProcessor.processNodeTree(selectNode);
        ArrayList<Arbiter> conditions = new ArrayList<Arbiter>();
        for (Node child : selectNode.getChildren()) {
            PluginType nodeType = child.getType();
            if (nodeType != null) {
                if (Arbiter.class.isAssignableFrom(nodeType.getPluginClass())) {
                    Arbiter condition = (Arbiter)this.configurationProcessor.processNodeTree(child);
                    conditions.add(condition);
                    continue;
                }
                LOGGER.error("Invalid Node {} for Select. Must be a Condition", (Object)child.getName());
                continue;
            }
            LOGGER.error("No PluginType for node {}", (Object)child.getName());
        }
        Arbiter condition = select.evaluateConditions(conditions);
        if (condition != null) {
            for (Node child : selectNode.getChildren()) {
                if (condition != child.getObject()) continue;
                addList.addAll(child.getChildren());
                this.processConditionals(child);
            }
        }
        return addList;
    }

    protected void doConfigure() {
        this.instanceFactory.registerBinding(StringValueResolver.KEY, this::getConfigurationStrSubstitutor);
        this.processConditionals(this.rootNode);
        this.preConfigure(this.rootNode);
        this.configurationScheduler.start();
        boolean hasProperties = false;
        for (Node node : this.rootNode.getChildren()) {
            if (!"Properties".equalsIgnoreCase(node.getName())) continue;
            hasProperties = true;
            this.createConfiguration(node, null);
            if (node.getObject() == null) break;
            StrLookup lookup = (StrLookup)node.getObject();
            this.runtimeStrSubstitutor.setVariableResolver(lookup);
            this.configurationStrSubstitutor.setVariableResolver(lookup);
            break;
        }
        if (!hasProperties) {
            Map map = (Map)this.getComponent("ContextProperties");
            PropertiesLookup lookup = map == null ? null : new PropertiesLookup(map);
            Interpolator interpolator = this.interpolatorFactory.newInterpolator(lookup);
            this.instanceFactory.injectMembers((Object)interpolator);
            this.runtimeStrSubstitutor.setVariableResolver(interpolator);
            this.configurationStrSubstitutor.setVariableResolver(interpolator);
        }
        boolean setLoggers = false;
        boolean setRoot = false;
        for (Node node : this.rootNode.getChildren()) {
            if ("Properties".equalsIgnoreCase(node.getName())) {
                if (this.tempLookup != this.runtimeStrSubstitutor.getVariableResolver()) continue;
                LOGGER.error("Properties declaration must be the first element in the configuration");
                continue;
            }
            this.createConfiguration(node, null);
            if (node.getObject() == null) {
                LOGGER.warn("Configuration element \"{}\" is ignored: try nesting it inside one of: {}.", (Object)node.getName(), EXPECTED_ELEMENTS);
                continue;
            }
            if ("Scripts".equalsIgnoreCase(node.getName())) {
                if (this.scriptManager == null) continue;
                this.scriptManager.addScripts(node);
                continue;
            }
            if ("Appenders".equalsIgnoreCase(node.getName())) {
                this.appenders = (ConcurrentMap)node.getObject();
                continue;
            }
            if (node.isInstanceOf(Filter.class)) {
                this.addFilter((Filter)node.getObject(Filter.class));
                continue;
            }
            if (node.isInstanceOf(Loggers.class)) {
                Loggers l = (Loggers)node.getObject(Loggers.class);
                this.loggerConfigs = l.getMap();
                setLoggers = true;
                if (l.getRoot() == null) continue;
                this.root = l.getRoot();
                setRoot = true;
                continue;
            }
            if (node.isInstanceOf(CustomLevels.class)) {
                this.customLevels = ((CustomLevels)node.getObject(CustomLevels.class)).getCustomLevels();
                continue;
            }
            if (node.isInstanceOf(CustomLevelConfig.class)) {
                ArrayList<CustomLevelConfig> copy = new ArrayList<CustomLevelConfig>(this.customLevels);
                copy.add((CustomLevelConfig)node.getObject(CustomLevelConfig.class));
                this.customLevels = copy;
                continue;
            }
            if (node.isInstanceOf(ConfigurationExtension.class)) {
                this.addExtension((ConfigurationExtension)node.getObject(ConfigurationExtension.class));
                continue;
            }
            LOGGER.error("Unknown object \"{}\" of type {} is ignored: try nesting it inside one of: {}.", (Object)node.getName(), (Object)node.getObject().getClass().getName(), EXPECTED_ELEMENTS);
        }
        if (!setLoggers) {
            LOGGER.warn("No Loggers were configured, using default. Is the Loggers element missing?");
            this.setToDefault();
            return;
        }
        if (!setRoot) {
            LOGGER.warn("No Root logger was configured, creating default ERROR-level Root logger with Console appender");
            this.setToDefault();
        }
        for (Map.Entry entry : this.loggerConfigs.entrySet()) {
            LoggerConfig loggerConfig = (LoggerConfig)entry.getValue();
            for (AppenderRef ref : loggerConfig.getAppenderRefs()) {
                Appender app = (Appender)this.appenders.get(ref.getRef());
                if (app != null) {
                    loggerConfig.addAppender(app, ref.getLevel(), ref.getFilter());
                    continue;
                }
                LOGGER.error("Unable to locate appender \"{}\" for logger config \"{}\"", (Object)ref.getRef(), (Object)loggerConfig);
            }
            loggerConfig.initialize();
        }
        this.setParents();
    }

    protected void setToDefault() {
        this.setName("Default@" + Integer.toHexString(this.hashCode()));
        PatternLayout layout = PatternLayout.newBuilder().setPattern("%d{HH:mm:ss.SSS} [%thread] %-5level %logger{36} - %msg%n").setConfiguration(this).build();
        ConsoleAppender appender = ConsoleAppender.createDefaultAppenderForLayout(layout);
        appender.start();
        this.addAppender(appender);
        LoggerConfig rootLoggerConfig = this.getRootLogger();
        rootLoggerConfig.addAppender(appender, null, null);
        String defaultLevelName = this.contextProperties.getStringProperty((PropertyKey)Log4jPropertyKey.CONFIG_DEFAULT_LEVEL);
        Level defaultLevel = Level.toLevel((String)defaultLevelName, (Level)Level.ERROR);
        rootLoggerConfig.setLevel(defaultLevel);
    }

    public void setName(String name) {
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addListener(Consumer<Reconfigurable> listener) {
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(Consumer<Reconfigurable> listener) {
        this.listeners.remove(listener);
    }

    @Override
    public <T extends Appender> T getAppender(String appenderName) {
        return (T)(appenderName != null ? (Appender)Cast.cast(this.appenders.get(appenderName)) : null);
    }

    @Override
    public Map<String, Appender> getAppenders() {
        return this.appenders;
    }

    @Override
    public void addAppender(Appender appender) {
        if (appender != null) {
            this.appenders.putIfAbsent(appender.getName(), appender);
        }
    }

    @Override
    public StrSubstitutor getStrSubstitutor() {
        return this.runtimeStrSubstitutor;
    }

    @Override
    public StrSubstitutor getConfigurationStrSubstitutor() {
        return this.configurationStrSubstitutor;
    }

    @Override
    public void setAdvertiser(Advertiser advertiser) {
        this.advertiser = advertiser;
    }

    @Override
    public Advertiser getAdvertiser() {
        return this.advertiser;
    }

    @Override
    public ReliabilityStrategy getReliabilityStrategy(LoggerConfig loggerConfig) {
        return ReliabilityStrategyFactory.getReliabilityStrategy(loggerConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoggerAppender(Logger logger, Appender appender) {
        if (appender == null || logger == null) {
            return;
        }
        this.configLock.lock();
        try {
            String loggerName = logger.getName();
            this.appenders.putIfAbsent(appender.getName(), appender);
            LoggerConfig lc = this.getLoggerConfig(loggerName);
            if (lc.getName().equals(loggerName)) {
                lc.addAppender(appender, null, null);
            } else {
                LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), lc.isAdditive());
                nlc.addAppender(appender, null, null);
                nlc.setParent(lc);
                this.loggerConfigs.putIfAbsent(loggerName, nlc);
                this.setParents();
                logger.getContext().updateLoggers();
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addLoggerFilter(Logger logger, Filter filter) {
        this.configLock.lock();
        try {
            String loggerName = logger.getName();
            LoggerConfig lc = this.getLoggerConfig(loggerName);
            if (lc.getName().equals(loggerName)) {
                lc.addFilter(filter);
            } else {
                LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), lc.isAdditive());
                nlc.addFilter(filter);
                nlc.setParent(lc);
                this.loggerConfigs.putIfAbsent(loggerName, nlc);
                this.setParents();
                logger.getContext().updateLoggers();
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setLoggerAdditive(Logger logger, boolean additive) {
        this.configLock.lock();
        try {
            String loggerName = logger.getName();
            LoggerConfig lc = this.getLoggerConfig(loggerName);
            if (lc.getName().equals(loggerName)) {
                lc.setAdditive(additive);
            } else {
                LoggerConfig nlc = new LoggerConfig(loggerName, lc.getLevel(), additive);
                nlc.setParent(lc);
                this.loggerConfigs.putIfAbsent(loggerName, nlc);
                this.setParents();
                logger.getContext().updateLoggers();
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAppender(String appenderName) {
        this.configLock.lock();
        try {
            Appender app;
            for (LoggerConfig logger : this.loggerConfigs.values()) {
                logger.removeAppender(appenderName);
            }
            Appender appender = app = appenderName != null ? (Appender)this.appenders.remove(appenderName) : null;
            if (app != null) {
                app.stop();
            }
        }
        finally {
            this.configLock.unlock();
        }
    }

    @Override
    public List<CustomLevelConfig> getCustomLevels() {
        return Collections.unmodifiableList(this.customLevels);
    }

    @Override
    public LoggerConfig getLoggerConfig(String loggerName) {
        LoggerConfig loggerConfig = (LoggerConfig)this.loggerConfigs.get(loggerName);
        if (loggerConfig != null) {
            return loggerConfig;
        }
        String substr = loggerName;
        while ((substr = NameUtil.getSubName((String)substr)) != null) {
            loggerConfig = (LoggerConfig)this.loggerConfigs.get(substr);
            if (loggerConfig == null) continue;
            return loggerConfig;
        }
        return this.root;
    }

    @Override
    public LoggerContext getLoggerContext() {
        return (LoggerContext)this.loggerContext.get();
    }

    @Override
    public LoggerConfig getRootLogger() {
        return this.root;
    }

    @Override
    public Map<String, LoggerConfig> getLoggers() {
        return Collections.unmodifiableMap(this.loggerConfigs);
    }

    public LoggerConfig getLogger(String loggerName) {
        return (LoggerConfig)this.loggerConfigs.get(loggerName);
    }

    @Override
    public void addLogger(String loggerName, LoggerConfig loggerConfig) {
        this.configLock.lock();
        try {
            this.loggerConfigs.putIfAbsent(loggerName, loggerConfig);
            this.setParents();
        }
        finally {
            this.configLock.unlock();
        }
    }

    @Override
    public void removeLogger(String loggerName) {
        this.configLock.lock();
        try {
            this.loggerConfigs.remove(loggerName);
            this.setParents();
        }
        finally {
            this.configLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void createConfiguration(Node node, LogEvent event) {
        StrSubstitutor stringSubstitutionStrategy = event == null ? this.configurationStrSubstitutor : str -> this.runtimeStrSubstitutor.replace(event, str);
        this.instanceFactory.registerBinding(StringValueResolver.KEY, () -> stringSubstitutionStrategy);
        try {
            this.configurationProcessor.processNodeTree(node);
        }
        finally {
            this.instanceFactory.removeBinding(StringValueResolver.KEY);
        }
    }

    public Object createPluginObject(Node node) {
        if (this.getState().equals((Object)LifeCycle.State.INITIALIZING)) {
            this.instanceFactory.registerBinding(StringValueResolver.KEY, this::getConfigurationStrSubstitutor);
            try {
                Object t = this.configurationProcessor.processNodeTree(node);
                return t;
            }
            finally {
                this.instanceFactory.removeBinding(StringValueResolver.KEY);
            }
        }
        LOGGER.warn("Plugin Object creation is not allowed after initialization");
        return null;
    }

    private void setParents() {
        for (Map.Entry entry : this.loggerConfigs.entrySet()) {
            LoggerConfig logger = (LoggerConfig)entry.getValue();
            String key = (String)entry.getKey();
            if (key.isEmpty()) continue;
            int i = key.lastIndexOf(46);
            if (i > 0) {
                LoggerConfig parent = this.getLoggerConfig(key = key.substring(0, i));
                if (parent == null) {
                    parent = this.root;
                }
                logger.setParent(parent);
                continue;
            }
            logger.setParent(this.root);
        }
    }

    @Override
    public NanoClock getNanoClock() {
        return (NanoClock)this.instanceFactory.getInstance(NanoClock.class);
    }

    @Override
    public void setNanoClock(NanoClock nanoClock) {
        this.instanceFactory.registerBinding(NanoClock.KEY, () -> nanoClock);
    }

    @Override
    public <T extends ConfigurationExtension> T addExtensionIfAbsent(Class<T> extensionType, Supplier<? extends T> supplier) {
        for (ConfigurationExtension extension : this.extensions) {
            if (!extensionType.isInstance(extension)) continue;
            return (T)((ConfigurationExtension)extensionType.cast(extension));
        }
        return (T)this.addExtension((ConfigurationExtension)supplier.get());
    }

    private <T extends ConfigurationExtension> T addExtension(T extension) {
        this.extensions.add(Objects.requireNonNull(extension));
        return extension;
    }

    @Override
    public <T extends ConfigurationExtension> T getExtension(Class<T> extensionType) {
        ConfigurationExtension result = null;
        for (ConfigurationExtension extension : this.extensions) {
            if (!extensionType.isInstance(extension)) continue;
            if (result == null) {
                result = (ConfigurationExtension)extensionType.cast(extension);
                continue;
            }
            LOGGER.warn("Multiple configuration elements found for type {}. Only the first will be used.", (Object)extensionType.getName());
        }
        return (T)result;
    }
}

