/*
 * Decompiled with CFR 0.152.
 */
package mil.nga.geopackage.extension.coverage;

import mil.nga.geopackage.GeoPackage;
import mil.nga.geopackage.GeoPackageException;
import mil.nga.geopackage.extension.coverage.CoverageData;
import mil.nga.geopackage.extension.coverage.CoverageDataTiffImage;
import mil.nga.geopackage.extension.coverage.GriddedCoverageDataType;
import mil.nga.geopackage.extension.coverage.GriddedTile;
import mil.nga.geopackage.tiles.user.TileDao;
import mil.nga.geopackage.tiles.user.TileRow;
import mil.nga.geopackage.tiles.user.TileTableMetadata;
import mil.nga.proj.Projection;
import mil.nga.tiff.FileDirectory;
import mil.nga.tiff.Rasters;
import mil.nga.tiff.TIFFImage;
import mil.nga.tiff.TiffReader;

public class CoverageDataTiff
extends CoverageData<CoverageDataTiffImage> {
    public static final int SAMPLES_PER_PIXEL = 1;
    public static final int BITS_PER_SAMPLE = 32;

    public CoverageDataTiff(GeoPackage geoPackage, TileDao tileDao, Integer width, Integer height, Projection requestProjection) {
        super(geoPackage, tileDao, width, height, requestProjection);
    }

    public CoverageDataTiff(GeoPackage geoPackage, TileDao tileDao) {
        this(geoPackage, tileDao, null, null, tileDao.getProjection());
    }

    public CoverageDataTiff(GeoPackage geoPackage, TileDao tileDao, Projection requestProjection) {
        this(geoPackage, tileDao, null, null, requestProjection);
    }

    @Override
    public CoverageDataTiffImage createImage(TileRow tileRow) {
        return new CoverageDataTiffImage(tileRow);
    }

    @Override
    public double getValue(GriddedTile griddedTile, TileRow tileRow, int x, int y) {
        byte[] imageBytes = tileRow.getTileData();
        double value = this.getValue(griddedTile, imageBytes, x, y);
        return value;
    }

    public Double getValue(GriddedTile griddedTile, CoverageDataTiffImage image, int x, int y) {
        Double value = null;
        if (image.getDirectory() != null) {
            float pixelValue = image.getPixel(x, y);
            value = this.getValue(griddedTile, pixelValue);
        } else {
            value = this.getValue(griddedTile, image.getImageBytes(), x, y);
        }
        return value;
    }

    public float getPixelValue(byte[] imageBytes, int x, int y) {
        TIFFImage tiffImage = TiffReader.readTiff((byte[])imageBytes);
        FileDirectory directory = tiffImage.getFileDirectory();
        CoverageDataTiff.validateImageType(directory);
        Rasters rasters = directory.readRasters();
        float pixelValue = rasters.getFirstPixelSample(x, y).floatValue();
        return pixelValue;
    }

    public float[] getPixelValues(byte[] imageBytes) {
        TIFFImage tiffImage = TiffReader.readTiff((byte[])imageBytes);
        FileDirectory directory = tiffImage.getFileDirectory();
        CoverageDataTiff.validateImageType(directory);
        Rasters rasters = directory.readRasters();
        float[] pixels = new float[rasters.getWidth() * rasters.getHeight()];
        for (int y = 0; y < rasters.getHeight(); ++y) {
            for (int x = 0; x < rasters.getWidth(); ++x) {
                int index = rasters.getSampleIndex(x, y);
                pixels[index] = rasters.getPixelSample(0, x, y).floatValue();
            }
        }
        return pixels;
    }

    public static void validateImageType(FileDirectory directory) {
        if (directory == null) {
            throw new GeoPackageException("The image is null");
        }
        int samplesPerPixel = directory.getSamplesPerPixel();
        Integer bitsPerSample = null;
        if (directory.getBitsPerSample() != null && !directory.getBitsPerSample().isEmpty()) {
            bitsPerSample = (Integer)directory.getBitsPerSample().get(0);
        }
        Integer sampleFormat = null;
        if (directory.getSampleFormat() != null && !directory.getSampleFormat().isEmpty()) {
            sampleFormat = (Integer)directory.getSampleFormat().get(0);
        }
        if (samplesPerPixel != 1 || bitsPerSample == null || bitsPerSample != 32 || sampleFormat == null || sampleFormat != 3) {
            throw new GeoPackageException("The coverage data tile is expected to be a single sample 32 bit float. Samples Per Pixel: " + samplesPerPixel + ", Bits Per Sample: " + bitsPerSample + ", Sample Format: " + sampleFormat);
        }
    }

    @Override
    public Double getValue(GriddedTile griddedTile, byte[] imageBytes, int x, int y) {
        float pixelValue = this.getPixelValue(imageBytes, x, y);
        Double value = this.getValue(griddedTile, pixelValue);
        return value;
    }

    @Override
    public Double[] getValues(GriddedTile griddedTile, byte[] imageBytes) {
        float[] pixelValues = this.getPixelValues(imageBytes);
        Double[] values = this.getValues(griddedTile, pixelValues);
        return values;
    }

    public CoverageDataTiffImage drawTile(float[] pixelValues, int tileWidth, int tileHeight) {
        CoverageDataTiffImage image = this.createImage(tileWidth, tileHeight);
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < tileWidth; ++x) {
                float pixelValue = pixelValues[y * tileWidth + x];
                this.setPixelValue(image, x, y, pixelValue);
            }
        }
        image.writeTiff();
        return image;
    }

    public byte[] drawTileData(float[] pixelValues, int tileWidth, int tileHeight) {
        CoverageDataTiffImage image = this.drawTile(pixelValues, tileWidth, tileHeight);
        byte[] bytes = image.getImageBytes();
        return bytes;
    }

    public CoverageDataTiffImage drawTile(float[][] pixelValues) {
        int tileWidth = pixelValues[0].length;
        int tileHeight = pixelValues.length;
        CoverageDataTiffImage image = this.createImage(tileWidth, tileHeight);
        for (int y = 0; y < tileHeight; ++y) {
            for (int x = 0; x < tileWidth; ++x) {
                float pixelValue = pixelValues[y][x];
                this.setPixelValue(image, x, y, pixelValue);
            }
        }
        image.writeTiff();
        return image;
    }

    public byte[] drawTileData(float[][] pixelValues) {
        CoverageDataTiffImage image = this.drawTile(pixelValues);
        byte[] bytes = image.getImageBytes();
        return bytes;
    }

    public CoverageDataTiffImage drawTile(GriddedTile griddedTile, Double[] values, int tileWidth, int tileHeight) {
        CoverageDataTiffImage image = this.createImage(tileWidth, tileHeight);
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                Double value = values[y * tileWidth + x];
                float pixelValue = this.getPixelValue(griddedTile, value);
                this.setPixelValue(image, x, y, pixelValue);
            }
        }
        image.writeTiff();
        return image;
    }

    @Override
    public byte[] drawTileData(GriddedTile griddedTile, Double[] values, int tileWidth, int tileHeight) {
        CoverageDataTiffImage image = this.drawTile(griddedTile, values, tileWidth, tileHeight);
        byte[] bytes = image.getImageBytes();
        return bytes;
    }

    public CoverageDataTiffImage drawTile(GriddedTile griddedTile, Double[][] values) {
        int tileWidth = values[0].length;
        int tileHeight = values.length;
        CoverageDataTiffImage image = this.createImage(tileWidth, tileHeight);
        for (int x = 0; x < tileWidth; ++x) {
            for (int y = 0; y < tileHeight; ++y) {
                Double value = values[y][x];
                short pixelValue = this.getPixelValue(griddedTile, value);
                this.setPixelValue(image, x, y, pixelValue);
            }
        }
        image.writeTiff();
        return image;
    }

    @Override
    public byte[] drawTileData(GriddedTile griddedTile, Double[][] values) {
        CoverageDataTiffImage image = this.drawTile(griddedTile, values);
        byte[] bytes = image.getImageBytes();
        return bytes;
    }

    public CoverageDataTiffImage createImage(int tileWidth, int tileHeight) {
        Rasters rasters = new Rasters(tileWidth, tileHeight, 1, 32, 3);
        int rowsPerStrip = rasters.calculateRowsPerStrip(1);
        FileDirectory fileDirectory = new FileDirectory();
        fileDirectory.setImageWidth(tileWidth);
        fileDirectory.setImageHeight(tileHeight);
        fileDirectory.setBitsPerSample(32);
        fileDirectory.setCompression(1);
        fileDirectory.setPhotometricInterpretation(1);
        fileDirectory.setSamplesPerPixel(1);
        fileDirectory.setRowsPerStrip(rowsPerStrip);
        fileDirectory.setPlanarConfiguration(1);
        fileDirectory.setSampleFormat(3);
        fileDirectory.setWriteRasters(rasters);
        CoverageDataTiffImage image = new CoverageDataTiffImage(fileDirectory);
        return image;
    }

    public void setPixelValue(CoverageDataTiffImage image, int x, int y, float pixelValue) {
        image.getRasters().setFirstPixelSample(x, y, (Number)Float.valueOf(pixelValue));
    }

    public static CoverageDataTiff createTileTable(GeoPackage geoPackage, TileTableMetadata metadata) {
        return (CoverageDataTiff)CoverageData.createTileTable(geoPackage, metadata, GriddedCoverageDataType.FLOAT);
    }
}

