/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.feature;

import org.apache.sis.feature.AbstractFeature;
import org.apache.sis.filter.Filter;
import org.apache.sis.geometry.GeneralEnvelope;
import org.apache.sis.geometry.WraparoundMethod;
import org.apache.sis.geometry.wrapper.Geometries;
import org.apache.sis.geometry.wrapper.GeometryWrapper;
import org.apache.sis.metadata.sql.util.SQLBuilder;
import org.apache.sis.pending.geoapi.filter.ValueReference;
import org.apache.sis.storage.sql.feature.Column;
import org.apache.sis.storage.sql.feature.SelectionClauseWriter;
import org.apache.sis.storage.sql.feature.Table;
import org.opengis.geometry.Envelope;
import org.opengis.geometry.Geometry;
import org.opengis.metadata.extent.GeographicBoundingBox;

public final class SelectionClause
extends SQLBuilder {
    private final Table table;
    boolean isInvalid;

    SelectionClause(Table table) {
        super(table.database);
        this.table = table;
    }

    final void appendColumnName(ValueReference<AbstractFeature, ?> ref) {
        Column c = this.table.getColumn(ref.getXPath());
        if (c != null) {
            this.appendIdentifier(c.name);
        } else {
            this.invalidate();
        }
    }

    final void appendLiteral(Object value) {
        if (value instanceof GeographicBoundingBox) {
            this.appendGeometry(null, (Envelope)new GeneralEnvelope((GeographicBoundingBox)value));
        } else if (value instanceof Envelope) {
            this.appendGeometry(null, (Envelope)value);
        } else if (value instanceof Geometry) {
            this.appendGeometry(Geometries.wrap((Object)((Geometry)value)).orElse(null), null);
        } else {
            this.appendValue(value);
        }
    }

    private void appendGeometry(GeometryWrapper wrapper, Envelope bounds) {
        if (bounds == null) {
            if (wrapper == null) {
                this.invalidate();
                return;
            }
            bounds = wrapper.getEnvelope();
        }
        if (bounds.getDimension() < 2) {
            this.invalidate();
            return;
        }
        double span = (bounds.getSpan(0) + bounds.getSpan(1)) / 2.0;
        if (Double.isNaN(span)) {
            GeneralEnvelope e = new GeneralEnvelope(bounds);
            for (int i = 0; i < 2; ++i) {
                double lower = SelectionClause.clampInfinity(e.getLower(i));
                double upper = SelectionClause.clampInfinity(e.getUpper(i));
                if (Double.isNaN(lower) || Double.isNaN(upper)) {
                    this.invalidate();
                    return;
                }
                e.setRange(i, lower, upper);
            }
            bounds = e;
        }
        if (wrapper == null) {
            wrapper = this.table.database.geomLibrary.toGeometry2D(bounds, WraparoundMethod.SPLIT);
        }
        String wkt = wrapper.formatWKT(0.05 * span);
        this.append("ST_GeomFromText(").appendValue(wkt).append(')');
    }

    private static double clampInfinity(double value) {
        if (value == Double.NEGATIVE_INFINITY) {
            return -1.7976931348623157E308;
        }
        if (value == Double.POSITIVE_INFINITY) {
            return Double.MAX_VALUE;
        }
        return value;
    }

    final void invalidate() {
        this.isInvalid = true;
    }

    final boolean tryAppend(SelectionClauseWriter writer, Filter<? super AbstractFeature> filter) {
        int pos = this.buffer.length();
        if (pos != 0) {
            this.buffer.append(" AND ");
        }
        if (writer.write(this, filter)) {
            this.buffer.setLength(pos);
            this.isInvalid = false;
            return false;
        }
        return true;
    }
}

