/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sis.storage.sql.postgis;

import java.awt.image.RasterFormatException;
import org.apache.sis.util.resources.Errors;

final class Band {
    private static final int IS_OFFLINE = 128;
    private static final int HAS_NODATA = 64;
    private static final int IS_NODATA = 32;
    private static final int PIXEL_TYPE = 15;
    final int header;
    Number noDataValue;
    Object data;
    static final int OPPOSITE_SIGN = 8;
    private static final byte[] PIXEL_TO_BUFFER_TYPE = new byte[]{0, 0, 0, 8, 0, 2, 1, 3, 11, 32, 4, 5};
    private static final byte[] BUFFER_TO_PIXEL_TYPE = new byte[8];
    private static final byte[] PIXEL_TYPE_TO_SIZE;
    private static final byte[] SIZE_TO_PIXEL_TYPE;

    Band(int header) {
        this.header = header;
    }

    Band(int pixelType, Number noDataValue) {
        if (noDataValue != null) {
            pixelType |= 0x40;
        }
        this.header = pixelType;
        this.noDataValue = noDataValue;
    }

    private int getPixelType() {
        return this.header & 0xF;
    }

    final boolean isOffline() {
        return (this.header & 0x80) != 0;
    }

    final boolean hasNodata() {
        return (this.header & 0x40) != 0;
    }

    final boolean isNodata() {
        return (this.header & 0x20) != 0;
    }

    final boolean isUnsigned() {
        int dataType = this.getDataBufferType();
        return dataType == 0 || dataType == 1 || dataType == 11;
    }

    final int getDataBufferType() {
        int type = this.getPixelType();
        return type < PIXEL_TO_BUFFER_TYPE.length ? PIXEL_TO_BUFFER_TYPE[type] : 32;
    }

    static int bufferToPixelType(int dataType) {
        if (dataType >= 0 && dataType < BUFFER_TO_PIXEL_TYPE.length) {
            return BUFFER_TO_PIXEL_TYPE[dataType];
        }
        throw new RasterFormatException(Errors.format((short)163, (Object)dataType));
    }

    final int getDataTypeSize() {
        byte size;
        int type = this.getPixelType();
        if (type < PIXEL_TYPE_TO_SIZE.length && (size = PIXEL_TYPE_TO_SIZE[type]) != 0) {
            return size;
        }
        throw new RasterFormatException(Errors.format((short)163, (Object)type));
    }

    static int sizeToPixelType(int size) {
        if (size > 0) {
            int p = 31 - Integer.numberOfLeadingZeros(size);
            if (1 << p != size) {
                ++p;
            }
            if (p >= 0 && p < SIZE_TO_PIXEL_TYPE.length) {
                return SIZE_TO_PIXEL_TYPE[p];
            }
        }
        throw new RasterFormatException(Errors.format((short)45, (Object)"size", (Object)size));
    }

    final float[] toNaN(float[] array) {
        if (this.noDataValue != null) {
            float r = this.noDataValue.floatValue();
            if (!Float.isNaN(r)) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != r) continue;
                    array[i] = Float.NaN;
                }
            }
            this.noDataValue = null;
        }
        return array;
    }

    final double[] toNaN(double[] array) {
        if (this.noDataValue != null) {
            double r = this.noDataValue.doubleValue();
            if (!Double.isNaN(r)) {
                for (int i = 0; i < array.length; ++i) {
                    if (array[i] != r) continue;
                    array[i] = Double.NaN;
                }
            }
            this.noDataValue = null;
        }
        return array;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("WKB Raster Band:");
        sb.append("\n- pixel type: ").append(this.getPixelType());
        sb.append("\n- is offline: ").append(this.isOffline());
        sb.append("\n- has nodata: ").append(this.hasNodata());
        sb.append("\n- is no data: ").append(this.isNodata());
        sb.append("\n- nodata val: ").append(this.noDataValue);
        return sb.toString();
    }

    static {
        Band.BUFFER_TO_PIXEL_TYPE[0] = 4;
        Band.BUFFER_TO_PIXEL_TYPE[1] = 6;
        Band.BUFFER_TO_PIXEL_TYPE[2] = 5;
        Band.BUFFER_TO_PIXEL_TYPE[3] = 7;
        Band.BUFFER_TO_PIXEL_TYPE[4] = 10;
        Band.BUFFER_TO_PIXEL_TYPE[5] = 11;
        PIXEL_TYPE_TO_SIZE = new byte[]{1, 2, 4, 8, 8, 16, 16, 32, 32, 0, 32, 64};
        SIZE_TO_PIXEL_TYPE = new byte[]{0, 1, 2, 4, 6, 8};
    }
}

