/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.manager.schedule.airflow.api.connection;

import java.util.Map;
import okhttp3.MediaType;
import okhttp3.RequestBody;
import org.apache.inlong.manager.pojo.schedule.airflow.AirflowConnection;
import org.apache.inlong.manager.schedule.airflow.api.BaseAirflowApi;
import org.apache.inlong.manager.schedule.exception.AirflowScheduleException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpMethod;

public class AirflowConnectionCreator
extends BaseAirflowApi<AirflowConnection> {
    private static final Logger log = LoggerFactory.getLogger(AirflowConnectionCreator.class);
    AirflowConnection connection = null;

    public AirflowConnectionCreator(AirflowConnection connection) {
        this.connection = connection;
    }

    public AirflowConnectionCreator(Map<String, Object> requestBodyParams) {
        this.requestBodyParams = requestBodyParams;
    }

    @Override
    public RequestBody getRequestBody() {
        if (this.connection != null) {
            try {
                return RequestBody.create((MediaType)MediaType.parse((String)"application/json; charset=utf-8"), (String)objectMapper.writeValueAsString((Object)this.connection));
            }
            catch (Exception e) {
                log.error("Airflow request body construction failed: {}", (Object)e.getMessage(), (Object)e);
                throw new AirflowScheduleException(AirflowScheduleException.AirflowErrorCode.BUILD_REQUEST_BODY_FAILED, String.format("Airflow request body construction failed: %s", e.getMessage()));
            }
        }
        return super.getRequestBody();
    }

    @Override
    public Class<AirflowConnection> getResponseType() {
        return AirflowConnection.class;
    }

    @Override
    public HttpMethod getMethod() {
        return HttpMethod.POST;
    }

    @Override
    public String getPath() {
        return "/api/v1/connections";
    }
}

