/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.message;

import java.util.Map;
import org.apache.inlong.agent.plugin.Message;

public class ProxyMessage
implements Message {
    private static final String DEFAULT_INLONG_STREAM_ID = "__";
    private final byte[] body;
    private final Map<String, String> header;
    private final String inlongGroupId;
    private final String inlongStreamId;
    private final String batchKey;
    private final String dataKey;

    public ProxyMessage(byte[] body, Map<String, String> header) {
        this.body = body;
        this.header = header;
        this.inlongGroupId = header.get("inlongGroupId");
        this.inlongStreamId = header.getOrDefault("inlongStreamId", DEFAULT_INLONG_STREAM_ID);
        this.dataKey = header.getOrDefault("dataKey", "");
        this.batchKey = this.dataKey + this.inlongStreamId;
    }

    public ProxyMessage(Message message) {
        this(message.getBody(), message.getHeader());
    }

    public String getDataKey() {
        return this.dataKey;
    }

    @Override
    public byte[] getBody() {
        return this.body;
    }

    @Override
    public Map<String, String> getHeader() {
        return this.header;
    }

    public String getInlongGroupId() {
        return this.inlongGroupId;
    }

    public String getInlongStreamId() {
        return this.inlongStreamId;
    }

    public String getBatchKey() {
        return this.batchKey;
    }
}

