/*
 * Decompiled with CFR 0.152.
 */
package org.apache.inlong.agent.core.task;

import java.lang.reflect.Constructor;
import java.util.List;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.inlong.agent.common.AbstractDaemon;
import org.apache.inlong.agent.common.AgentThreadFactory;
import org.apache.inlong.agent.conf.AgentConfiguration;
import org.apache.inlong.agent.conf.TaskProfile;
import org.apache.inlong.agent.core.task.OffsetManager;
import org.apache.inlong.agent.core.task.TaskAction;
import org.apache.inlong.agent.metrics.audit.AuditUtils;
import org.apache.inlong.agent.plugin.file.Task;
import org.apache.inlong.agent.store.Store;
import org.apache.inlong.agent.store.TaskStore;
import org.apache.inlong.agent.utils.AgentUtils;
import org.apache.inlong.agent.utils.EventReportUtils;
import org.apache.inlong.agent.utils.ThreadUtils;
import org.apache.inlong.common.enums.TaskStateEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TaskManager
extends AbstractDaemon {
    private static final Logger LOGGER = LoggerFactory.getLogger(TaskManager.class);
    public static final int CONFIG_QUEUE_CAPACITY = 1;
    public static final int CORE_THREAD_SLEEP_TIME = 1000;
    public static final int CORE_THREAD_PRINT_TIME = 10000;
    private static final int ACTION_QUEUE_CAPACITY = 1000;
    private long lastPrintTime = 0L;
    private static Store taskBasicStore;
    private static Store instanceBasicStore;
    private static Store offsetBasicStore;
    private static TaskStore taskStore;
    private final ConcurrentHashMap<String, Task> taskMap;
    private final BlockingQueue<List<TaskProfile>> configQueue;
    private final ThreadPoolExecutor runningPool;
    private final BlockingQueue<Task> pendingTasks;
    private final int taskMaxLimit;
    private static final AgentConfiguration agentConf;
    private final BlockingQueue<TaskAction> actionQueue;
    private String taskResultMd5;
    private Integer taskResultVersion = -1;

    public TaskManager() {
        taskBasicStore = TaskManager.initStore(agentConf.get("agent.rocks.db.path", ".localdb/task"));
        taskStore = new TaskStore(taskBasicStore);
        instanceBasicStore = TaskManager.initStore(agentConf.get("agent.rocks.db.path", ".localdb/instance"));
        offsetBasicStore = TaskManager.initStore(agentConf.get("agent.rocks.db.path", ".localdb/offset"));
        OffsetManager.init(taskBasicStore, instanceBasicStore, offsetBasicStore);
        this.runningPool = new ThreadPoolExecutor(0, Integer.MAX_VALUE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(), (ThreadFactory)new AgentThreadFactory("task-manager-running-pool"));
        this.taskMap = new ConcurrentHashMap();
        this.taskMaxLimit = agentConf.getInt("job.number.limit", 15);
        this.pendingTasks = new LinkedBlockingQueue<Task>(this.taskMaxLimit);
        this.configQueue = new LinkedBlockingQueue<List<TaskProfile>>(1);
        this.actionQueue = new LinkedBlockingQueue<TaskAction>(1000);
        EventReportUtils.init();
    }

    public static TaskStore getTaskStore() {
        return taskStore;
    }

    public Store getInstanceBasicStore() {
        return instanceBasicStore;
    }

    public static Store initStore(String childPath) {
        try {
            Constructor<?> constructor = Class.forName(agentConf.get("agent.store.classname", "org.apache.inlong.agent.plugin.store.RocksDBStoreImpl")).getDeclaredConstructor(String.class);
            constructor.setAccessible(true);
            return (Store)constructor.newInstance(childPath);
        }
        catch (Exception ex) {
            throw new UnsupportedClassVersionError(ex.getMessage());
        }
    }

    public void submitTaskProfiles(List<TaskProfile> taskProfiles) {
        if (taskProfiles == null) {
            return;
        }
        while (this.configQueue.size() != 0) {
            this.configQueue.poll();
        }
        for (int i = 0; i < taskProfiles.size(); ++i) {
            LOGGER.info("submitTaskProfiles index {} total {} {}", new Object[]{i, taskProfiles.size(), taskProfiles.get(i).toJsonStr()});
        }
        this.configQueue.add(taskProfiles);
    }

    public boolean submitAction(TaskAction action) {
        if (action == null) {
            return false;
        }
        return this.actionQueue.offer(action);
    }

    private Runnable coreThread() {
        return () -> {
            Thread.currentThread().setName("task-manager-core");
            while (this.isRunnable()) {
                try {
                    AgentUtils.silenceSleepInMs((long)1000L);
                    this.printTaskDetail();
                    this.dealWithConfigQueue(this.configQueue);
                    this.dealWithActionQueue(this.actionQueue);
                    AuditUtils.add((int)AuditUtils.AUDIT_ID_AGENT_TASK_MGR_HEARTBEAT, (String)"", (String)"", (long)AgentUtils.getCurrentTime(), (int)1, (long)1L);
                }
                catch (Throwable ex) {
                    LOGGER.error("exception caught", ex);
                    ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
                }
            }
        };
    }

    private void printTaskDetail() {
        if (AgentUtils.getCurrentTime() - this.lastPrintTime > 10000L) {
            List tasksInStore = taskStore.getTasks();
            TaskPrintStat stat = new TaskPrintStat();
            for (int i = 0; i < tasksInStore.size(); ++i) {
                TaskProfile task = (TaskProfile)tasksInStore.get(i);
                stat.stat(task.getState());
            }
            LOGGER.info("taskManager running! mem {} total {} {} ", new Object[]{this.taskMap.size(), tasksInStore.size(), stat});
            this.lastPrintTime = AgentUtils.getCurrentTime();
        }
    }

    private void dealWithConfigQueue(BlockingQueue<List<TaskProfile>> queue) {
        List dataConfigs = (List)queue.poll();
        if (dataConfigs == null) {
            return;
        }
        this.keepPaceWithManager(dataConfigs);
        this.keepPaceWithStore();
    }

    private void dealWithActionQueue(BlockingQueue<TaskAction> queue) {
        block5: while (this.isRunnable()) {
            try {
                TaskAction action = (TaskAction)queue.poll();
                if (action == null) break;
                TaskProfile profile = action.getProfile();
                switch (action.getActionType()) {
                    case FINISH: {
                        LOGGER.info("deal finish action, taskId {}", (Object)profile.getTaskId());
                        this.finishTask(profile);
                        continue block5;
                    }
                }
                LOGGER.error("invalid action type for action queue: taskId {} type {}", (Object)profile.getTaskId(), (Object)action.getActionType());
            }
            catch (Throwable ex) {
                LOGGER.error("dealWithActionQueue", ex);
                ThreadUtils.threadThrowableHandler((Thread)Thread.currentThread(), (Throwable)ex);
            }
        }
    }

    private void keepPaceWithManager(List<TaskProfile> taskProfiles) {
        ConcurrentHashMap<String, TaskProfile> tasksFromManager = new ConcurrentHashMap<String, TaskProfile>();
        taskProfiles.forEach(profile -> {
            TaskStateEnum state = profile.getState();
            if (state == TaskStateEnum.RUNNING || state == TaskStateEnum.FROZEN) {
                tasksFromManager.put(profile.getTaskId(), (TaskProfile)profile);
            } else {
                LOGGER.error("task {} invalid task state {}", profile, (Object)state);
            }
        });
        this.traverseManagerTasksToStore(tasksFromManager);
        this.traverseStoreTasksToManager(tasksFromManager);
    }

    private void keepPaceWithStore() {
        this.traverseStoreTasksToMemory();
        this.traverseMemoryTasksToStore();
    }

    private void traverseManagerTasksToStore(Map<String, TaskProfile> tasksFromManager) {
        tasksFromManager.values().forEach(profileFromManager -> {
            TaskProfile taskFromStore = taskStore.getTask(profileFromManager.getTaskId());
            if (taskFromStore == null) {
                LOGGER.info("traverseManagerTasksToStore task {} not found in task store retry {} state {}, add it", new Object[]{profileFromManager.getTaskId(), profileFromManager.isRetry(), profileFromManager.getState()});
                this.addTask((TaskProfile)profileFromManager);
                EventReportUtils.report((String)profileFromManager.getInlongGroupId(), (String)profileFromManager.getInlongStreamId(), (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"INFO", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.TASK_ADD, (String)profileFromManager.toJsonStr(), (String)EventReportUtils.EvenCodeEnum.TASK_ADD.getMessage());
            } else {
                TaskStateEnum storeState;
                TaskStateEnum managerState = profileFromManager.getState();
                if (managerState == (storeState = taskFromStore.getState())) {
                    return;
                }
                if (storeState == TaskStateEnum.RETRY_FINISH) {
                    LOGGER.info("traverseManagerTasksToStore task {} storeState {} retry {}, do nothing", new Object[]{taskFromStore.getTaskId(), storeState, taskFromStore.isRetry()});
                    return;
                }
                if (managerState == TaskStateEnum.RUNNING) {
                    LOGGER.info("traverseManagerTasksToStore task {} storeState {} retry {}, active it", new Object[]{taskFromStore.getTaskId(), storeState, taskFromStore.isRetry()});
                    this.activeTask((TaskProfile)profileFromManager);
                } else {
                    LOGGER.info("traverseManagerTasksToStore task {} storeState {} retry {}, freeze it", new Object[]{taskFromStore.getTaskId(), storeState, taskFromStore.isRetry()});
                    this.freezeTask((TaskProfile)profileFromManager);
                }
            }
        });
    }

    private void traverseStoreTasksToManager(Map<String, TaskProfile> tasksFromManager) {
        taskStore.getTasks().forEach(profileFromStore -> {
            if (!tasksFromManager.containsKey(profileFromStore.getTaskId())) {
                LOGGER.info("traverseStoreTasksToManager try to delete task {}", (Object)profileFromStore.getTaskId());
                EventReportUtils.report((String)profileFromStore.getInlongGroupId(), (String)profileFromStore.getInlongStreamId(), (long)AgentUtils.getCurrentTime(), (String)"CONFIG_UPDATE", (String)"INFO", (EventReportUtils.EvenCodeEnum)EventReportUtils.EvenCodeEnum.TASK_DELETE, (String)profileFromStore.toJsonStr(), (String)EventReportUtils.EvenCodeEnum.TASK_DELETE.getMessage());
                this.deleteTask((TaskProfile)profileFromStore);
            }
        });
    }

    private void traverseStoreTasksToMemory() {
        taskStore.getTasks().forEach(profileFromStore -> {
            TaskStateEnum storeState = profileFromStore.getState();
            Task task = this.taskMap.get(profileFromStore.getTaskId());
            if (storeState == TaskStateEnum.RUNNING) {
                if (task == null) {
                    LOGGER.info("traverseStoreTasksToMemory add task to mem taskId {}", (Object)profileFromStore.getTaskId());
                    this.addToMemory((TaskProfile)profileFromStore);
                }
            } else if (storeState == TaskStateEnum.FROZEN) {
                if (task != null) {
                    LOGGER.info("traverseStoreTasksToMemory delete task from mem taskId {}", (Object)profileFromStore.getTaskId());
                    this.deleteFromMemory(profileFromStore.getTaskId());
                }
            } else if (storeState != TaskStateEnum.RETRY_FINISH) {
                LOGGER.error("task {} invalid state {}", (Object)profileFromStore.getTaskId(), (Object)storeState);
            }
        });
    }

    private void traverseMemoryTasksToStore() {
        this.taskMap.values().forEach(task -> {
            TaskProfile profileFromStore = taskStore.getTask(task.getTaskId());
            if (profileFromStore == null) {
                this.deleteFromMemory(task.getTaskId());
                return;
            }
            TaskStateEnum stateFromStore = profileFromStore.getState();
            if (stateFromStore != TaskStateEnum.RUNNING) {
                this.deleteFromMemory(task.getTaskId());
            }
        });
    }

    private void addTask(TaskProfile taskProfile) {
        if (this.taskMap.size() >= this.taskMaxLimit) {
            LOGGER.error("taskMap size {} over limit {}", (Object)this.taskMap.size(), (Object)this.taskMaxLimit);
            return;
        }
        if (!this.isProfileValid(taskProfile)) {
            LOGGER.error("task profile invalid {}", (Object)taskProfile.toJsonStr());
            return;
        }
        this.addToStore(taskProfile);
        TaskStateEnum state = TaskStateEnum.getTaskState((int)taskProfile.getInt("task.state"));
        if (state == TaskStateEnum.RUNNING) {
            this.addToMemory(taskProfile);
        } else {
            LOGGER.info("taskId {} state {} no need to add to memory", (Object)taskProfile.getTaskId(), (Object)taskProfile.getState());
        }
    }

    private void deleteTask(TaskProfile taskProfile) {
        this.deleteFromStore(taskProfile);
        this.deleteFromMemory(taskProfile.getTaskId());
    }

    private void freezeTask(TaskProfile taskProfile) {
        this.updateToStore(taskProfile);
        this.deleteFromMemory(taskProfile.getTaskId());
    }

    private void finishTask(TaskProfile taskProfile) {
        taskProfile.setState(TaskStateEnum.RETRY_FINISH);
        this.updateToStore(taskProfile);
        this.deleteFromMemory(taskProfile.getTaskId());
    }

    private void activeTask(TaskProfile taskProfile) {
        this.updateToStore(taskProfile);
        this.addToMemory(taskProfile);
    }

    private void restoreFromStore() {
        LOGGER.info("restore from task store start");
        List taskProfileList = taskStore.getTasks();
        taskProfileList.forEach(profile -> {
            if (profile.getState() == TaskStateEnum.RUNNING) {
                LOGGER.info("restore from task store taskId {}", (Object)profile.getTaskId());
                profile.setBoolean("task.restoreFromDB", true);
                this.addToMemory((TaskProfile)profile);
            }
        });
        LOGGER.info("restore from task store end");
    }

    private void stopAllTasks() {
        this.taskMap.values().forEach(task -> task.destroy());
        this.taskMap.clear();
    }

    private boolean isProfileValid(TaskProfile profile) {
        try {
            Class<?> taskClass = Class.forName(profile.getTaskClass());
            Task task = (Task)taskClass.newInstance();
            return task.isProfileValid(profile);
        }
        catch (Throwable t) {
            LOGGER.error("isProfileValid error: ", t);
            return false;
        }
    }

    private void addToStore(TaskProfile taskProfile) {
        if (taskStore.getTask(taskProfile.getTaskId()) != null) {
            LOGGER.error("task {} should not exist", (Object)taskProfile.getTaskId());
        }
        taskStore.storeTask(taskProfile);
    }

    private void deleteFromStore(TaskProfile taskProfile) {
        if (taskStore.getTask(taskProfile.getTaskId()) == null) {
            LOGGER.error("try to delete task {} but not found in task store", (Object)taskProfile);
            return;
        }
        taskStore.deleteTask(taskProfile.getTaskId());
    }

    private void updateToStore(TaskProfile taskProfile) {
        if (taskStore.getTask(taskProfile.getTaskId()) == null) {
            LOGGER.error("task {} not found, agent may have been reinstalled", (Object)taskProfile);
        }
        taskStore.storeTask(taskProfile);
    }

    private void addToMemory(TaskProfile taskProfile) {
        Task oldTask = this.taskMap.get(taskProfile.getTaskId());
        if (oldTask != null) {
            oldTask.destroy();
            this.taskMap.remove(taskProfile.getTaskId());
            LOGGER.error("old task {} should not exist, try stop it first", (Object)taskProfile.getTaskId());
        }
        try {
            Class<?> taskClass = Class.forName(taskProfile.getTaskClass());
            Task task = (Task)taskClass.newInstance();
            task.init((Object)this, taskProfile, instanceBasicStore);
            this.taskMap.put(taskProfile.getTaskId(), task);
            this.runningPool.submit((Runnable)task);
            LOGGER.info("add task {} into memory, taskMap size {}, runningPool task total {}, runningPool task active {}", new Object[]{task.getTaskId(), this.taskMap.size(), this.runningPool.getTaskCount(), this.runningPool.getActiveCount()});
        }
        catch (Throwable t) {
            LOGGER.error("add task error: ", t);
        }
    }

    private void deleteFromMemory(String taskId) {
        Task oldTask = this.taskMap.get(taskId);
        if (oldTask == null) {
            LOGGER.error("old task {} not found", (Object)taskId);
            return;
        }
        oldTask.destroy();
        this.taskMap.remove(oldTask.getTaskId());
        LOGGER.info("delete task {} from memory, taskMap size {}, runningPool task total {}, runningPool task active {}", new Object[]{oldTask.getTaskId(), this.taskMap.size(), this.runningPool.getTaskCount(), this.runningPool.getActiveCount()});
    }

    public Task getTask(String taskId) {
        return this.taskMap.get(taskId);
    }

    public int getInstanceNum() {
        int num = 0;
        for (Task task : this.taskMap.values()) {
            num += task.getInstanceNum();
        }
        return num;
    }

    public TaskProfile getTaskProfile(String taskId) {
        return taskStore.getTask(taskId);
    }

    public String getTaskResultMd5() {
        return this.taskResultMd5;
    }

    public void setTaskResultMd5(String taskResultMd5) {
        this.taskResultMd5 = taskResultMd5;
    }

    public Integer getTaskResultVersion() {
        return this.taskResultVersion;
    }

    public void setTaskResultVersion(Integer taskResultVersion) {
        this.taskResultVersion = taskResultVersion;
    }

    public void start() throws Exception {
        this.restoreFromStore();
        this.submitWorker(this.coreThread());
        OffsetManager.getInstance().start();
    }

    public void stop() throws Exception {
        this.stopAllTasks();
        this.waitForTerminate();
        this.runningPool.shutdown();
    }

    static {
        agentConf = AgentConfiguration.getAgentConf();
    }

    private class TaskPrintStat {
        public int newCount = 0;
        public int runningCont = 0;
        public int frozenCount = 0;
        public int finishedCount = 0;
        public int otherCount = 0;

        private TaskPrintStat() {
        }

        private void stat(TaskStateEnum state) {
            switch (state) {
                case NEW: {
                    ++this.newCount;
                    break;
                }
                case RUNNING: {
                    ++this.runningCont;
                    break;
                }
                case FROZEN: {
                    ++this.frozenCount;
                    break;
                }
                case RETRY_FINISH: {
                    ++this.finishedCount;
                    break;
                }
                default: {
                    ++this.otherCount;
                }
            }
        }

        public String toString() {
            return String.format("new %d running %d frozen %d finished %d other %d", this.newCount, this.runningCont, this.frozenCount, this.finishedCount, this.otherCount);
        }
    }
}

