/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation;

import java.util.Objects;
import java.util.Set;
import org.springframework.http.MediaType;
import org.springframework.web.bind.annotation.RequestMethod;

public class RequestHandlerKey {
    private final Set<String> pathMappings;
    private final Set<RequestMethod> supportedMethods;
    private final Set<MediaType> supportedMediaTypes;
    private final Set<MediaType> producibleMediaTypes;

    public RequestHandlerKey(Set<String> pathMappings, Set<RequestMethod> supportedMethods, Set<MediaType> supportedMediaTypes, Set<MediaType> producibleMediaTypes) {
        this.pathMappings = pathMappings;
        this.supportedMethods = supportedMethods;
        this.supportedMediaTypes = supportedMediaTypes;
        this.producibleMediaTypes = producibleMediaTypes;
    }

    public Set<String> getPathMappings() {
        return this.pathMappings;
    }

    public Set<RequestMethod> getSupportedMethods() {
        return this.supportedMethods;
    }

    public Set<MediaType> getSupportedMediaTypes() {
        return this.supportedMediaTypes;
    }

    public Set<MediaType> getProducibleMediaTypes() {
        return this.producibleMediaTypes;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RequestHandlerKey that = (RequestHandlerKey)o;
        return Objects.equals(this.pathMappings, that.pathMappings) && Objects.equals(this.supportedMethods, that.supportedMethods) && Objects.equals(this.supportedMediaTypes, that.supportedMediaTypes) && Objects.equals(this.producibleMediaTypes, that.producibleMediaTypes);
    }

    public int hashCode() {
        return Objects.hash(this.pathMappings, this.supportedMethods, this.supportedMediaTypes, this.producibleMediaTypes);
    }

    public String toString() {
        StringBuffer sb = new StringBuffer("RequestHandlerKey{");
        sb.append("pathMappings=").append(this.pathMappings);
        sb.append(", supportedMethods=").append(this.supportedMethods);
        sb.append(", supportedMediaTypes=").append(this.supportedMediaTypes);
        sb.append(", producibleMediaTypes=").append(this.producibleMediaTypes);
        sb.append('}');
        return sb.toString();
    }
}

