/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.builders;

import java.util.function.Consumer;
import springfox.documentation.builders.ModelSpecificationBuilder;
import springfox.documentation.schema.CollectionSpecification;
import springfox.documentation.schema.CollectionType;

public class CollectionSpecificationBuilder {
    private ModelSpecificationBuilder model;
    private CollectionType collectionType;

    public CollectionSpecificationBuilder model(Consumer<ModelSpecificationBuilder> consumer) {
        if (this.model == null) {
            this.model = new ModelSpecificationBuilder();
        }
        consumer.accept(this.model);
        return this;
    }

    public CollectionSpecificationBuilder collectionType(CollectionType collectionType) {
        this.collectionType = collectionType;
        return this;
    }

    public CollectionSpecification build() {
        if (this.model != null) {
            return new CollectionSpecification(this.model.build(), this.collectionType);
        }
        return null;
    }

    public CollectionSpecificationBuilder copyOf(CollectionSpecification other) {
        if (other == null) {
            return this;
        }
        return this.model(m -> m.copyOf(other.getModel())).collectionType(other.getCollectionType());
    }
}

