/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.calcite;

import java.util.Collections;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlDataTypeSpec;
import org.apache.calcite.sql.SqlIntervalQualifier;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlUtil;
import org.apache.calcite.sql.validate.SqlValidatorImpl;
import org.apache.calcite.sql2rel.SqlRexContext;
import org.apache.calcite.sql2rel.SqlRexConvertlet;
import org.apache.calcite.sql2rel.SqlRexConvertletTable;
import org.apache.calcite.sql2rel.StandardConvertletTable;
import org.apache.flink.annotation.Internal;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;

@Internal
public class FlinkConvertletTable
implements SqlRexConvertletTable {
    public static final FlinkConvertletTable INSTANCE = new FlinkConvertletTable();

    private FlinkConvertletTable() {
    }

    @Override
    public SqlRexConvertlet get(SqlCall call) {
        if (call.getOperator().isName("TRY_CAST", false)) {
            return this::convertTryCast;
        }
        return StandardConvertletTable.INSTANCE.get(call);
    }

    private RexNode convertTryCast(SqlRexContext cx, SqlCall call) {
        RelDataType type;
        RelDataTypeFactory typeFactory = cx.getTypeFactory();
        Object leftNode = call.operand(0);
        Object rightNode = call.operand(1);
        RexNode valueRex = cx.convertExpression((SqlNode)leftNode);
        if (rightNode instanceof SqlIntervalQualifier) {
            type = typeFactory.createSqlIntervalType((SqlIntervalQualifier)rightNode);
        } else if (rightNode instanceof SqlDataTypeSpec) {
            SqlDataTypeSpec dataType = (SqlDataTypeSpec)rightNode;
            type = dataType.deriveType(cx.getValidator());
            if (type == null) {
                type = cx.getValidator().getValidatedNodeType(dataType.getTypeName());
            }
        } else {
            throw new IllegalStateException("Invalid right argument type for TRY_CAST: " + rightNode);
        }
        type = typeFactory.createTypeWithNullability(type, true);
        if (SqlUtil.isNullLiteral(leftNode, false)) {
            SqlValidatorImpl validator = (SqlValidatorImpl)cx.getValidator();
            validator.setValidatedNodeType((SqlNode)leftNode, type);
            return cx.convertExpression((SqlNode)leftNode);
        }
        return cx.getRexBuilder().makeCall(type, FlinkSqlOperatorTable.TRY_CAST, Collections.singletonList(valueRex));
    }
}

