/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.table.planner.codegen;

import java.io.Serializable;
import java.time.format.DateTimeFormatter;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlOperator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ArrayNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.node.ObjectNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.util.RawValue;
import org.apache.flink.table.api.DataTypes;
import org.apache.flink.table.api.JsonOnNull;
import org.apache.flink.table.planner.codegen.CodeGenException;
import org.apache.flink.table.planner.codegen.CodeGenUtils$;
import org.apache.flink.table.planner.codegen.CodeGeneratorContext;
import org.apache.flink.table.planner.codegen.GeneratedExpression;
import org.apache.flink.table.planner.functions.sql.FlinkSqlOperatorTable;
import org.apache.flink.table.planner.utils.JavaScalaConversionUtil$;
import org.apache.flink.table.runtime.functions.SqlJsonUtils;
import org.apache.flink.table.runtime.typeutils.TypeCheckUtils;
import org.apache.flink.table.types.logical.ArrayType;
import org.apache.flink.table.types.logical.DistinctType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.LogicalTypeRoot;
import org.apache.flink.table.types.logical.MapType;
import org.apache.flink.table.types.logical.MultisetType;
import org.apache.flink.table.types.logical.utils.LogicalTypeChecks;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxesRunTime;

public final class JsonGenerateUtils$ {
    public static JsonGenerateUtils$ MODULE$;

    static {
        new JsonGenerateUtils$();
    }

    private String jsonUtils() {
        return CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(SqlJsonUtils.class));
    }

    public String createNodeTerm(CodeGeneratorContext ctx, GeneratedExpression expression, RexNode operand) {
        return this.isJsonFunctionOperand(operand) ? this.createRawNodeTerm(expression) : this.createNodeTerm(ctx, expression);
    }

    public String createNodeTerm(CodeGeneratorContext ctx, GeneratedExpression valueExpr) {
        return this.createNodeTerm(ctx, valueExpr.resultTerm(), valueExpr.resultType());
    }

    private String createNodeTerm(CodeGeneratorContext ctx, String valueTerm, LogicalType valueType) {
        String string;
        block16: {
            while (true) {
                String nodeFactoryTerm = new StringBuilder(17).append(this.jsonUtils()).append(".getNodeFactory()").toString();
                LogicalTypeRoot logicalTypeRoot = valueType.getTypeRoot();
                boolean bl = LogicalTypeRoot.CHAR.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARCHAR.equals(logicalTypeRoot);
                if (bl) {
                    string = new StringBuilder(22).append(nodeFactoryTerm).append(".textNode(").append(valueTerm).append(".toString())").toString();
                    break block16;
                }
                if (LogicalTypeRoot.BOOLEAN.equals(logicalTypeRoot)) {
                    string = new StringBuilder(14).append(nodeFactoryTerm).append(".booleanNode(").append(valueTerm).append(")").toString();
                    break block16;
                }
                if (LogicalTypeRoot.DECIMAL.equals(logicalTypeRoot)) {
                    string = new StringBuilder(28).append(nodeFactoryTerm).append(".numberNode(").append(valueTerm).append(".toBigDecimal())").toString();
                    break block16;
                }
                boolean bl2 = LogicalTypeRoot.TINYINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.SMALLINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.INTEGER.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.BIGINT.equals(logicalTypeRoot) ? true : (LogicalTypeRoot.FLOAT.equals(logicalTypeRoot) ? true : LogicalTypeRoot.DOUBLE.equals(logicalTypeRoot)))));
                if (bl2) {
                    string = new StringBuilder(13).append(nodeFactoryTerm).append(".numberNode(").append(valueTerm).append(")").toString();
                    break block16;
                }
                boolean bl3 = LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot) ? true : LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot);
                if (bl3) {
                    String string2;
                    String formatter = new StringBuilder(20).append(CodeGenUtils$.MODULE$.typeTerm(DateTimeFormatter.class)).append(".ISO_LOCAL_DATE_TIME").toString();
                    String isoTerm = new StringBuilder(27).append(valueTerm).append(".toLocalDateTime().format(").append(formatter).append(")").toString();
                    LogicalTypeRoot logicalTypeRoot2 = valueType.getTypeRoot();
                    if (LogicalTypeRoot.TIMESTAMP_WITHOUT_TIME_ZONE.equals(logicalTypeRoot2)) {
                        string2 = new StringBuilder(11).append(nodeFactoryTerm).append(".textNode(").append(isoTerm).append(")").toString();
                    } else if (LogicalTypeRoot.TIMESTAMP_WITH_LOCAL_TIME_ZONE.equals(logicalTypeRoot2)) {
                        string2 = new StringBuilder(17).append(nodeFactoryTerm).append(".textNode(").append(isoTerm).append(" + \"Z\")").toString();
                    } else {
                        throw new MatchError((Object)logicalTypeRoot2);
                    }
                    string = string2;
                    break block16;
                }
                if (LogicalTypeRoot.TIMESTAMP_WITH_TIME_ZONE.equals(logicalTypeRoot)) {
                    throw new CodeGenException("'TIMESTAMP WITH TIME ZONE' is not yet supported.");
                }
                boolean bl4 = LogicalTypeRoot.BINARY.equals(logicalTypeRoot) ? true : LogicalTypeRoot.VARBINARY.equals(logicalTypeRoot);
                if (bl4) {
                    string = new StringBuilder(13).append(nodeFactoryTerm).append(".binaryNode(").append(valueTerm).append(")").toString();
                    break block16;
                }
                if (LogicalTypeRoot.ARRAY.equals(logicalTypeRoot)) {
                    String converterName = this.generateArrayConverter(ctx, ((ArrayType)valueType).getElementType());
                    string = new StringBuilder(2).append(converterName).append("(").append(valueTerm).append(")").toString();
                    break block16;
                }
                boolean bl5 = LogicalTypeRoot.ROW.equals(logicalTypeRoot) ? true : LogicalTypeRoot.STRUCTURED_TYPE.equals(logicalTypeRoot);
                if (bl5) {
                    String converterName = this.generateRowConverter(ctx, valueType);
                    string = new StringBuilder(2).append(converterName).append("(").append(valueTerm).append(")").toString();
                    break block16;
                }
                if (LogicalTypeRoot.MAP.equals(logicalTypeRoot)) {
                    MapType mapType = (MapType)valueType;
                    String converterName = this.generateMapConverter(ctx, mapType.getKeyType(), mapType.getValueType());
                    string = new StringBuilder(2).append(converterName).append("(").append(valueTerm).append(")").toString();
                    break block16;
                }
                if (LogicalTypeRoot.MULTISET.equals(logicalTypeRoot)) {
                    String converterName = this.generateMapConverter(ctx, ((MultisetType)valueType).getElementType(), DataTypes.INT().getLogicalType());
                    string = new StringBuilder(2).append(converterName).append("(").append(valueTerm).append(")").toString();
                    break block16;
                }
                if (!LogicalTypeRoot.DISTINCT_TYPE.equals(logicalTypeRoot)) break;
                valueType = ((DistinctType)valueType).getSourceType();
            }
            throw new CodeGenException(new StringBuilder(55).append("Type '").append(valueType).append("' is not scalar or cannot be converted into JSON.").toString());
        }
        return string;
    }

    private String createNullableNodeTerm(CodeGeneratorContext ctx, String containerTerm, String indexTerm, LogicalType fieldType) {
        String nodeFactoryTerm = new StringBuilder(17).append(this.jsonUtils()).append(".getNodeFactory()").toString();
        String fieldAccessTerm = CodeGenUtils$.MODULE$.rowFieldReadAccess(indexTerm, containerTerm, fieldType);
        String valueNodeTerm = this.createNodeTerm(ctx, fieldAccessTerm, fieldType);
        return fieldType.isNullable() ? new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(84).append("\n         |").append(containerTerm).append(".isNullAt(").append(indexTerm).append(") ?\n         |    (").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(JsonNode.class))).append(") ").append(nodeFactoryTerm).append(".nullNode() :\n         |    (").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(JsonNode.class))).append(") ").append(valueNodeTerm).append("\n         |").toString())).stripMargin() : valueNodeTerm;
    }

    private String createRawNodeTerm(GeneratedExpression valueExpr) {
        return new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(80).append("\n       |").append(this.jsonUtils()).append(".getNodeFactory().rawValueNode(\n       |    new ").append(CodeGenUtils$.MODULE$.typeTerm(RawValue.class)).append("(").append(valueExpr.resultTerm()).append(".toString()))\n       |").toString())).stripMargin();
    }

    public JsonOnNull getOnNullBehavior(GeneratedExpression operand) {
        JsonOnNull jsonOnNull;
        Some some;
        Object onNull;
        Option<Object> option = operand.literalValue();
        if (!(option instanceof Some) || !((onNull = (some = (Some)option).value()) instanceof JsonOnNull)) {
            throw new CodeGenException(new StringBuilder(30).append("Expected operand to be of type").append(new StringBuilder(3).append("'").append(CodeGenUtils$.MODULE$.typeTerm(JsonOnNull.class)).append("''").toString()).toString());
        }
        JsonOnNull jsonOnNull2 = jsonOnNull = (JsonOnNull)onNull;
        return jsonOnNull2;
    }

    public boolean isJsonFunctionOperand(RexNode operand) {
        boolean bl;
        RexNode rexNode = operand;
        if (rexNode instanceof RexCall) {
            boolean bl2;
            RexCall rexCall = (RexCall)rexNode;
            SqlOperator sqlOperator = rexCall.getOperator();
            SqlFunction sqlFunction = FlinkSqlOperatorTable.JSON_OBJECT;
            SqlOperator sqlOperator2 = sqlOperator;
            if (!(sqlFunction != null ? !((Object)sqlFunction).equals(sqlOperator2) : sqlOperator2 != null)) {
                bl2 = true;
            } else {
                SqlFunction sqlFunction2 = FlinkSqlOperatorTable.JSON_ARRAY;
                SqlOperator sqlOperator3 = sqlOperator;
                bl2 = !(sqlFunction2 != null ? !((Object)sqlFunction2).equals(sqlOperator3) : sqlOperator3 != null);
            }
            boolean bl3 = bl2;
            bl = bl3;
        } else {
            bl = false;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    private String generateArrayConverter(CodeGeneratorContext ctx, LogicalType elementType) {
        void var3_3;
        String methodName = CodeGenUtils$.MODULE$.newName("convertArray");
        String methodCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(258).append("\n         |private ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ArrayNode.class))).append(" ").append(methodName).append("(").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" arrData) {\n         |    ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ArrayNode.class))).append(" arrNode = ").append(this.jsonUtils()).append(".getNodeFactory().arrayNode();\n         |    for (int i = 0; i < arrData.size(); i++) {\n         |        arrNode.add(").append(this.createNullableNodeTerm(ctx, "arrData", "i", elementType)).append(");\n         |    }\n         |\n         |    return arrNode;\n         |}\n         |").toString())).stripMargin();
        ctx.addReusableMember(methodCode);
        return var3_3;
    }

    private String generateRowConverter(CodeGeneratorContext ctx, LogicalType rowType) {
        Seq fieldNames = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeChecks.getFieldNames((LogicalType)rowType));
        Seq fieldTypes = JavaScalaConversionUtil$.MODULE$.toScala(LogicalTypeChecks.getFieldTypes((LogicalType)rowType));
        String populateObjectCode = ((TraversableOnce)((TraversableLike)fieldNames.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Tuple2 tuple2 = x0$1;
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            String fieldName = (String)tuple2._1();
            int idx = tuple2._2$mcI$sp();
            LogicalType fieldType = (LogicalType)fieldTypes.apply(idx);
            String string = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(77).append("\n           |objNode.set(\n           |    \"").append(fieldName).append("\",\n           |    ").append(MODULE$.createNullableNodeTerm(ctx, "rowData", ((Object)BoxesRunTime.boxToInteger((int)idx)).toString(), fieldType)).append(");\n           |").toString())).stripMargin();
            return string;
        }, Seq$.MODULE$.canBuildFrom())).mkString();
        String methodName = CodeGenUtils$.MODULE$.newName("convertRow");
        String methodCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(168).append("\n         |private ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ObjectNode.class))).append(" ").append(methodName).append("(").append(CodeGenUtils$.MODULE$.ROW_DATA()).append(" rowData) {\n         |    ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ObjectNode.class))).append(" objNode = ").append(this.jsonUtils()).append(".getNodeFactory().objectNode();\n         |    ").append(populateObjectCode).append("\n         |\n         |    return objNode;\n         |}\n         |").toString())).stripMargin();
        ctx.addReusableMember(methodCode);
        return methodName;
    }

    private String generateMapConverter(CodeGeneratorContext ctx, LogicalType keyType, LogicalType valueType) {
        if (!TypeCheckUtils.isCharacterString((LogicalType)keyType)) {
            throw new CodeGenException(new StringBuilder(86).append("Type '").append(keyType).append("' is not supported for JSON conversion. ").append("The key type must be a character string.").toString());
        }
        String methodName = CodeGenUtils$.MODULE$.newName("convertMap");
        String methodCode = new StringOps(Predef$.MODULE$.augmentString(new StringBuilder(764).append("\n         |private ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ObjectNode.class))).append(" ").append(methodName).append("(").append(CodeGenUtils$.MODULE$.MAP_DATA()).append(" mapData) {\n         |    ").append(CodeGenUtils$.MODULE$.className(ManifestFactory$.MODULE$.classType(ObjectNode.class))).append(" objNode = ").append(this.jsonUtils()).append(".getNodeFactory().objectNode();\n         |    for (int i = 0; i < mapData.size(); i++) {\n         |        ").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" keyArray = mapData.keyArray();\n         |        ").append(CodeGenUtils$.MODULE$.ARRAY_DATA()).append(" valueArray = mapData.valueArray();\n         |        java.lang.String key = keyArray.isNullAt(i) ? null :\n         |          ").append(CodeGenUtils$.MODULE$.rowFieldReadAccess("i", "keyArray", keyType)).append(".toString();\n         |        if (key == null) {\n         |            throw new java.lang.IllegalArgumentException(\"Key at index \" + i\n         |                + \" was null. This is not supported during conversion to JSON.\");\n         |        }\n         |\n         |        objNode.set(\n         |            key,\n         |            ").append(this.createNullableNodeTerm(ctx, "valueArray", "i", valueType)).append(");\n         |    }\n         |\n         |    return objNode;\n         |}\n         |").toString())).stripMargin();
        ctx.addReusableMember(methodCode);
        return methodName;
    }

    private JsonGenerateUtils$() {
        MODULE$ = this;
    }
}

